/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastInnerCompactionPerformerTest
extends AbstractCompactionTest {
    private boolean enableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(512L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(100L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(10);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(this.enableUnseqSpaceCompaction);
    }

    @Test
    public void testSeqInnerSpaceCompactionWithSameTimeseries() throws Exception {
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, false, true);
        MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d1", "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64));
        SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
        int count = 0;
        while (tsBlockReader.hasNextBatch()) {
            TsBlock block = tsBlockReader.nextBatch();
            TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
            while (iterator.hasNext()) {
                Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                ++count;
                iterator.next();
            }
        }
        tsBlockReader.close();
        Assert.assertEquals((long)500L, (long)count);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(true);
        tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
        count = 0;
        while (tsBlockReader.hasNextBatch()) {
            TsBlock block = tsBlockReader.nextBatch();
            TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
            while (iterator.hasNext()) {
                Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                ++count;
                iterator.next();
            }
        }
        tsBlockReader.close();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testSeqInnerSpaceCompactionWithDifferentTimeseries() throws Exception {
        int i;
        this.registerTimeseriesInMManger(5, 5, false);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, false, true);
        this.createFiles(2, 5, 6, 50, 600, 800, 50, 50, false, true);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        List targetResources = this.tsFileManager.getTsFileList(true);
        this.validateSeqFiles(true);
        Assert.assertEquals((long)0L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
        Assert.assertEquals((long)0L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
        Assert.assertEquals((long)250L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
        Assert.assertEquals((long)600L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
        Assert.assertEquals((long)600L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((long)749L, (long)((TsFileResource)targetResources.get(0)).getEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + i)));
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i >= 5 || j >= 5) continue;
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testSeqInnerSpaceCompactionWithFileTimeIndex() throws Exception {
        int i;
        this.registerTimeseriesInMManger(5, 5, false);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, false, true);
        this.createFiles(2, 5, 6, 50, 600, 800, 50, 50, false, true);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        for (TsFileResource resource : this.seqResources) {
            resource.degradeTimeIndex();
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.degradeTimeIndex();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        List targetResources = this.tsFileManager.getTsFileList(true);
        this.validateSeqFiles(true);
        Assert.assertEquals((long)0L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
        Assert.assertEquals((long)0L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
        Assert.assertEquals((long)250L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
        Assert.assertEquals((long)600L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
        Assert.assertEquals((long)600L, (long)((TsFileResource)targetResources.get(0)).getStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((long)749L, (long)((TsFileResource)targetResources.get(0)).getEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + i)));
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i >= 5 || j >= 5) continue;
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithSameTimeseries() throws Exception {
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, false, false);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s1", (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        List targetResources = this.tsFileManager.getTsFileList(false);
        this.validateSeqFiles(false);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s1", (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithDifferentTimeseries() throws Exception {
        this.registerTimeseriesInMManger(9, 9, false);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, false, false);
        this.createFiles(2, 3, 5, 50, 150, 150, 50, 50, false, false);
        this.createFiles(2, 5, 5, 50, 100, 100, 100, 100, false, false);
        this.createFiles(2, 7, 7, 70, 200, 300, 100, 100, false, false);
        this.createFiles(2, 9, 9, 70, 100, 300, 100, 100, false, false);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (100L <= iterator.currentTime() && iterator.currentTime() < 170L || 270L <= iterator.currentTime() && iterator.currentTime() < 340L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        } else if (200L <= iterator.currentTime() && iterator.currentTime() < 270L || 370L <= iterator.currentTime() && iterator.currentTime() < 440L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)410L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)310L, (long)count);
                    continue;
                }
                if (i < 5 && j < 5) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                if (i < 7 && j < 7) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)140L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(true);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (100L <= iterator.currentTime() && iterator.currentTime() < 170L || 270L <= iterator.currentTime() && iterator.currentTime() < 340L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        } else if (200L <= iterator.currentTime() && iterator.currentTime() < 270L || 370L <= iterator.currentTime() && iterator.currentTime() < 440L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)410L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)310L, (long)count);
                    continue;
                }
                if (i < 5 && j < 5) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                if (i < 7 && j < 7) {
                    Assert.assertEquals((long)280L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)140L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithAllDataDeletedInTimeseries() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, false, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, false, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, false, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + 0 + '.' + "s0", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + 0 + '.' + "s1", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + 2 + '.' + "s4", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + 3 + '.' + "s5", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 && j == 0 || i == 0 && j == 1 || i == 2 && j == 4 || i == 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(false);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == 0 && j == 0 || i2 == 0 && j == 1 || i2 == 2 && j == 4 || i2 == 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithAllDataDeletedInDevice() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, false, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, false, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, false, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (int j = 0; j < 7; ++j) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + 0 + '.' + "s" + j, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(false);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == 0) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testUnSeqInnerSpaceCompactionWithAllDataDeletedInTargetFile() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, false, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, false, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, false, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (int d = 0; d < 5; ++d) {
                for (int j = 0; j < 7; ++j) {
                    deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + d + '.' + "s" + j, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
                }
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)0L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(true);
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedSeqInnerSpaceCompactionWithSameTimeseries() throws Exception {
        this.registerTimeseriesInMManger(2, 3, true);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, true, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        List targetResources = this.tsFileManager.getTsFileList(true);
        this.validateSeqFiles(true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedSeqInnerSpaceCompactionWithDifferentTimeseriesAndEmptyPage() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(50);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, true, true);
        this.createFiles(2, 5, 8, 50, 600, 800, 50, 50, true, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedSeqInnerSpaceCompactionWithDifferentTimeseriesAndEmptyChunk() throws Exception {
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 100, 0, 0, 50, 50, true, true);
        this.createFiles(2, 3, 5, 50, 250, 250, 50, 50, true, true);
        this.createFiles(2, 5, 7, 50, 600, 800, 50, 50, true, true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(true);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), false);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() >= 600L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithEmptyChunkAndEmptyPage() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, true, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, true, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, true, false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithAllDataDeletedInTimeseries() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, true, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, true, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, true, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s0", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s1", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s4", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s5", new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(false);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 5) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithAllDataDeletedInDevice() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 0, 0, true, false);
        this.createFiles(2, 3, 5, 300, 200, 300, 50, 50, true, false);
        this.createFiles(2, 5, 7, 300, 900, 1100, 50, 50, true, false);
        for (i = 0; i < this.unseqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            for (int j = 0; j < 7; ++j) {
                deleteMap.put(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + j, (Pair<Long, Long>)new Pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE));
            }
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.unseqResources.get(i), false);
        }
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(false);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 5; ++i2) {
            for (int j = 0; j < 7; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (iterator.currentTime() < 200L || iterator.currentTime() < 550L && iterator.currentTime() >= 500L) {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (iterator.currentTime() < 850L) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 100L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)(iterator.currentTime() + 200L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1450L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 5) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedUnSeqInnerSpaceCompactionWithSameTimeseries() throws Exception {
        this.registerTimeseriesInMManger(2, 3, true);
        this.createFiles(5, 2, 3, 100, 0, 0, 50, 50, true, false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        this.validateSeqFiles(false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.tsFileManager.getTsFileList(true), this.tsFileManager.getTsFileList(false), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testMergeAlignedSeriesTimeValuePairFromDifferentFiles() throws IOException, IllegalPathException {
        TsFileResource resource1 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3", "s4", "s5"), new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(true, true, true, false, false));
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource resource2 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3", "s4", "s5"), new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(true, true, false, true, true));
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource resource3 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource3);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3", "s4", "s5"), new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(false, true, true, true, true));
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource resource4 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(resource4);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3", "s4", "s5"), new TimeRange[]{new TimeRange(10L, 20L)}, TSEncoding.PLAIN, CompressionType.LZ4, Arrays.asList(true, false, true, true, true));
            writer.endChunkGroup();
            writer.endFile();
        }
        this.unseqResources.add(resource1);
        this.unseqResources.add(resource2);
        this.unseqResources.add(resource3);
        this.unseqResources.add(resource4);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetResource = (TsFileResource)this.tsFileManager.getTsFileList(false).get(0);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(targetResource.getTsFilePath());){
            List chunkMetadataList = reader.getAlignedChunkMetadata((IDeviceID)new PlainDeviceID("root.testsg.d1"));
            for (AlignedChunkMetadata alignedChunkMetadata : chunkMetadataList) {
                ChunkMetadata timeChunkMetadata = (ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata();
                Chunk timeChunk = reader.readMemChunk(timeChunkMetadata);
                ArrayList<Chunk> valueChunks = new ArrayList<Chunk>();
                for (IChunkMetadata chunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                    Chunk valueChunk = reader.readMemChunk((ChunkMetadata)chunkMetadata);
                    valueChunks.add(valueChunk);
                }
                AlignedChunkReader alignedChunkReader = new AlignedChunkReader(timeChunk, valueChunks, null);
                while (alignedChunkReader.hasNextSatisfiedPage()) {
                    BatchData batchData = alignedChunkReader.nextPageData();
                    BatchData.BatchDataIterator pointReader = batchData.getBatchDataIterator();
                    while (pointReader.hasNextTimeValuePair()) {
                        TimeValuePair timeValuePair = pointReader.nextTimeValuePair();
                        for (Object value : timeValuePair.getValues()) {
                            if (value != null) continue;
                            Assert.fail();
                        }
                    }
                }
            }
        }
    }
}

