/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.SeriesDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskQueue;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionWorker;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.tools.validate.TsFileValidationTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastCrossCompactionPerformerTest
extends AbstractCompactionTest {
    private List<TsFileResource> targetResources = new ArrayList<TsFileResource>();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(512L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(100L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(10);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.validateSeqFiles();
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        this.targetResources.clear();
    }

    @Test
    public void testCrossSpaceCompactionWithSameTimeseries() throws Exception {
        this.registerTimeseriesInMManger(2, 3, false);
        this.createFiles(5, 2, 3, 100, 0, 0, 0, 0, false, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, false, false);
        MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d1", "s1", (IMeasurementSchema)new MeasurementSchema("s1", TSDataType.INT64));
        SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
        int count = 0;
        while (tsBlockReader.hasNextBatch()) {
            TsBlock block = tsBlockReader.nextBatch();
            TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
            while (iterator.hasNext()) {
                if (iterator.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                } else {
                    Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                }
                ++count;
                iterator.next();
            }
        }
        tsBlockReader.close();
        Assert.assertEquals((long)500L, (long)count);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
        count = 0;
        while (tsBlockReader.hasNextBatch()) {
            TsBlock block = tsBlockReader.nextBatch();
            TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
            while (iterator.hasNext()) {
                if (iterator.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                } else {
                    Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                }
                ++count;
                iterator.next();
            }
        }
        tsBlockReader.close();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCrossSpaceCompactionWithDifferentTimeseries() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (i2 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, iterator.currentTime());
                        if (i3 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i3 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInTimeseries() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s0");
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s1");
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d2" + '.' + "s4");
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d3" + '.' + "s4");
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (i2 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == 0 && j == 0 || i2 == 0 && j == 1 || i2 == 2 && j == 4 || i2 == 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, iterator.currentTime());
                        if (i3 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i3 == 0 && j == 0 || i3 == 0 && j == 1 || i3 == 2 && j == 4 || i3 == 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i3 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInDevice() throws Exception {
        int i;
        int i2;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i2 = 0; i2 < 5; ++i2) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i2);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i2);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (i2 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == 0 || i2 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        for (i = 0; i < 2; ++i) {
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (i = 2; i < 4; ++i) {
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, iterator.currentTime());
                        if (i3 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i3 == 0 || i3 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInOneTargetFile() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (i == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        this.targetResources.removeIf(x -> x.isDeleted());
        Assert.assertEquals((long)2L, (long)this.targetResources.size());
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (int i2 = 0; i2 < 2; ++i2) {
            Assert.assertFalse((boolean)this.targetResources.get(i2).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertFalse((boolean)this.targetResources.get(i2).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i2).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i2).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i2), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, iterator.currentTime());
                        if (i3 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i3 == 0 || i3 == 1 || i3 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithAllDataDeletedInDeviceInSeqFiles() throws IOException, WriteProcessException, MetadataException, Exception {
        int i;
        int i2;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i2 = 0; i2 < 5; ++i2) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i2);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i2);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i2);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        for (i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (i2 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 < 1) {
                    if (j < 4) {
                        Assert.assertEquals((long)630L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i2 < 3) {
                    if (j < 4) {
                        Assert.assertEquals((long)600L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)4L, (long)this.targetResources.size());
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (i = 2; i < 3; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.clear();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (i = 3; i < 4; ++i) {
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, iterator.currentTime());
                        if (i3 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i3 < 1) {
                    if (j < 4) {
                        Assert.assertEquals((long)630L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)200L, (long)count);
                    continue;
                }
                if (i3 < 3) {
                    if (j < 4) {
                        Assert.assertEquals((long)600L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithNewDeviceInUnseqFile() {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        try {
            int i;
            this.registerTimeseriesInMManger(6, 6, false);
            this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
            this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
            this.createFiles(3, 6, 6, 200, 20, 10020, 30, 30, false, false);
            this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
            List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
            FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
            performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            performer.perform();
            Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
            Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
            CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
            Assert.assertEquals((long)4L, (long)targetResources.size());
            ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
            for (i = 0; i < 2; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                this.check(targetResources.get(i), deviceIdList);
            }
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
            for (i = 2; i < 3; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                this.check(targetResources.get(i), deviceIdList);
            }
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d5"));
            for (i = 3; i < 4; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d5")));
                this.check(targetResources.get(i), deviceIdList);
            }
        }
        catch (IOException | InterruptedException | MetadataException | StorageEngineException | WriteProcessException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testCrossSpaceCompactionWithDeviceMaxTimeLaterInUnseqFile() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        try {
            int i;
            this.registerTimeseriesInMManger(6, 6, false);
            this.createFiles(2, 2, 3, 200, 0, 0, 0, 0, false, true);
            this.createFiles(3, 4, 4, 300, 20, 10020, 0, 0, false, false);
            List<TsFileResource> targetResources = CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources);
            FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, targetResources);
            performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
            performer.perform();
            Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
            Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
            CompactionUtils.moveTargetFile(targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
            Assert.assertEquals((long)2L, (long)targetResources.size());
            ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
            for (i = 0; i < 1; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertFalse((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                this.check(targetResources.get(i), deviceIdList);
            }
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
            deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
            for (i = 1; i < 2; ++i) {
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                this.check(targetResources.get(i), deviceIdList);
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                    SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), targetResources, new ArrayList(), true);
                    int count = 0;
                    while (tsBlockReader.hasNextBatch()) {
                        TsBlock block = tsBlockReader.nextBatch();
                        TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                        while (iterator.hasNext()) {
                            if (iterator.currentTime() < 20L) {
                                Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                            } else {
                                Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                            }
                            ++count;
                            iterator.next();
                        }
                    }
                    tsBlockReader.close();
                    if (i < 2 && j < 3) {
                        Assert.assertEquals((long)920L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)900L, (long)count);
                }
            }
        }
        catch (IOException | InterruptedException | MetadataException | StorageEngineException | WriteProcessException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithSameTimeseries() throws Exception {
        this.registerTimeseriesInMManger(2, 3, true);
        this.createFiles(5, 2, 3, 100, 0, 0, 0, 0, true, true);
        this.createFiles(5, 2, 3, 50, 0, 10000, 50, 50, true, false);
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        schemas.add(new MeasurementSchema("s1", TSDataType.INT64));
        AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d10000", Collections.singletonList("s1"), schemas);
        SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
        int count = 0;
        while (tsBlockReader.hasNextBatch()) {
            TsBlock block = tsBlockReader.nextBatch();
            TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
            while (iterator.hasNext()) {
                if (iterator.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                } else {
                    Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                }
                ++count;
                iterator.next();
            }
        }
        tsBlockReader.close();
        Assert.assertEquals((long)500L, (long)count);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
        count = 0;
        while (tsBlockReader.hasNextBatch()) {
            TsBlock block = tsBlockReader.nextBatch();
            TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
            while (iterator.hasNext()) {
                if (iterator.currentTime() % 100L < 50L) {
                    Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                } else {
                    Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                }
                ++count;
                iterator.next();
            }
        }
        tsBlockReader.close();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithDifferentTimeseries() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithAllDataDeletedInTimeseries() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s0");
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s1");
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s4");
        seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3) + '.' + "s4");
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        Assert.assertEquals((long)4L, (long)this.targetResources.size());
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10000"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10001"));
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10000")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10001")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10002")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10003")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10002"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10003"));
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10000")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10001")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10002")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d10003")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 0 || i == TsFileGeneratorUtils.getAlignDeviceOffset() && j == 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j == 4 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j == 4) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset()) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithAllDataDeletedInOneTargetFile() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (i = 0; i < 5; ++i) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1) + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        for (i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        this.targetResources.removeIf(resource -> resource == null);
        for (int i2 = TsFileGeneratorUtils.getAlignDeviceOffset(); i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i2, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 == 0 || i2 == 1 || i2 == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithSameTimeseriesInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d0" + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d1" + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d2" + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.setDataType(TSDataType.TEXT);
        this.registerTimeseriesInMManger(2, 7, false);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        for (int i = 0; i < 2; ++i) {
            deviceIndex.add(i);
        }
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            measurementIndex.add(i);
        }
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 1350, 0, false, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        this.targetResources.removeIf(x -> x.isDeleted());
        Assert.assertEquals((long)2L, (long)this.targetResources.size());
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            TSDataType tsDataType = i < 2 ? TSDataType.TEXT : TSDataType.INT64;
            for (int j = 0; j < 7; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, tsDataType));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, iterator.currentTime());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < 2 && j < 7) {
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                if (i == 3 && j < 5) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithDifferentDevicesInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, false);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            measurementIndex.add(i);
        }
        deviceIndex.add(0);
        deviceIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, false, true);
        deviceIndex.clear();
        deviceIndex.add(1);
        deviceIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, false, true);
        deviceIndex.clear();
        deviceIndex.add(2);
        deviceIndex.add(4);
        deviceIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, false, true);
        deviceIndex.clear();
        deviceIndex.add(1);
        deviceIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, false, false);
        deviceIndex.clear();
        deviceIndex.add(1);
        deviceIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 400, 600, 0, false, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4"));
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
            } else if (i == 1) {
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.TEXT));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, iterator.currentTime());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 || i == 2 || i == 3) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i == 1) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithDifferentMeasurementsInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 5, false);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        for (int i = 0; i < 5; ++i) {
            deviceIndex.add(i);
        }
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, false, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, false, true);
        measurementIndex.clear();
        measurementIndex.add(2);
        measurementIndex.add(4);
        measurementIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, false, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, false, false);
        measurementIndex.clear();
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 400, 0, false, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d4")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.TEXT));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, iterator.currentTime());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (j == 0 || j == 2) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (j == 1 || j == 4) {
                    Assert.assertEquals((long)500L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)300L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithDifferentDevicesAndMeasurementsInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        deviceIndex.add(0);
        deviceIndex.add(1);
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, false, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, false, true);
        deviceIndex.add(2);
        deviceIndex.add(3);
        measurementIndex.clear();
        measurementIndex.add(2);
        measurementIndex.add(4);
        measurementIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, false, true);
        deviceIndex.remove(2);
        deviceIndex.remove(2);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, false, false);
        measurementIndex.clear();
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 600, 0, false, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (int i = 0; i < 3; ++i) {
            if (i < 2) {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.TEXT));
                SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_JOB_ID), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    TsBlock batchData = tsFilesReader.nextBatch();
                    int size = batchData.getPositionCount();
                    for (int readIndex = 0; readIndex < size; ++readIndex) {
                        long currentTime = batchData.getTimeByIndex(readIndex);
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j) >= currentTime) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, currentTime);
                        ++count;
                    }
                }
                tsFilesReader.close();
                if (i < 2) {
                    if (j == 0 || j == 2) {
                        Assert.assertEquals((long)800L, (long)count);
                        continue;
                    }
                    if (j == 1 || j == 4) {
                        Assert.assertEquals((long)500L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                if (j == 0 || j == 2 || j == 4) {
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithDifferentDevicesAndMeasurementsInDifferentSourceFiles2() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        deviceIndex.add(0);
        deviceIndex.add(1);
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, false, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, false, true);
        deviceIndex.add(2);
        deviceIndex.add(3);
        measurementIndex.clear();
        measurementIndex.add(2);
        measurementIndex.add(4);
        measurementIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, false, true);
        deviceIndex.remove(2);
        deviceIndex.remove(2);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, false, false);
        deviceIndex.remove(0);
        measurementIndex.clear();
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 600, 0, false, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (int i = 0; i < 3; ++i) {
            if (i < 2) {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.TEXT));
                SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_JOB_ID), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    TsBlock batchData = tsFilesReader.nextBatch();
                    int size = batchData.getPositionCount();
                    for (int readIndex = 0; readIndex < size; ++readIndex) {
                        long currentTime = batchData.getTimeByIndex(readIndex);
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j) >= currentTime) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i + '.' + "s" + j, currentTime);
                        ++count;
                    }
                }
                tsFilesReader.close();
                if (i < 2) {
                    if (j == 0 || j == 2) {
                        if (i == 0) {
                            Assert.assertEquals((long)600L, (long)count);
                            continue;
                        }
                        Assert.assertEquals((long)800L, (long)count);
                        continue;
                    }
                    if (j == 1 || j == 4) {
                        Assert.assertEquals((long)500L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                if (j == 0 || j == 2 || j == 4) {
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithSameTimeseriesInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1) + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        this.setDataType(TSDataType.TEXT);
        this.registerTimeseriesInMManger(2, 7, true);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        for (int i = 0; i < 2; ++i) {
            deviceIndex.add(i);
        }
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            measurementIndex.add(i);
        }
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 1450, 0, true, true);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 1350, 0, true, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        this.targetResources.removeIf(x -> x.isDeleted());
        Assert.assertEquals((long)3L, (long)this.targetResources.size());
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset()));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3)));
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
            } else if (i == 1) {
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            TSDataType tsDataType = i < 2 ? TSDataType.TEXT : TSDataType.INT64;
            for (int j = 0; j < 7; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, Long.MIN_VALUE);
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, tsDataType));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i), Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, iterator.currentTime());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i < 2 && j < 7) {
                    Assert.assertEquals((long)400L, (long)count);
                    continue;
                }
                if (i == 3 && j < 5) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithDifferentDevicesInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 7, true);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            measurementIndex.add(i);
        }
        deviceIndex.add(0);
        deviceIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, true, true);
        deviceIndex.clear();
        deviceIndex.add(1);
        deviceIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, true, true);
        deviceIndex.clear();
        deviceIndex.add(2);
        deviceIndex.add(4);
        deviceIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, true, true);
        deviceIndex.clear();
        deviceIndex.add(1);
        deviceIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, true, false);
        deviceIndex.clear();
        deviceIndex.add(1);
        deviceIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 400, 600, 0, true, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset()));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 4)));
        for (int i = 0; i < 3; ++i) {
            if (i == 0) {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 4))));
            } else if (i == 1) {
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 4))));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 4))));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, Long.MIN_VALUE);
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.TEXT));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i), Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, iterator.currentTime());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 || i == 2 || i == 3) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i == 1) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)500L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithDifferentMeasurementsInDifferentSourceFiles() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(5, 5, true);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        for (int i = 0; i < 5; ++i) {
            deviceIndex.add(i);
        }
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, true, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, true, true);
        measurementIndex.clear();
        measurementIndex.add(2);
        measurementIndex.add(4);
        measurementIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, true, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, true, false);
        measurementIndex.clear();
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 600, 0, true, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset()));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 4)));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 4))));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, Long.MIN_VALUE);
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.TEXT));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i), Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, iterator.currentTime());
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (j == 0 || j == 2) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (j == 1 || j == 4) {
                    Assert.assertEquals((long)500L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)300L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithDifferentDevicesAndMeasurementsInDifferentSourceFiles2() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        ArrayList<Integer> deviceIndex = new ArrayList<Integer>();
        ArrayList<Integer> measurementIndex = new ArrayList<Integer>();
        deviceIndex.add(0);
        deviceIndex.add(1);
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 0, 0, true, true);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(3);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 400, 0, true, true);
        deviceIndex.add(2);
        deviceIndex.add(3);
        measurementIndex.clear();
        measurementIndex.add(2);
        measurementIndex.add(4);
        measurementIndex.add(0);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 800, 0, true, true);
        deviceIndex.remove(2);
        deviceIndex.remove(2);
        measurementIndex.clear();
        measurementIndex.add(1);
        measurementIndex.add(4);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 200, 100, 0, true, false);
        deviceIndex.remove(0);
        measurementIndex.clear();
        measurementIndex.add(0);
        measurementIndex.add(2);
        this.createFilesWithTextValue(1, deviceIndex, measurementIndex, 300, 600, 0, true, false);
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset()));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2)));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3)));
        for (int i = 0; i < 3; ++i) {
            if (i < 2) {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
            } else {
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset())));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2))));
                Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 3))));
            }
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, Long.MIN_VALUE);
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.TEXT));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i), Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsFilesReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsFilesReader.hasNextBatch()) {
                    TsBlock batchData = tsFilesReader.nextBatch();
                    int size = batchData.getPositionCount();
                    for (int readIndex = 0; readIndex < size; ++readIndex) {
                        long currentTime = batchData.getTimeByIndex(readIndex);
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j) >= currentTime) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + i) + '.' + "s" + j, currentTime);
                        ++count;
                    }
                }
                tsFilesReader.close();
                if (i < 2) {
                    if (j == 0 || j == 2) {
                        if (i == 0) {
                            Assert.assertEquals((long)600L, (long)count);
                            continue;
                        }
                        Assert.assertEquals((long)800L, (long)count);
                        continue;
                    }
                    if (j == 1 || j == 4) {
                        Assert.assertEquals((long)500L, (long)count);
                        continue;
                    }
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                if (j == 0 || j == 2 || j == 4) {
                    Assert.assertEquals((long)300L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testAlignedCrossSpaceCompactionWithFileTimeIndexResource() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, true);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, true, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, true, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, true, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, true, false);
        ArrayList<String> seriesPaths = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + TsFileGeneratorUtils.getAlignDeviceOffset() + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 1) + '.' + "s" + i);
            seriesPaths.add(COMPACTION_TEST_SG + '.' + "d" + (TsFileGeneratorUtils.getAlignDeviceOffset() + 2) + '.' + "s" + i);
        }
        this.generateModsFile(seriesPaths, this.seqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.generateModsFile(seriesPaths, this.unseqResources, Long.MIN_VALUE, Long.MAX_VALUE);
        this.deleteTimeseriesInMManager(seriesPaths);
        for (TsFileResource resource2 : this.seqResources) {
            resource2.degradeTimeIndex();
        }
        for (TsFileResource resource2 : this.unseqResources) {
            resource2.degradeTimeIndex();
        }
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        this.targetResources.removeIf(resource -> resource == null);
        for (int i = TsFileGeneratorUtils.getAlignDeviceOffset(); i < TsFileGeneratorUtils.getAlignDeviceOffset() + 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
                schemas.add(new MeasurementSchema("s" + j, TSDataType.INT64));
                AlignedPath path = new AlignedPath(COMPACTION_TEST_SG + '.' + "d" + i, Collections.singletonList("s" + j), schemas);
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockAlignedRowIterator iterator = block.getTsBlockAlignedRowIterator();
                    while (iterator.hasNext()) {
                        if (i == TsFileGeneratorUtils.getAlignDeviceOffset() && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)((TsPrimitiveType[])iterator.currentValue())[0].getValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i == 0 || i == 1 || i == 2) {
                    Assert.assertEquals((long)0L, (long)count);
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 || i == TsFileGeneratorUtils.getAlignDeviceOffset() + 2) {
                    Assert.assertEquals((long)0L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i == TsFileGeneratorUtils.getAlignDeviceOffset() + 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i < TsFileGeneratorUtils.getAlignDeviceOffset() + 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    @Test
    public void testCrossSpaceCompactionWithFileTimeIndex() throws Exception {
        int i;
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        this.registerTimeseriesInMManger(4, 5, false);
        this.createFiles(2, 2, 3, 300, 0, 0, 50, 50, false, true);
        this.createFiles(2, 4, 5, 300, 700, 700, 50, 50, false, true);
        this.createFiles(3, 3, 4, 200, 20, 10020, 30, 30, false, false);
        this.createFiles(2, 1, 5, 100, 450, 20450, 0, 0, false, false);
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 5; ++j) {
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i2, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.seqResources, this.unseqResources, true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if (i2 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i2 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i2 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i2 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i2 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i2 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i2 < 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
        for (TsFileResource resource : this.seqResources) {
            resource.degradeTimeIndex();
        }
        for (TsFileResource resource : this.unseqResources) {
            resource.degradeTimeIndex();
        }
        this.targetResources.addAll(CompactionFileGeneratorUtils.getCrossCompactionTargetTsFileResources(this.seqResources));
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FastCompactionPerformer performer = new FastCompactionPerformer(this.seqResources, this.unseqResources, this.targetResources);
        performer.setSummary((CompactionTaskSummary)new FastCompactionTaskSummary());
        performer.perform();
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getClosedFileReaderMap().size());
        Assert.assertEquals((long)0L, (long)FileReaderManager.getInstance().getUnclosedFileReaderMap().size());
        CompactionUtils.moveTargetFile(this.targetResources, (boolean)false, (String)COMPACTION_TEST_SG);
        this.tsFileManager.addAll(this.targetResources, true);
        this.targetResources.get(3).degradeTimeIndex();
        this.targetResources.get(2).degradeTimeIndex();
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap((List)this.tsFileManager.getOrCreateSequenceListByTimePartition(0L).getArrayList()));
        ArrayList<IDeviceID> deviceIdList = new ArrayList<IDeviceID>();
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1"));
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertFalse((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2"));
        deviceIdList.add((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3"));
        for (i = 2; i < 4; ++i) {
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d0")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d1")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d2")));
            Assert.assertTrue((boolean)this.targetResources.get(i).isDeviceIdExist((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + '.' + "d3")));
            this.check(this.targetResources.get(i), deviceIdList);
        }
        HashMap<String, Long> measurementMaxTime = new HashMap<String, Long>();
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j = 0; j < 5; ++j) {
                measurementMaxTime.putIfAbsent(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, Long.MIN_VALUE);
                MeasurementPath path = new MeasurementPath(COMPACTION_TEST_SG + '.' + "d" + i3, "s" + j, (IMeasurementSchema)new MeasurementSchema("s" + j, TSDataType.INT64));
                SeriesDataBlockReader tsBlockReader = new SeriesDataBlockReader((PartialPath)path, FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)EnvironmentUtils.TEST_QUERY_CONTEXT.getQueryId()), this.targetResources, new ArrayList(), true);
                int count = 0;
                while (tsBlockReader.hasNextBatch()) {
                    TsBlock block = tsBlockReader.nextBatch();
                    TsBlock.TsBlockSingleColumnIterator iterator = block.getTsBlockSingleColumnIterator();
                    while (iterator.hasNext()) {
                        if ((Long)measurementMaxTime.get(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j) >= iterator.currentTime()) {
                            Assert.fail();
                        }
                        measurementMaxTime.put(COMPACTION_TEST_SG + '.' + "d" + i3 + '.' + "s" + j, iterator.currentTime());
                        if (i3 == 0 && (450L <= iterator.currentTime() && iterator.currentTime() < 550L || 550L <= iterator.currentTime() && iterator.currentTime() < 650L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 20000L), (Object)iterator.currentValue());
                        } else if (i3 < 3 && j < 4 && (20L <= iterator.currentTime() && iterator.currentTime() < 220L || 250L <= iterator.currentTime() && iterator.currentTime() < 450L || 480L <= iterator.currentTime() && iterator.currentTime() < 680L)) {
                            Assert.assertEquals((Object)(iterator.currentTime() + 10000L), (Object)iterator.currentValue());
                        } else {
                            Assert.assertEquals((Object)iterator.currentTime(), (Object)iterator.currentValue());
                        }
                        ++count;
                        iterator.next();
                    }
                }
                tsBlockReader.close();
                if (i3 < 2 && j < 3) {
                    Assert.assertEquals((long)1280L, (long)count);
                    continue;
                }
                if (i3 < 1 && j < 4) {
                    Assert.assertEquals((long)1230L, (long)count);
                    continue;
                }
                if (i3 == 0) {
                    Assert.assertEquals((long)800L, (long)count);
                    continue;
                }
                if (i3 == 1 && j == 4) {
                    Assert.assertEquals((long)600L, (long)count);
                    continue;
                }
                if (i3 < 3 && j < 4) {
                    Assert.assertEquals((long)1200L, (long)count);
                    continue;
                }
                Assert.assertEquals((long)600L, (long)count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseFileNumAndMemoryAfterCrossTask() throws IOException, MetadataException, WriteProcessException, InterruptedException {
        int oldMaxCrossCompactionCandidateFileNum = SystemInfo.getInstance().getTotalFileLimitForCompaction();
        SystemInfo.getInstance().setTotalFileLimitForCompactionTask(15);
        SystemInfo.getInstance().getCompactionFileNumCost().set(0);
        SystemInfo.getInstance().getCompactionMemoryCost().set(0L);
        try {
            this.createFiles(6, 2, 3, 300, 0, 0, 50, 50, false, true);
            this.createFiles(6, 2, 3, 300, 0, 0, 50, 50, false, false);
            this.tsFileManager.addAll(this.seqResources, true);
            this.tsFileManager.addAll(this.unseqResources, false);
            CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 1000L, 0L);
            Assert.assertTrue((boolean)task.setSourceFilesToCompactionCandidate());
            CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
            queue.put((Object)task);
            CompactionWorker worker = new CompactionWorker(0, (FixedPriorityBlockingQueue)queue);
            AbstractCompactionTask takeTask = (AbstractCompactionTask)queue.take();
            Assert.assertNotNull((Object)takeTask);
            worker.processOneCompactionTask(takeTask);
            Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
            Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        }
        finally {
            SystemInfo.getInstance().setTotalFileLimitForCompactionTask(oldMaxCrossCompactionCandidateFileNum);
        }
    }

    private void validateSeqFiles() {
        TsFileValidationTool.clearMap((boolean)true);
        ArrayList<File> files = new ArrayList<File>();
        for (TsFileResource resource : this.targetResources) {
            files.add(resource.getTsFile());
        }
        TsFileValidationTool.findUncorrectFiles(files);
        Assert.assertEquals((long)0L, (long)TsFileValidationTool.badFileNum);
    }
}

