/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastCompactionPerformerWithInconsistentCompressionTypeAndEncodingTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(0);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void test1() throws MetadataException, IOException, WriteProcessException {
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource unseqResource = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[]{new TimeRange(210000L, 290000L), new TimeRange(710000L, 890000L)}, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, true);
        this.unseqResources.add(unseqResource);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getTsFilePath());
        this.validateSingleTsFileWithNonAlignedSeries(reader);
    }

    @Test
    public void test2() throws MetadataException, IOException, WriteProcessException {
        TimeRange[] file1Chunk1 = new TimeRange[]{new TimeRange(10000L, 15000L), new TimeRange(16000L, 19000L), new TimeRange(20000L, 29000L)};
        TimeRange[] file1Chunk2 = new TimeRange[]{new TimeRange(30000L, 35000L), new TimeRange(36000L, 39000L), new TimeRange(40000L, 49000L)};
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[][]{file1Chunk1, file1Chunk2}, TSEncoding.PLAIN, CompressionType.LZ4, true);
        this.seqResources.add(seqResource1);
        TimeRange[] file2Chunk1 = new TimeRange[]{new TimeRange(50000L, 55000L), new TimeRange(56000L, 59000L), new TimeRange(60000L, 69000L)};
        TimeRange[] file2Chunk2 = new TimeRange[]{new TimeRange(70000L, 75000L), new TimeRange(76000L, 79000L), new TimeRange(180000L, 189000L)};
        TsFileResource seqResource2 = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[][]{file2Chunk1, file2Chunk2}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TimeRange[] unseqFileChunk1 = new TimeRange[]{new TimeRange(1000L, 5000L), new TimeRange(96000L, 99000L), new TimeRange(100000L, 110000L)};
        TimeRange[] unseqFileChunk2 = new TimeRange[]{new TimeRange(120000L, 130000L), new TimeRange(136000L, 149000L), new TimeRange(200000L, 210000L)};
        TsFileResource unseqResource = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[][]{unseqFileChunk1, unseqFileChunk2}, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, true);
        this.unseqResources.add(unseqResource);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getTsFilePath());
        this.validateSingleTsFileWithNonAlignedSeries(reader);
    }

    @Test
    public void test3() throws MetadataException, IOException, WriteProcessException {
        TimeRange[] file1Chunk1Page1 = new TimeRange[]{new TimeRange(10000L, 12000L), new TimeRange(16000L, 19000L)};
        TimeRange[] file1Chunk1Page2 = new TimeRange[]{new TimeRange(30000L, 35000L), new TimeRange(36000L, 39000L)};
        TsFileResource seqResource1 = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[][][]{{file1Chunk1Page1, file1Chunk1Page2}}, TSEncoding.PLAIN, CompressionType.LZ4, true);
        this.seqResources.add(seqResource1);
        TimeRange[] file2Chunk1Page1 = new TimeRange[]{new TimeRange(50000L, 55000L), new TimeRange(56000L, 59000L), new TimeRange(68000L, 69000L)};
        TimeRange[] file2Chunk1Page2 = new TimeRange[]{new TimeRange(70000L, 75000L), new TimeRange(76000L, 79000L), new TimeRange(180000L, 181000L)};
        TsFileResource seqResource2 = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[][][]{{file2Chunk1Page1, file2Chunk1Page2}}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TimeRange[] unseqFileChunk1 = new TimeRange[]{new TimeRange(13000L, 15000L), new TimeRange(96000L, 99000L), new TimeRange(100000L, 101000L)};
        TimeRange[] unseqFileChunk2 = new TimeRange[]{new TimeRange(120000L, 123000L), new TimeRange(136000L, 139000L), new TimeRange(200000L, 201000L)};
        TsFileResource unseqResource = this.generateSingleNonAlignedSeriesFile("d0", "s0", new TimeRange[][]{unseqFileChunk1, unseqFileChunk2}, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, true);
        this.unseqResources.add(unseqResource);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getTsFilePath());
    }

    @Test
    public void test4() throws MetadataException, IOException, WriteProcessException {
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(100000L, 200000L), new TimeRange(300000L, 500000L)}, TSEncoding.PLAIN, CompressionType.LZ4, true);
        this.seqResources.add(seqResource1);
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(600000L, 700000L), new TimeRange(800000L, 900000L)}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TsFileResource unseqResource = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[]{new TimeRange(210000L, 290000L), new TimeRange(710000L, 890000L)}, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, true);
        this.unseqResources.add(unseqResource);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getTsFilePath());
    }

    @Test
    public void test5() throws MetadataException, IOException, WriteProcessException {
        TimeRange[] file1Chunk1 = new TimeRange[]{new TimeRange(10000L, 15000L), new TimeRange(16000L, 19000L), new TimeRange(20000L, 29000L)};
        TimeRange[] file1Chunk2 = new TimeRange[]{new TimeRange(30000L, 35000L), new TimeRange(36000L, 39000L), new TimeRange(40000L, 49000L)};
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{file1Chunk1, file1Chunk2}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource1);
        TimeRange[] file2Chunk1 = new TimeRange[]{new TimeRange(50000L, 55000L), new TimeRange(56000L, 59000L), new TimeRange(60000L, 69000L)};
        TimeRange[] file2Chunk2 = new TimeRange[]{new TimeRange(70000L, 75000L), new TimeRange(76000L, 79000L), new TimeRange(180000L, 189000L)};
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{file2Chunk1, file2Chunk2}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TimeRange[] unseqFileChunk1 = new TimeRange[]{new TimeRange(1000L, 5000L), new TimeRange(96000L, 99000L), new TimeRange(100000L, 110000L)};
        TimeRange[] unseqFileChunk2 = new TimeRange[]{new TimeRange(120000L, 130000L), new TimeRange(136000L, 149000L), new TimeRange(200000L, 210000L)};
        TsFileResource unseqResource = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{unseqFileChunk1, unseqFileChunk2}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.unseqResources.add(unseqResource);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getTsFilePath());
    }

    @Test
    public void test6() throws MetadataException, IOException, WriteProcessException {
        TimeRange[] file1Chunk1Page1 = new TimeRange[]{new TimeRange(10000L, 12000L), new TimeRange(16000L, 19000L)};
        TimeRange[] file1Chunk1Page2 = new TimeRange[]{new TimeRange(30000L, 35000L), new TimeRange(36000L, 39000L)};
        TsFileResource seqResource1 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][][]{{file1Chunk1Page1, file1Chunk1Page2}}, TSEncoding.PLAIN, CompressionType.LZ4, true);
        this.seqResources.add(seqResource1);
        TimeRange[] file2Chunk1Page1 = new TimeRange[]{new TimeRange(50000L, 55000L), new TimeRange(56000L, 59000L), new TimeRange(68000L, 69000L)};
        TimeRange[] file2Chunk1Page2 = new TimeRange[]{new TimeRange(70000L, 75000L), new TimeRange(76000L, 79000L), new TimeRange(180000L, 181000L)};
        TsFileResource seqResource2 = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][][]{{file2Chunk1Page1, file2Chunk1Page2}}, TSEncoding.PLAIN, CompressionType.SNAPPY, true);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        TimeRange[] unseqFileChunk1 = new TimeRange[]{new TimeRange(13000L, 15000L), new TimeRange(96000L, 99000L), new TimeRange(100000L, 101000L)};
        TimeRange[] unseqFileChunk2 = new TimeRange[]{new TimeRange(120000L, 123000L), new TimeRange(136000L, 139000L), new TimeRange(200000L, 201000L)};
        TsFileResource unseqResource = this.generateSingleAlignedSeriesFile("d0", Arrays.asList("s0", "s1", "s2"), new TimeRange[][]{unseqFileChunk1, unseqFileChunk2}, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, true);
        this.unseqResources.add(unseqResource);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResource targetFile = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getTsFilePath());
        this.validateSingleTsFileWithAlignedSeries(reader);
    }

    private TsFileResource generateSingleNonAlignedSeriesFile(String device, String measurement, TimeRange[] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleNonAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleNonAlignedSeriesFile(String device, String measurement, TimeRange[][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleNonAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleNonAlignedSeriesFile(String device, String measurement, TimeRange[][][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleNonAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private TsFileResource generateSingleAlignedSeriesFile(String device, List<String> measurement, TimeRange[][][] chunkTimeRanges, TSEncoding encoding, CompressionType compressionType, boolean isSeq) throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(isSeq);
        CompactionTestFileWriter writer1 = new CompactionTestFileWriter(seqResource1);
        writer1.startChunkGroup(device);
        writer1.generateSimpleAlignedSeriesToCurrentDevice(measurement, chunkTimeRanges, encoding, compressionType);
        writer1.endChunkGroup();
        writer1.endFile();
        writer1.close();
        return seqResource1;
    }

    private void validateSingleTsFileWithNonAlignedSeries(TsFileSequenceReader reader) throws IOException {
        HashMap<String, CompressionType> compressionTypeMap = new HashMap<String, CompressionType>();
        for (IDeviceID device : reader.getAllDevices()) {
            Map seriesMetaData = reader.readChunkMetadataInDevice(device);
            for (Map.Entry entry : seriesMetaData.entrySet()) {
                String series = (String)entry.getKey();
                List chunkMetadataList = (List)entry.getValue();
                for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                    Chunk chunk = reader.readMemChunk(chunkMetadata);
                    ChunkHeader chunkHeader = chunk.getHeader();
                    if (!compressionTypeMap.containsKey(series)) {
                        compressionTypeMap.put(series, chunkHeader.getCompressionType());
                    } else if (!((CompressionType)compressionTypeMap.get(series)).equals((Object)chunkHeader.getCompressionType())) {
                        Assert.fail();
                    }
                    this.validatePages(chunk);
                }
            }
        }
    }

    private void validateSingleTsFileWithAlignedSeries(TsFileSequenceReader reader) throws IOException {
        HashMap<String, CompressionType> compressionTypeMap = new HashMap<String, CompressionType>();
        for (IDeviceID device : reader.getAllDevices()) {
            List alignedChunkMetadataList = reader.getAlignedChunkMetadata(device);
            for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
                List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
                Chunk timeChunk = reader.readMemChunk((ChunkMetadata)timeChunkMetadata);
                if (!compressionTypeMap.containsKey("time")) {
                    compressionTypeMap.put("time", timeChunk.getHeader().getCompressionType());
                } else if (!((CompressionType)compressionTypeMap.get("time")).equals((Object)timeChunk.getHeader().getCompressionType())) {
                    Assert.fail();
                }
                ArrayList<Chunk> valueChunks = new ArrayList<Chunk>();
                for (IChunkMetadata chunkMetadata : valueChunkMetadataList) {
                    Chunk valueChunk = reader.readMemChunk((ChunkMetadata)chunkMetadata);
                    if (!compressionTypeMap.containsKey(valueChunk.getHeader().getMeasurementID())) {
                        compressionTypeMap.put(valueChunk.getHeader().getMeasurementID(), valueChunk.getHeader().getCompressionType());
                    } else if (!((CompressionType)compressionTypeMap.get(valueChunk.getHeader().getMeasurementID())).equals((Object)valueChunk.getHeader().getCompressionType())) {
                        Assert.fail();
                    }
                    valueChunks.add(valueChunk);
                }
                this.validatePages(timeChunk, valueChunks);
            }
        }
    }

    private void validatePages(Chunk chunk) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        CompactionChunkReader chunkReader = new CompactionChunkReader(chunk);
        ByteBuffer chunkDataBuffer = chunk.getData();
        while (chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)chunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
            chunkReader.readPageData(pageHeader, chunkReader.readPageDataWithoutUncompressing(pageHeader));
        }
    }

    private void validatePages(Chunk timeChunk, List<Chunk> valueChunks) throws IOException {
        AlignedChunkReader chunkReader = new AlignedChunkReader(timeChunk, valueChunks);
        while (chunkReader.hasNextSatisfiedPage()) {
            BatchData batchData = chunkReader.nextPageData();
        }
    }
}

