/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastCompactionPerformerWithEmptyPageTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void test1() throws IOException, IllegalPathException {
        PlainDeviceID device = new PlainDeviceID("root.testsg.d1");
        TsFileResource seqFile1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqFile1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3"), new TimeRange[][]{{new TimeRange(10L, 30L)}}, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Arrays.asList(false, true, true));
            writer.generateSimpleAlignedSeriesToCurrentDeviceWithNullValue(Arrays.asList("s1", "s2", "s3"), new TimeRange[][]{{new TimeRange(40L, 50L)}}, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Arrays.asList(false, false, false));
            writer.endChunkGroup();
            writer.endFile();
        }
        seqFile1.updateStartTime((IDeviceID)device, 10L);
        seqFile1.updateEndTime((IDeviceID)device, 50L);
        seqFile1.serialize();
        this.generateModsFile(Arrays.asList(new PartialPath("root.testsg.d1.s1")), seqFile1, 0L, 31L);
        TsFileResource unseqFile1 = this.createEmptyFileAndResource(false);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqFile1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2", "s3"), new TimeRange[][]{{new TimeRange(20L, 34L)}}, TSEncoding.RLE, CompressionType.UNCOMPRESSED);
            writer.endChunkGroup();
            writer.endFile();
        }
        unseqFile1.updateStartTime((IDeviceID)device, 20L);
        unseqFile1.updateEndTime((IDeviceID)device, 34L);
        unseqFile1.serialize();
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, Arrays.asList(seqFile1), Arrays.asList(unseqFile1), (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        try {
            Assert.assertTrue((boolean)task.start());
        }
        catch (Exception e) {
            Assert.fail();
        }
        TsFileResource result = (TsFileResource)this.tsFileManager.getTsFileList(true).get(0);
        result.buildDeviceTimeIndex();
        Assert.assertEquals((long)20L, (long)result.getStartTime((IDeviceID)device));
        Assert.assertEquals((long)50L, (long)result.getEndTime((IDeviceID)device));
        this.validateSeqFiles(true);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(result.getTsFilePath());){
            Map chunkMetadataInDevice = reader.readChunkMetadataInDevice((IDeviceID)device);
            long startTime = Long.MAX_VALUE;
            long endTime = Long.MIN_VALUE;
            List chunkMetadataList = (List)chunkMetadataInDevice.get("s1");
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                startTime = Math.min(startTime, chunkMetadata.getStartTime());
                endTime = Math.max(endTime, chunkMetadata.getEndTime());
            }
            Assert.assertEquals((long)20L, (long)startTime);
            Assert.assertEquals((long)50L, (long)endTime);
        }
    }
}

