/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FastAlignedCrossCompactionTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkSize(512L);
        IoTDBDescriptor.getInstance().getConfig().setTargetChunkPointNum(100L);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(30);
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }

    @Test
    public void test1() throws MetadataException, IOException {
        ArrayList<Object> pages;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 599L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(200L, 2200L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 200L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2199L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(900L, 1400L));
                pages.add(new TimeRange(1550L, 1700L));
                pages.add(new TimeRange(1750L, 2000L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1999L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1600L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1599L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test2() throws MetadataException, IOException {
        List<IChunkWriter> iChunkWriters;
        ArrayList<Object> timeRanges;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1000L);
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(100L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 10;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(900L, 1189L));
                timeRanges.add(new TimeRange(1301L, 1400L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, true);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1800L, 1900L));
                timeRanges.add(new TimeRange(2150L, 2250L));
                timeRanges.add(new TimeRange(2300L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(0L, 1189L));
                timeRanges.add(new TimeRange(1301L, 2000L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2100L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(550L, 800L));
                timeRanges.add(new TimeRange(1200L, 1300L));
                timeRanges.add(new TimeRange(1500L, 2200L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1150L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test3() throws MetadataException, IOException {
        List<IChunkWriter> iChunkWriters;
        ArrayList<Object> timeRanges;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(100L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 10;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(900L, 1249L));
                timeRanges.add(new TimeRange(1351L, 1400L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, true);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1800L, 1900L));
                timeRanges.add(new TimeRange(2150L, 2250L));
                timeRanges.add(new TimeRange(2300L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(0L, 1249L));
                timeRanges.add(new TimeRange(1351L, 2000L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2100L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(550L, 800L));
                timeRanges.add(new TimeRange(1250L, 1350L));
                timeRanges.add(new TimeRange(1500L, 2200L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1150L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test4() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2700L, 2800L));
                timeRanges.add(new TimeRange(2900L, 3000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test5() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2630L, 2680L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(4000L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2630L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(2900L, 3000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3800L, 3900L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3900L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(3100L, 3200L));
                timeRanges.add(new TimeRange(3300L, 3400L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3550L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test6() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2620L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2620L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(4000L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(2900L, 3000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3800L, 3900L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3900L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2630L, 2690L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(3100L, 3200L));
                timeRanges.add(new TimeRange(3300L, 3400L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3550L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test7() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2620L));
                for (int i = 0; i < iChunkWriters.size(); ++i) {
                    if (deviceIndex < 2 && i == 3) {
                        pages.add(new TimeRange(2621L, 2650L));
                    }
                    IChunkWriter iChunkWriter = iChunkWriters.get(i);
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                if (deviceIndex < 2) {
                    resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2650L);
                } else {
                    resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2620L);
                }
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(4000L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(2900L, 3000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3800L, 3900L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3900L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2630L, 2690L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(3100L, 3200L));
                timeRanges.add(new TimeRange(3300L, 3400L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3550L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test8() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2630L, 2680L));
                pages.add(new TimeRange(2850L, 2950L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2630L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(3000L, 3100L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                timeRanges.add(new TimeRange(3750L, 3850L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3850L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test9() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2620L, 2670L));
                timeRanges.add(new TimeRange(3000L, 3050L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                timeRanges.add(new TimeRange(3750L, 3850L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3850L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test10() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (int i = 0; i < iChunkWriters.size(); ++i) {
                    if (deviceIndex < 2 && i == 3) {
                        pages.add(new TimeRange(2501L, 2650L));
                    }
                    IChunkWriter iChunkWriter = iChunkWriters.get(i);
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                if (deviceIndex < 2) {
                    resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2650L);
                } else {
                    resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                }
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2620L, 2670L));
                timeRanges.add(new TimeRange(3000L, 3050L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                timeRanges.add(new TimeRange(3750L, 3850L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3850L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        this.validateSeqFiles(true);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test11() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1840L, 1900L);
                this.generateModsFile(timeseriesPath, resource, 2150L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2801L, 2850L);
                this.generateModsFile(timeseriesPath, resource, 3950L, 4100L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1149L));
                timeRanges.add(new TimeRange(1351L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 300L, 500L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1650L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 1790L);
                this.generateModsFile(timeseriesPath, resource, 1830L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2200L, 2260L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2700L, 2800L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1850L, 2000L));
                timeRanges.add(new TimeRange(2100L, 2230L));
                timeRanges.add(new TimeRange(2240L, 2300L));
                timeRanges.add(new TimeRange(2399L, 2550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1160L, 1250L);
                this.generateModsFile(timeseriesPath, resource, 1850L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2100L, 2230L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1420L, 1800L));
                pages.add(new TimeRange(1880L, 2250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1200L, 1300L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1780L);
                this.generateModsFile(timeseriesPath, resource, 1880L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test12() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 500L, 600L);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1840L, 1900L);
                this.generateModsFile(timeseriesPath, resource, 2150L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2801L, 2850L);
                this.generateModsFile(timeseriesPath, resource, 3950L, 4100L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1149L));
                timeRanges.add(new TimeRange(1351L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 300L, 500L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1650L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 1790L);
                this.generateModsFile(timeseriesPath, resource, 1830L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2200L, 2260L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 2000L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2700L, 2800L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1850L, 2000L));
                timeRanges.add(new TimeRange(2100L, 2230L));
                timeRanges.add(new TimeRange(2240L, 2300L));
                timeRanges.add(new TimeRange(2399L, 2550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1160L, 1250L);
                this.generateModsFile(timeseriesPath, resource, 1850L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2100L, 2230L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1420L, 1800L));
                pages.add(new TimeRange(1880L, 2250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1200L, 1300L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1780L);
                this.generateModsFile(timeseriesPath, resource, 1880L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test13() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 500L, 600L);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1840L, 1900L);
                this.generateModsFile(timeseriesPath, resource, 2150L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2801L, 2850L);
                this.generateModsFile(timeseriesPath, resource, 3950L, 4100L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1149L));
                timeRanges.add(new TimeRange(1351L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 300L, 500L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1650L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 1790L);
                this.generateModsFile(timeseriesPath, resource, 1830L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2200L, 2260L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 2000L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2700L, 2800L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1850L, 2000L));
                timeRanges.add(new TimeRange(2100L, 2230L));
                timeRanges.add(new TimeRange(2240L, 2300L));
                timeRanges.add(new TimeRange(2399L, 2550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1160L, 1250L);
                this.generateModsFile(timeseriesPath, resource, 1850L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2100L, 2230L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1420L, 1800L));
                pages.add(new TimeRange(1880L, 2250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1200L, 1300L);
                this.generateModsFile(timeseriesPath, resource, 1420L, 1800L);
                this.generateModsFile(timeseriesPath, resource, 1880L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test14() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 500L, 600L);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1840L, 1900L);
                this.generateModsFile(timeseriesPath, resource, 2150L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2801L, 2850L);
                this.generateModsFile(timeseriesPath, resource, 3950L, 4100L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1149L));
                timeRanges.add(new TimeRange(1351L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 300L, 500L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1650L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 1790L);
                this.generateModsFile(timeseriesPath, resource, 1830L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2200L, 2260L);
                this.generateModsFile(timeseriesPath, resource, 1700L, 2000L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2700L, 2800L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1850L, 2000L));
                timeRanges.add(new TimeRange(2100L, 2230L));
                timeRanges.add(new TimeRange(2240L, 2300L));
                timeRanges.add(new TimeRange(2399L, 2550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1160L, 1250L);
                this.generateModsFile(timeseriesPath, resource, 1850L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2100L, 2230L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1420L, 1800L));
                pages.add(new TimeRange(1880L, 2250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1200L, 1300L);
                this.generateModsFile(timeseriesPath, resource, 1420L, 1800L);
                this.generateModsFile(timeseriesPath, resource, 1880L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2800L, 4010L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test15() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 500L, 600L);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1840L, 1900L);
                this.generateModsFile(timeseriesPath, resource, 2150L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2801L, 2850L);
                this.generateModsFile(timeseriesPath, resource, 3950L, 4100L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1149L));
                timeRanges.add(new TimeRange(1351L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 300L, 500L);
                this.generateModsFile(timeseriesPath, resource, 1450L, 1650L);
                this.generateModsFile(timeseriesPath, resource, 2200L, 2260L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 2700L, 2800L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1050L, 1250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1850L, 2000L));
                timeRanges.add(new TimeRange(2100L, 2230L));
                timeRanges.add(new TimeRange(2240L, 2300L));
                timeRanges.add(new TimeRange(2399L, 2550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1160L, 1250L);
                this.generateModsFile(timeseriesPath, resource, 1850L, 2000L);
                this.generateModsFile(timeseriesPath, resource, 2100L, 2230L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1420L, 1800L));
                pages.add(new TimeRange(1880L, 2250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
                this.generateModsFile(timeseriesPath, resource, 1200L, 1300L);
                this.generateModsFile(timeseriesPath, resource, 1420L, 1800L);
                this.generateModsFile(timeseriesPath, resource, 1880L, 2250L);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test16() throws IOException, IllegalPathException {
        List<IChunkWriter> iChunkWriters;
        List<Object> pages;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 99L));
                pages.add(new TimeRange(100L, 199L));
                pages.add(new TimeRange(200L, 300L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(900L, 1400L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1550L, 1700L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1750L, 2000L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(200L, 2200L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 200L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(550L, 800L, 70);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1200L, 1300L, 200);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1500L, 1600L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test17() throws IOException, IllegalPathException {
        List<IChunkWriter> iChunkWriters;
        List<TimeRange> pages;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(100L, 300L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(500L, 600L, 30);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 10;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(900L, 1199L, 100);
                pages.addAll(this.createPages(1301L, 1400L, 100));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1800L, 1900L, 200);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2150L, 2250L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2300L, 2500L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(0L, 1199L, 50);
                pages.addAll(this.createPages(1301L, 2000L, 100));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2100L, 2200L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(550L, 800L, 70);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1200L, 1300L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1500L, 2200L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 5;
        measurementNum = 7;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(350L, 400L, 70);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(550L, 700L, 100);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1050L, 1150L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1150L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test18() throws IOException, IllegalPathException {
        List<IChunkWriter> iChunkWriters;
        List<TimeRange> pages;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(0L, 300L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(500L, 600L, 30);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 12;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(900L, 1199L, 100);
                pages.addAll(this.createPages(1301L, 1400L, 100));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(1800L, 1900L, 30);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2150L, 2250L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2400L, 2500L, 100);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 13;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(100L, 1199L, 50);
                pages.addAll(this.createPages(1301L, 1650L, 100));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1700L, 2000L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 10;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(2200L, 2400L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2500L, 2600L, 90);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2200L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(550L, 800L, 70);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1200L, 1300L, 100);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1500L, 1750L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1850L, 2200L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(350L, 400L, 25);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(550L, 700L, 100);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1050L, 1250L, 50);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 10;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(2700L, 2800L, 25);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(2900L, 3000L, 100);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 3000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test19() throws MetadataException, IOException {
        ArrayList<Object> timeRanges;
        ArrayList<Object> pages;
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                ArrayList<TimeRange> timeRanges2 = new ArrayList<TimeRange>();
                timeRanges2.add(new TimeRange(900L, 1199L));
                timeRanges2.add(new TimeRange(1301L, 1400L));
                for (IChunkWriter iChunkWriter3 : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter3, timeRanges2, true);
                    iChunkWriter3.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 5;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(1800L, 1900L));
                pages.add(new TimeRange(2150L, 2250L));
                pages.add(new TimeRange(2400L, 2500L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 1800L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2801L, 2850L));
                pages.add(new TimeRange(2851L, 2900L));
                pages.add(new TimeRange(3300L, 3400L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages.clear();
                pages.add(new TimeRange(3950L, 4100L));
                pages.add(new TimeRange(4200L, 4300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2801L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 20;
        measurementNum = 10;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(100L, 1199L));
                timeRanges.add(new TimeRange(1301L, 1650L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, Collections.singletonList(new TimeRange(1700L, 2000L)), false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2200L, 2400L));
                timeRanges.add(new TimeRange(2500L, 2600L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(2700L, 2800L));
                pages.add(new TimeRange(3150L, 3250L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages.clear();
                pages.add(new TimeRange(3600L, 3700L));
                pages.add(new TimeRange(3900L, 4000L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 4000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                pages = new ArrayList();
                pages.add(new TimeRange(550L, 800L));
                pages.add(new TimeRange(1200L, 1300L));
                pages.add(new TimeRange(1500L, 1750L));
                pages.add(new TimeRange(1850L, 2200L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 550L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2200L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(350L, 400L));
                timeRanges.add(new TimeRange(550L, 700L));
                timeRanges.add(new TimeRange(1250L, 1550L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2620L, 2670L));
                timeRanges.add(new TimeRange(3000L, 3050L));
                timeRanges.add(new TimeRange(3450L, 3550L));
                timeRanges.add(new TimeRange(3750L, 3850L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 350L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 3850L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test20() throws IOException, IllegalPathException {
        List<IChunkWriter> iChunkWriters;
        List<TimeRange> pages;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(300L, 600L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages = this.createPages(700L, 1000L, 30);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages = this.createPages(1100L, 1400L, 80);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 300L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(1600L, 1900L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages = this.createPages(1950L, 2250L, 40);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1600L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2250L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 18;
        measurementNum = 18;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(0L, 2000L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 2000L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 13;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(100L, 400L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(500L, 800L, 90);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 100L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 800L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(450L, 950L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1100L, 1920L, 90);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 450L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1920L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test21() throws IOException, IllegalPathException {
        List<IChunkWriter> iChunkWriters;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 200L));
                pages.add(new TimeRange(350L, 450L));
                pages.add(new TimeRange(600L, 800L));
                pages.add(new TimeRange(900L, 1100L));
                pages.add(new TimeRange(1400L, 1600L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    timeRanges.clear();
                    timeRanges.add(new TimeRange(0L, 0L));
                    timeRanges.add(new TimeRange(200L, 200L));
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    timeRanges.clear();
                    timeRanges.add(new TimeRange(300L, 300L));
                    timeRanges.add(new TimeRange(500L, 500L));
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    timeRanges.clear();
                    timeRanges.add(new TimeRange(650L, 650L));
                    timeRanges.add(new TimeRange(750L, 750L));
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    timeRanges.clear();
                    timeRanges.add(new TimeRange(1000L, 1000L));
                    timeRanges.add(new TimeRange(1200L, 1200L));
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    timeRanges.clear();
                    timeRanges.add(new TimeRange(1300L, 1300L));
                    timeRanges.add(new TimeRange(1500L, 1500L));
                    TsFileGeneratorUtils.writeOneAlignedPage((AlignedChunkWriterImpl)iChunkWriter, timeRanges, false);
                    iChunkWriter.writeToFileWriter(tsFileIOWriter);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1500L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test22() throws IOException, IllegalPathException {
        List<IChunkWriter> iChunkWriters;
        List<TimeRange> pages;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(0L, 1000L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages = this.createPages(1100L, 1200L, 30);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                pages = this.createPages(1300L, 1400L, 80);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1400L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 15;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(50L, 250L, 100);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(300L, 500L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(550L, 650L, 60);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(950L, 1450L, 45);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 50L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1450L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 12;
        measurementNum = 12;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                pages = this.createPages(700L, 800L, 50);
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(850L, 1350L, 90);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                pages = this.createPages(1500L, 1600L, 30);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 700L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID("root.testsg.d" + deviceIndex), 1600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    @Test
    public void test23() throws MetadataException, IOException {
        List<IChunkWriter> iChunkWriters;
        ArrayList<Object> timeRanges;
        List<PartialPath> timeseriesPath;
        ArrayList<Integer> measurementIndexes;
        List<CompressionType> compressionTypes;
        List<TSEncoding> encodings;
        List<TSDataType> dataTypes;
        int deviceIndex;
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1000L);
        ArrayList<PartialPath> timeserisPathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        int deviceNum = 10;
        int measurementNum = 10;
        TsFileResource resource = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());){
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList<Integer>();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
                pages.add(new TimeRange(0L, 300L));
                pages.add(new TimeRange(500L, 600L));
                for (IChunkWriter iChunkWriter : TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true)) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, pages, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 0L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 600L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 5;
        resource = this.createEmptyFileAndResource(true);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList<TimeRange>();
                timeRanges.add(new TimeRange(900L, 1200L));
                timeRanges.add(new TimeRange(1350L, 1700L));
                timeRanges.add(new TimeRange(1750L, 2000L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, true);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2220L, 2300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, true);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 900L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.seqResources.add(resource);
        deviceNum = 12;
        measurementNum = 15;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(500L, 950L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1000L, 1320L));
                timeRanges.add(new TimeRange(1400L, 1850L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(2000L, 2200L));
                timeRanges.add(new TimeRange(2220L, 2300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 500L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        deviceNum = 20;
        measurementNum = 20;
        resource = this.createEmptyFileAndResource(false);
        tsFileIOWriter = new TsFileIOWriter(resource.getTsFile());
        try {
            for (deviceIndex = 0; deviceIndex < deviceNum; ++deviceIndex) {
                tsFileIOWriter.startChunkGroup((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex));
                dataTypes = TsFileGeneratorUtils.createDataType(measurementNum);
                encodings = TsFileGeneratorUtils.createEncodingType(measurementNum);
                compressionTypes = TsFileGeneratorUtils.createCompressionType(measurementNum);
                measurementIndexes = new ArrayList();
                for (int i = 0; i < measurementNum; ++i) {
                    measurementIndexes.add(i);
                }
                timeseriesPath = TsFileGeneratorUtils.createTimeseries(deviceIndex, measurementIndexes, dataTypes, true);
                timeRanges = new ArrayList();
                timeRanges.add(new TimeRange(500L, 800L));
                timeRanges.add(new TimeRange(850L, 950L));
                iChunkWriters = TsFileGeneratorUtils.createChunkWriter(timeseriesPath, dataTypes, encodings, compressionTypes, true);
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                timeRanges.clear();
                timeRanges.add(new TimeRange(1000L, 1300L));
                timeRanges.add(new TimeRange(1400L, 1850L));
                timeRanges.add(new TimeRange(2220L, 2300L));
                for (IChunkWriter iChunkWriter : iChunkWriters) {
                    TsFileGeneratorUtils.writeAlignedChunk((AlignedChunkWriterImpl)iChunkWriter, tsFileIOWriter, timeRanges, false);
                }
                tsFileIOWriter.endChunkGroup();
                resource.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 500L);
                resource.updateEndTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + "." + "d" + deviceIndex), 2300L);
                timeserisPathList.addAll(timeseriesPath);
                tsDataTypes.addAll(dataTypes);
            }
            tsFileIOWriter.endFile();
        }
        finally {
            tsFileIOWriter.close();
        }
        resource.serialize();
        this.unseqResources.add(resource);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        Map<PartialPath, List<TimeValuePair>> sourceDatas = this.readSourceFiles(TsFileGeneratorUtils.createTimeseries(this.maxDeviceNum, this.maxMeasurementNum, true), tsDataTypes);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertTrue((boolean)task.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.tsFileManager.getTsFileList(true), true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)innerTask.start());
        this.validateSeqFiles(true);
        this.validateTargetDatas(sourceDatas, tsDataTypes);
    }

    private List<TimeRange> createPages(long startTime, long endTime, int pagePointNum) {
        ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
        for (long i = startTime; i <= endTime; i += (long)pagePointNum) {
            long pageEndTime = Math.min(i + (long)pagePointNum - 1L, endTime);
            pages.add(new TimeRange(i, pageEndTime));
        }
        return pages;
    }
}

