/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.TsFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossSpaceCompactionWithUnusualCasesTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setEnableTsFileValidation(true);
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(0);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(10);
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(3);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles1() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles2() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 210L, 270L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource2));
        Assert.assertTrue((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource3));
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles3() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 210L, 270L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource seqTsFileResource4 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource4.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource4, "d3", true, 280L, 290L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource4.serialize();
        this.seqResources.add(seqTsFileResource4);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource2));
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource4));
        Assert.assertTrue((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource3));
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles4() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 210L, 270L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource seqTsFileResource4 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource4.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource4, "d3", true, 280L, 290L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource4.serialize();
        this.seqResources.add(seqTsFileResource4);
        TsFileResource seqTsFileResource5 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource5.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource5, "d2", true, 800L, 900L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource5.serialize();
        this.seqResources.add(seqTsFileResource5);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource2));
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource4));
        Assert.assertTrue((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource5));
    }

    @Test
    public void testMultiUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 210L, 270L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource seqTsFileResource4 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource4.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource4, "d3", true, 280L, 290L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource4.serialize();
        this.seqResources.add(seqTsFileResource4);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        TsFileResource unSeqTsFileResource2 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource2, "d1", false, 400L, 500L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource2, "d2", false, 500L, 600L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource2, "d3", false, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource2.serialize();
        this.unseqResources.add(unSeqTsFileResource2);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)5L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource2));
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles5() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d3", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFiles6() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 210L, 270L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource seqTsFileResource4 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource4.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource4, "d3", true, 280L, 290L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource4.serialize();
        this.seqResources.add(seqTsFileResource4);
        TsFileResource seqTsFileResource5 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource5.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource5, "d2", true, 500L, 600L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource5.serialize();
        this.seqResources.add(seqTsFileResource5);
        TsFileResource seqTsFileResource6 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource6.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource6, "d2", true, 700L, 800L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource6.serialize();
        this.seqResources.add(seqTsFileResource6);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((CrossCompactionTaskResource)result.get(0)).getTotalFileNums());
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource2));
        Assert.assertFalse((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource4));
        Assert.assertTrue((boolean)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().contains(seqTsFileResource5));
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFilesWithUnclosedSeqFile1() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        seqTsFileResource2.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + ".d2"), 100L);
        seqTsFileResource2.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFilesWithUnclosedSeqFile2() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        seqTsFileResource3.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + ".d2"), 610L);
        seqTsFileResource3.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().size());
        Assert.assertEquals((Object)seqTsFileResource2, ((CrossCompactionTaskResource)result.get(0)).getSeqFiles().get(1));
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFilesWithUnclosedSeqFileAndInvalidCandidate() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        seqTsFileResource2.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE);
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        seqTsFileResource3.updateStartTime((IDeviceID)new PlainDeviceID(COMPACTION_TEST_SG + ".d2"), 500L);
        seqTsFileResource3.setStatusForTest(TsFileResourceStatus.UNCLOSED);
        seqTsFileResource3.serialize();
        this.seqResources.add(seqTsFileResource3);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 300L, 400L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFilesWithInvalidCandidate1() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 500L, 600L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        seqTsFileResource3.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE);
        this.seqResources.add(seqTsFileResource3);
        TsFileResource seqTsFileResource4 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource4.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource4, "d2", true, 900L, 1000L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource4.serialize();
        this.seqResources.add(seqTsFileResource4);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 700L, 800L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)2L, (long)((CrossCompactionTaskResource)result.get(0)).getSeqFiles().size());
        Assert.assertEquals((Object)seqTsFileResource1, ((CrossCompactionTaskResource)result.get(0)).getSeqFiles().get(0));
        Assert.assertEquals((Object)seqTsFileResource4, ((CrossCompactionTaskResource)result.get(0)).getSeqFiles().get(1));
    }

    @Test
    public void testUnSeqFileOverlapWithSeqFilesButOneDeviceNotExistInOverlapSeqFilesWithInvalidCandidate2() throws IOException, IllegalPathException {
        TsFileResource seqTsFileResource1 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource1, "d1", true, 150L, 400L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource1.serialize();
        this.seqResources.add(seqTsFileResource1);
        TsFileResource seqTsFileResource2 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource2.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource2, "d2", true, 100L, 200L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource2.serialize();
        this.seqResources.add(seqTsFileResource2);
        TsFileResource seqTsFileResource3 = this.createEmptyFileAndResource(true);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(seqTsFileResource3.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, seqTsFileResource3, "d2", true, 500L, 600L);
            tsFileIOWriter.endFile();
        }
        seqTsFileResource3.serialize();
        seqTsFileResource3.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE);
        this.seqResources.add(seqTsFileResource3);
        TsFileResource unSeqTsFileResource1 = this.createEmptyFileAndResource(false, 1);
        try (TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(unSeqTsFileResource1.getTsFile());){
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d1", false, 100L, 300L);
            this.createSimpleDevice(tsFileIOWriter, unSeqTsFileResource1, "d2", false, 700L, 800L);
            tsFileIOWriter.endFile();
        }
        unSeqTsFileResource1.serialize();
        this.unseqResources.add(unSeqTsFileResource1);
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(COMPACTION_TEST_SG, "0", 0L, this.tsFileManager);
        List result = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    public void createSimpleDevice(TsFileIOWriter fileWriter, TsFileResource resource, String deviceName, boolean isSeq, long startTime, long endTime) throws IOException, IllegalPathException {
        PlainDeviceID deviceId = new PlainDeviceID(COMPACTION_TEST_SG + "." + deviceName);
        fileWriter.startChunkGroup((IDeviceID)deviceId);
        List<TSDataType> dataTypes = TsFileGeneratorUtils.createDataType(1);
        List<TSEncoding> encodingTypes = TsFileGeneratorUtils.createEncodingType(1);
        List<CompressionType> compressionTypes = TsFileGeneratorUtils.createCompressionType(1);
        ArrayList<PartialPath> timeSeriesPaths = new ArrayList<PartialPath>();
        timeSeriesPaths.add((PartialPath)new MeasurementPath(deviceId.toStringID() + ".s1", dataTypes.get(0)));
        List<IChunkWriter> chunkWriters = TsFileGeneratorUtils.createChunkWriter(timeSeriesPaths, dataTypes, encodingTypes, compressionTypes, false);
        IChunkWriter chunkWriter = chunkWriters.get(0);
        ArrayList<TimeRange> pages = new ArrayList<TimeRange>();
        pages.add(new TimeRange(startTime, endTime));
        TsFileGeneratorUtils.writeOneNonAlignedPage((ChunkWriterImpl)chunkWriter, pages, isSeq);
        fileWriter.endChunkGroup();
        resource.updateStartTime((IDeviceID)deviceId, startTime);
        resource.updateEndTime((IDeviceID)deviceId, endTime);
    }
}

