/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskQueue;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CompactionWorkerTest {
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        SystemInfo.getInstance().getCompactionFileNumCost().set(0);
        SystemInfo.getInstance().getCompactionMemoryCost().set(0L);
    }

    @After
    public void teardown() {
        SystemInfo.getInstance().getCompactionFileNumCost().set(0);
        SystemInfo.getInstance().getCompactionMemoryCost().set(0L);
    }

    @Test
    public void testFailedToAllocateMemoryInCrossTask() throws Exception {
        ArrayList<TsFileResource> sequenceFiles = new ArrayList<TsFileResource>();
        for (int i = 1; i <= 10; ++i) {
            sequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
        }
        ArrayList<TsFileResource> unsequenceFiles = new ArrayList<TsFileResource>();
        for (int i = 11; i <= 20; ++i) {
            unsequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
        }
        TsFileManager tsFileManager = (TsFileManager)Mockito.mock(TsFileManager.class);
        Mockito.when((Object)tsFileManager.getStorageGroupName()).thenReturn((Object)"root.sg");
        Mockito.when((Object)tsFileManager.getDataRegionId()).thenReturn((Object)"1");
        Mockito.when((Object)tsFileManager.isAllowCompaction()).thenReturn((Object)true);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, tsFileManager, sequenceFiles, unsequenceFiles, null, 0xC80000000L, 0L);
        CrossSpaceCompactionTask taskMock = (CrossSpaceCompactionTask)Mockito.spy((Object)task);
        ((CrossSpaceCompactionTask)Mockito.doReturn((Object)true).when((Object)taskMock)).start();
        CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
        queue.put((Object)taskMock);
        Thread thread = new Thread(() -> CompactionWorkerTest.lambda$testFailedToAllocateMemoryInCrossTask$0((FixedPriorityBlockingQueue)queue));
        thread.start();
        thread.join(TimeUnit.SECONDS.toMillis(2L));
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
        for (TsFileResource tsFileResource : sequenceFiles) {
            Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)tsFileResource.getStatus());
            Assert.assertTrue((boolean)tsFileResource.tryWriteLock());
        }
        for (TsFileResource tsFileResource : unsequenceFiles) {
            Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)tsFileResource.getStatus());
            Assert.assertTrue((boolean)tsFileResource.tryWriteLock());
        }
        thread.interrupt();
        thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedToAllocateFileNumInCrossTask() throws InterruptedException {
        int oldMaxCrossCompactionCandidateFileNum = SystemInfo.getInstance().getTotalFileLimitForCompaction();
        SystemInfo.getInstance().setTotalFileLimitForCompactionTask(2);
        try {
            ArrayList<TsFileResource> sequenceFiles = new ArrayList<TsFileResource>();
            for (int i = 1; i <= 10; ++i) {
                sequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
            }
            ArrayList<TsFileResource> unsequenceFiles = new ArrayList<TsFileResource>();
            for (int i = 11; i <= 30; ++i) {
                unsequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
            }
            TsFileManager tsFileManager = new TsFileManager("root.testsg", "0", "");
            tsFileManager.addAll(sequenceFiles, true);
            tsFileManager.addAll(unsequenceFiles, false);
            CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, tsFileManager, sequenceFiles, unsequenceFiles, null, 1000L, 0L);
            CrossSpaceCompactionTask taskMock = (CrossSpaceCompactionTask)Mockito.spy((Object)task);
            ((CrossSpaceCompactionTask)Mockito.doReturn((Object)true).when((Object)taskMock)).start();
            CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
            queue.put((Object)taskMock);
            Thread thread = new Thread(() -> CompactionWorkerTest.lambda$testFailedToAllocateFileNumInCrossTask$1((FixedPriorityBlockingQueue)queue));
            thread.start();
            thread.join(TimeUnit.SECONDS.toMillis(2L));
            Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
            Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
            for (TsFileResource tsFileResource : sequenceFiles) {
                Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)tsFileResource.getStatus());
                Assert.assertTrue((boolean)tsFileResource.tryWriteLock());
            }
            for (TsFileResource tsFileResource : unsequenceFiles) {
                Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)tsFileResource.getStatus());
                Assert.assertTrue((boolean)tsFileResource.tryWriteLock());
            }
            thread.interrupt();
            thread.join();
        }
        finally {
            SystemInfo.getInstance().setTotalFileLimitForCompactionTask(oldMaxCrossCompactionCandidateFileNum);
        }
    }

    @Test
    public void testFailedToCheckValidInCrossTask() throws InterruptedException {
        ArrayList<TsFileResource> sequenceFiles = new ArrayList<TsFileResource>();
        for (int i = 1; i <= 10; ++i) {
            sequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
        }
        ArrayList<TsFileResource> unsequenceFiles = new ArrayList<TsFileResource>();
        for (int i = 11; i <= 20; ++i) {
            unsequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
        }
        TsFileManager tsFileManager = (TsFileManager)Mockito.mock(TsFileManager.class);
        Mockito.when((Object)tsFileManager.isAllowCompaction()).thenReturn((Object)false);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, tsFileManager, sequenceFiles, unsequenceFiles, null, 1000L, 0L);
        CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
        queue.put((Object)task);
        Thread thread = new Thread(() -> CompactionWorkerTest.lambda$testFailedToCheckValidInCrossTask$2((FixedPriorityBlockingQueue)queue));
        thread.start();
        thread.join(TimeUnit.SECONDS.toMillis(2L));
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
        for (TsFileResource tsFileResource : sequenceFiles) {
            Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)tsFileResource.getStatus());
            Assert.assertTrue((boolean)tsFileResource.tryWriteLock());
        }
        thread.interrupt();
        thread.join();
    }

    @Test
    public void testFailedToCheckValidInInnerTask() throws InterruptedException {
        ArrayList<TsFileResource> sequenceFiles = new ArrayList<TsFileResource>();
        for (int i = 1; i <= 10; ++i) {
            sequenceFiles.add(new TsFileResource(new File(String.format("%d-%d-0-0.tsfile", i, i)), TsFileResourceStatus.COMPACTION_CANDIDATE));
        }
        TsFileManager tsFileManager = (TsFileManager)Mockito.mock(TsFileManager.class);
        Mockito.when((Object)tsFileManager.isAllowCompaction()).thenReturn((Object)false);
        InnerSpaceCompactionTask innerTask = new InnerSpaceCompactionTask(0L, tsFileManager, sequenceFiles, true, null, 0L);
        CompactionTaskQueue queue = new CompactionTaskQueue(50, (Comparator)new DefaultCompactionTaskComparatorImpl());
        queue.put((Object)innerTask);
        Thread thread = new Thread(() -> CompactionWorkerTest.lambda$testFailedToCheckValidInInnerTask$3((FixedPriorityBlockingQueue)queue));
        thread.start();
        thread.join(TimeUnit.SECONDS.toMillis(2L));
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionMemoryCost().get());
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getCompactionFileNumCost().get());
        for (TsFileResource tsFileResource : sequenceFiles) {
            Assert.assertEquals((Object)TsFileResourceStatus.NORMAL, (Object)tsFileResource.getStatus());
            Assert.assertTrue((boolean)tsFileResource.tryWriteLock());
        }
        thread.interrupt();
        thread.join();
    }

    private static /* synthetic */ void lambda$testFailedToCheckValidInInnerTask$3(FixedPriorityBlockingQueue queue) {
        try {
            queue.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$testFailedToCheckValidInCrossTask$2(FixedPriorityBlockingQueue queue) {
        try {
            queue.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$testFailedToAllocateFileNumInCrossTask$1(FixedPriorityBlockingQueue queue) {
        try {
            queue.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$testFailedToAllocateMemoryInCrossTask$0(FixedPriorityBlockingQueue queue) {
        try {
            queue.take();
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

