/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionValidationTest {
    static final String SENSOR_1 = "sensor_1";
    static final String SENSOR_2 = "sensor_2";
    static final String SENSOR_3 = "sensor_3";
    static final String DEVICE_1 = "root.sg.device_1";
    final String dir = TestConstant.OUTPUT_DATA_DIR + "test-validation";

    @Before
    public void setUp() throws IOException {
        FileUtils.forceMkdir((File)new File(this.dir));
    }

    private void writeOneFile(String path) {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(path);
            if (f.exists() && !f.delete()) {
                throw new RuntimeException("can not delete " + f.getAbsolutePath());
            }
            try (TsFileWriter tsFileWriter = new TsFileWriter(f);){
                ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
                measurementSchemas.add(new MeasurementSchema(SENSOR_1, TSDataType.TEXT, TSEncoding.PLAIN));
                measurementSchemas.add(new MeasurementSchema(SENSOR_2, TSDataType.TEXT, TSEncoding.PLAIN));
                measurementSchemas.add(new MeasurementSchema(SENSOR_3, TSDataType.TEXT, TSEncoding.PLAIN));
                tsFileWriter.registerTimeseries(new Path(DEVICE_1), measurementSchemas);
                ArrayList<MeasurementSchema> writeMeasurementScheams = new ArrayList<MeasurementSchema>();
                writeMeasurementScheams.add((MeasurementSchema)measurementSchemas.get(0));
                writeMeasurementScheams.add((MeasurementSchema)measurementSchemas.get(1));
                writeMeasurementScheams.add((MeasurementSchema)measurementSchemas.get(2));
                this.writeWithTablet(tsFileWriter, DEVICE_1, writeMeasurementScheams, 10000L, 0L, 0L);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void writeWithTablet(TsFileWriter tsFileWriter, String deviceId, List<MeasurementSchema> schemas, long rowNum, long startTime, long startValue) throws IOException, WriteProcessException {
        Tablet tablet = new Tablet(deviceId, schemas);
        long[] timestamps = tablet.timestamps;
        Object[] values = tablet.values;
        long sensorNum = schemas.size();
        long r = 0L;
        while (r < rowNum) {
            ++tablet.rowSize;
            ++startTime;
            int i = 0;
            while ((long)i < sensorNum) {
                Binary[] textSensor = (Binary[])values[i];
                textSensor[row] = new Binary("testString.........", TSFileConfig.STRING_CHARSET);
                ++i;
            }
            if (tablet.rowSize == tablet.getMaxRowNumber()) {
                tsFileWriter.write(tablet);
                tablet.reset();
            }
            ++r;
            ++startValue;
        }
        if (tablet.rowSize != 0) {
            tsFileWriter.write(tablet);
            tablet.reset();
        }
    }

    @After
    public void tearDown() throws IOException {
        File[] files = new File(this.dir).listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.delete((File)f);
            }
        }
        FileUtils.forceDelete((File)new File(this.dir));
    }

    @Test
    public void testSingleCompleteFile() {
        String path = this.dir + File.separator + "test.tsfile";
        this.writeOneFile(path);
        TsFileResource mockTsFile = new TsFileResource(new File(path));
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)mockTsFile));
    }

    @Test
    public void testMultiCompleteFile() {
        for (int i = 0; i < 10; ++i) {
            String path = this.dir + File.separator + "test" + i + ".tsfile";
            this.writeOneFile(path);
            TsFileResource mockTsFile = new TsFileResource(new File(path));
            Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)mockTsFile));
        }
    }

    @Test
    public void testOneUncompletedFile() throws IOException {
        String path = this.dir + File.separator + "test.tsfile";
        this.writeOneFile(path);
        RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
        randomAccessFile.seek(1024L);
        randomAccessFile.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        randomAccessFile.close();
        TsFileResource mockTsFile = new TsFileResource(new File(path));
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)mockTsFile));
    }

    @Test
    public void testMultiUncompletedFiles() throws IOException {
        for (int i = 0; i < 10; ++i) {
            String path = this.dir + File.separator + "test" + i + ".tsfile";
            this.writeOneFile(path);
            RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
            randomAccessFile.seek(1024L);
            randomAccessFile.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
            randomAccessFile.close();
            TsFileResource mockTsFile = new TsFileResource(new File(path));
            Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)mockTsFile));
        }
    }

    @Test
    public void testOneUncompletedInMultiCompletedFiles1() throws IOException {
        for (int i = 0; i < 10; ++i) {
            String path = this.dir + File.separator + "test" + i + ".tsfile";
            this.writeOneFile(path);
            if (i == 5) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
                randomAccessFile.seek(1024L);
                randomAccessFile.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
                randomAccessFile.close();
            }
            TsFileResource mockTsFile = new TsFileResource(new File(path));
            TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)mockTsFile);
        }
    }

    @Test
    public void testOneUncompletedInMultiCompletedFiles2() throws IOException {
        for (int i = 0; i < 10; ++i) {
            String path = this.dir + File.separator + "test" + i + ".tsfile";
            this.writeOneFile(path);
            if (i == 5) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(path, "rw");
                randomAccessFile.seek(randomAccessFile.length() - 100L);
                randomAccessFile.write(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
                randomAccessFile.close();
            }
            TsFileResource mockTsFile = new TsFileResource(new File(path));
            TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)mockTsFile);
        }
    }

    @Test
    public void testTsFileResourceIsDeletedByOtherCompactionTaskWhenValidateOverlap1() {
        TsFileResource resource1 = new TsFileResource();
        resource1.setFile(new File(this.dir + File.separator + "1-1-0-0.tsfile"));
        resource1.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource1.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 2L);
        TsFileResource resource2 = new TsFileResource();
        resource2.setFile(new File(this.dir + File.separator + "2-2-0-0.tsfile"));
        resource2.setTimeIndex((ITimeIndex)new FileTimeIndex());
        TsFileResource resource3 = new TsFileResource();
        resource3.setFile(new File(this.dir + File.separator + "3-3-0-0.tsfile"));
        resource3.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource3.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 4L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 5L);
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap(Arrays.asList(resource1, resource2, resource3)));
    }

    @Test
    public void testTsFileResourceIsDeletedByOtherCompactionTaskWhenValidateOverlap2() {
        TsFileResource resource1 = new TsFileResource();
        resource1.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource1.setFile(new File(this.dir + File.separator + "1-1-0-0.tsfile"));
        resource1.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 2L);
        TsFileResource resource2 = new TsFileResource();
        resource2.setFile(new File(this.dir + File.separator + "2-2-0-0.tsfile"));
        resource2.setTimeIndex((ITimeIndex)new FileTimeIndex());
        TsFileResource resource3 = new TsFileResource();
        resource3.setFile(new File(this.dir + File.separator + "3-3-0-0.tsfile"));
        resource3.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource3.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 5L);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap(Arrays.asList(resource1, resource2, resource3)));
    }

    @Test
    public void testTsFileResourceIsBrokenWhenValidateOverlap1() throws IOException {
        TsFileResource resource1 = new TsFileResource();
        resource1.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource1.setFile(new File(this.dir + File.separator + "1-1-0-0.tsfile"));
        resource1.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 2L);
        TsFileResource resource2 = new TsFileResource();
        File tsFile2 = new File(this.dir + File.separator + "2-2-0-0.tsfile");
        Assert.assertTrue((boolean)tsFile2.createNewFile());
        File resourceFile2 = new File(this.dir + File.separator + "2-2-0-0.tsfile.resource");
        Assert.assertTrue((boolean)resourceFile2.createNewFile());
        resource2.setFile(tsFile2);
        resource2.setTimeIndex((ITimeIndex)new FileTimeIndex());
        TsFileResource resource3 = new TsFileResource();
        resource3.setFile(new File(this.dir + File.separator + "3-3-0-0.tsfile"));
        resource3.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource3.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 4L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 5L);
        Assert.assertTrue((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap(Arrays.asList(resource1, resource2, resource3)));
    }

    @Test
    public void testTsFileResourceIsBrokenWhenValidateOverlap2() throws IOException {
        TsFileResource resource1 = new TsFileResource();
        resource1.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource1.setFile(new File(this.dir + File.separator + "1-1-0-0.tsfile"));
        resource1.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 2L);
        TsFileResource resource2 = new TsFileResource();
        File tsFile2 = new File(this.dir + File.separator + "2-2-0-0.tsfile");
        Assert.assertTrue((boolean)tsFile2.createNewFile());
        File resourceFile2 = new File(this.dir + File.separator + "2-2-0-0.tsfile.resource");
        Assert.assertTrue((boolean)resourceFile2.createNewFile());
        resource2.setFile(tsFile2);
        resource2.setTimeIndex((ITimeIndex)new FileTimeIndex());
        TsFileResource resource3 = new TsFileResource();
        resource3.setFile(new File(this.dir + File.separator + "3-3-0-0.tsfile"));
        resource3.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        resource3.updateStartTime((IDeviceID)new PlainDeviceID("d1"), 1L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID("d1"), 5L);
        Assert.assertFalse((boolean)TsFileResourceUtils.validateTsFileResourcesHasNoOverlap(Arrays.asList(resource1, resource2, resource3)));
    }
}

