/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.inner.InnerCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskManagerTest
extends InnerCompactionTest {
    static final Logger LOGGER = LoggerFactory.getLogger(CompactionTaskManagerTest.class);
    File tempSGDir;
    final long MAX_WAITING_TIME = 120000L;
    private ICompactionPerformer performer;

    @Override
    @Before
    public void setUp() throws Exception {
        this.tempSGDir = new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L));
        if (this.tempSGDir.exists()) {
            FileUtils.deleteDirectory((File)this.tempSGDir);
        }
        CompactionTaskManager.getInstance().restart();
        Assert.assertTrue((boolean)this.tempSGDir.mkdirs());
        super.setUp();
        this.performer = new FastCompactionPerformer(false);
        this.performer.setSourceFiles(this.seqResources);
    }

    @Override
    @After
    public void tearDown() throws StorageEngineException, IOException {
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedSubmitBeforeExecution() throws Exception {
        LOGGER.warn("testRepeatedSubmitBeforeExecution");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task1 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        InnerSpaceCompactionTask task2 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        ((TsFileResource)this.seqResources.get(0)).readLock();
        CompactionTaskManager manager = CompactionTaskManager.getInstance();
        Future summaryFuture = null;
        try {
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
            Assert.assertTrue((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task1));
            summaryFuture = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task1);
            Assert.assertEquals((long)manager.getTotalTaskCount(), (long)1L);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertTrue((boolean)resource.isCompacting());
            }
            Assert.assertFalse((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task2));
            Assert.assertEquals((long)manager.getTotalTaskCount(), (long)1L);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertTrue((boolean)resource.isCompacting());
            }
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).readUnlock();
        }
        if (summaryFuture != null) {
            summaryFuture.get();
        }
        Assert.assertEquals((long)0L, (long)manager.getTotalTaskCount());
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        manager.waitAllCompactionFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedSubmitWhenExecuting() throws Exception {
        LOGGER.warn("testRepeatedSubmitWhenExecuting");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task1 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        InnerSpaceCompactionTask task2 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        ((TsFileResource)this.seqResources.get(0)).readLock();
        Future summaryFuture = null;
        try {
            CompactionTaskManager manager = CompactionTaskManager.getInstance();
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
            manager.addTaskToWaitingQueue((AbstractCompactionTask)task1);
            summaryFuture = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task1);
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
            Assert.assertEquals((long)manager.getExecutingTaskCount(), (long)1L);
            Assert.assertFalse((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task2));
            for (TsFileResource resource : this.seqResources) {
                Assert.assertFalse((boolean)resource.isCompactionCandidate());
            }
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).readUnlock();
        }
        if (summaryFuture != null) {
            summaryFuture.get();
        }
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepeatedSubmitAfterExecution() throws Exception {
        LOGGER.warn("testRepeatedSubmitAfterExecution");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task1 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        InnerSpaceCompactionTask task2 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        CompactionTaskManager manager = CompactionTaskManager.getInstance();
        ((TsFileResource)this.seqResources.get(0)).readLock();
        Assert.assertTrue((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task1));
        Future future = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task1);
        ((TsFileResource)this.seqResources.get(0)).readUnlock();
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        try {
            Assert.assertFalse((boolean)manager.addTaskToWaitingQueue((AbstractCompactionTask)task2));
            Assert.assertEquals((long)manager.getExecutingTaskCount(), (long)0L);
        }
        finally {
            CompactionTaskManager.getInstance().waitAllCompactionFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveSelfFromRunningList() throws Exception {
        List runningList;
        LOGGER.warn("testRemoveSelfFromRunningList");
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task1 = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        CompactionTaskManager manager = CompactionTaskManager.getInstance();
        manager.restart();
        ((TsFileResource)this.seqResources.get(0)).readLock();
        Future future = null;
        try {
            manager.addTaskToWaitingQueue((AbstractCompactionTask)task1);
            future = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task1);
            runningList = manager.getRunningCompactionTaskList();
            Assert.assertEquals((long)1L, (long)runningList.size());
            Assert.assertTrue((boolean)runningList.contains(task1));
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).readUnlock();
        }
        future.get();
        Thread.sleep(10L);
        runningList = manager.getRunningCompactionTaskList();
        Assert.assertEquals((long)0L, (long)runningList.size());
        manager.waitAllCompactionFinish();
    }

    @Test
    public void testSizeTieredCompactionStatus() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, tsFileManager, this.seqResources, true, this.performer, 0L);
        ((TsFileResource)this.seqResources.get(0)).readLock();
        CompactionTaskManager.getInstance().addTaskToWaitingQueue((AbstractCompactionTask)task);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((resource.isCompactionCandidate() || resource.isCompacting() ? 1 : 0) != 0);
        }
        Future future = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task);
        ((TsFileResource)this.seqResources.get(0)).readUnlock();
        future.get();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
    }

    @Test
    public void testRewriteCrossCompactionFileStatus() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        this.seqResources = this.seqResources.subList(1, 5);
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        CompactionTaskManager.getInstance().addTaskToWaitingQueue((AbstractCompactionTask)task);
        ((TsFileResource)this.seqResources.get(0)).readLock();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertTrue((resource.isCompactionCandidate() || resource.isCompacting() ? 1 : 0) != 0);
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertTrue((resource.isCompactionCandidate() || resource.isCompacting() ? 1 : 0) != 0);
        }
        Future future = CompactionTaskManager.getInstance().getCompactionTaskFutureMayBlock((AbstractCompactionTask)task);
        ((TsFileResource)this.seqResources.get(0)).readUnlock();
        future.get();
        for (TsFileResource resource : this.seqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
        for (TsFileResource resource : this.unseqResources) {
            Assert.assertFalse((boolean)resource.isCompactionCandidate());
        }
    }
}

