/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskPriorityType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskComparatorTest {
    private final Logger LOGGER = LoggerFactory.getLogger(CompactionTaskComparatorTest.class);
    private FixedPriorityBlockingQueue<AbstractCompactionTask> compactionTaskQueue = new FixedPriorityBlockingQueue(1024, (Comparator)new DefaultCompactionTaskComparatorImpl());
    private TsFileManager tsFileManager = new TsFileManager("fakeSg", "0", "/");

    @Before
    public void setUp() {
        this.compactionTaskQueue.clear();
    }

    @After
    public void tearDown() {
        new CompactionConfigRestorer().restoreCompactionConfig();
    }

    @Test
    public void testFileNumCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileSizeCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j - i + 101));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileCompactCountCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 10; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-%d-0.tsfile", i + j, i + j, j - i + 101)), 1L));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPriorityQueueSizeLimit() {
        int i;
        MinMaxPriorityQueue limitQueue = MinMaxPriorityQueue.orderedBy((Comparator)new DefaultCompactionTaskComparatorImpl()).maximumSize(50).create();
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 10; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-%d-0.tsfile", i + j, i + j, j - i + 101)), 1L));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
            limitQueue.add((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100 && limitQueue.size() > 0; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)limitQueue.poll();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileVersionCompare() throws InterruptedException {
        int i;
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = 0; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j, j - i + 101)), 1L));
            }
            compactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
            this.compactionTaskQueue.put((Object)compactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == compactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComparationOfDifferentTaskType() throws InterruptedException {
        AbstractCompactionTask currentTask;
        int i;
        IoTDBDescriptor.getInstance().getConfig().setCompactionPriority(CompactionPriority.INNER_CROSS);
        AbstractCompactionTask[] innerCompactionTasks = new AbstractCompactionTask[100];
        AbstractCompactionTask[] crossCompactionTasks = new AbstractCompactionTask[100];
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            innerCompactionTasks[i] = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
        }
        for (i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> sequenceResources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                sequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            ArrayList<TsFileResource> unsequenceResources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                unsequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            crossCompactionTasks[i] = new FakeCrossSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, sequenceResources, unsequenceResources, 0L);
        }
        for (i = 0; i < 100; ++i) {
            this.compactionTaskQueue.put((Object)innerCompactionTasks[i]);
            this.compactionTaskQueue.put((Object)crossCompactionTasks[i]);
        }
        for (i = 0; i < 100; ++i) {
            currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == innerCompactionTasks[99 - i] ? 1 : 0) != 0);
        }
        for (i = 0; i < 100; ++i) {
            currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == crossCompactionTasks[99 - i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComparationOfCrossSpaceTask() throws InterruptedException {
        int j;
        ArrayList<TsFileResource> unsequenceResources;
        ArrayList<TsFileResource> sequenceResources;
        int i;
        AbstractCompactionTask[] crossCompactionTasks = new AbstractCompactionTask[200];
        for (i = 0; i < 100; ++i) {
            sequenceResources = new ArrayList<TsFileResource>();
            for (int j2 = 0; j2 < i + 1; ++j2) {
                sequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j2, i + j2)), j2));
            }
            unsequenceResources = new ArrayList<TsFileResource>();
            for (j = i; j < 100; ++j) {
                unsequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            crossCompactionTasks[i] = new FakeCrossSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, sequenceResources, unsequenceResources, 0L);
            this.compactionTaskQueue.put((Object)crossCompactionTasks[i]);
        }
        for (i = 100; i < 200; ++i) {
            sequenceResources = new ArrayList();
            for (int j3 = 0; j3 < 101; ++j3) {
                sequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j3, i + j3)), j3));
            }
            unsequenceResources = new ArrayList();
            for (j = 199; j >= i; --j) {
                unsequenceResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            crossCompactionTasks[i] = new FakeCrossSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, sequenceResources, unsequenceResources, 0L);
            this.compactionTaskQueue.put((Object)crossCompactionTasks[i]);
        }
        for (i = 0; i < 200; ++i) {
            AbstractCompactionTask currentTask = (AbstractCompactionTask)this.compactionTaskQueue.take();
            Assert.assertTrue((currentTask == crossCompactionTasks[i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSerialId() throws InterruptedException {
        AbstractCompactionTask[] compactionTasks = new AbstractCompactionTask[100];
        TsFileManager[] tsFileManagers = new TsFileManager[10];
        for (int i = 0; i < 10; ++i) {
            tsFileManagers[i] = new TsFileManager("fakeSg" + i, "0", "/");
            for (int j = 0; j < 10; ++j) {
                ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
                for (int k = 0; k < 10; ++k) {
                    resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", j * 10 + k, j * 10 + k)), 10L));
                }
                this.compactionTaskQueue.put((Object)new FakedInnerSpaceCompactionTask("fakeSg" + i, 0L, tsFileManagers[i], true, resources, j));
            }
        }
        HashMap<String, AtomicInteger> taskCount = new HashMap<String, AtomicInteger>();
        for (int i = 0; i < 10; ++i) {
            taskCount.put("fakeSg" + i + "-0", new AtomicInteger(0));
        }
        long cnt = 0L;
        while (this.compactionTaskQueue.size() > 0) {
            int i;
            for (i = 0; i < 10; ++i) {
                AbstractCompactionTask task = (AbstractCompactionTask)this.compactionTaskQueue.take();
                String id = CompactionTaskManager.getSgWithRegionId((String)task.getStorageGroupName(), (String)task.getDataRegionId());
                ((AtomicInteger)taskCount.get(id)).incrementAndGet();
            }
            ++cnt;
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((long)cnt, (long)((AtomicInteger)taskCount.get("fakeSg" + i + "-0")).get());
            }
        }
    }

    @Test
    public void testCompareByMaxModsFileSize() throws InterruptedException, IllegalPathException, IOException {
        for (int i = 0; i < 100; ++i) {
            ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
            for (int j = i; j < 100; ++j) {
                resources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i + j, i + j)), j));
            }
            FakedInnerSpaceCompactionTask innerTask = new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, resources, 0L);
            this.compactionTaskQueue.put((Object)innerTask);
        }
        String targetFileName = "101-101-0-0.tsfile";
        FakedTsFileResource fakedTsFileResource = new FakedTsFileResource(new File(targetFileName), 100L);
        fakedTsFileResource.getModFile().write((Modification)new Deletion(new PartialPath("root.test.d1"), 1L, 1L));
        this.compactionTaskQueue.put((Object)new FakedInnerSpaceCompactionTask("fakeSg", 0L, this.tsFileManager, true, Collections.singletonList(fakedTsFileResource), 0L));
        FakedInnerSpaceCompactionTask task = (FakedInnerSpaceCompactionTask)((Object)this.compactionTaskQueue.take());
        Assert.assertEquals((Object)targetFileName, (Object)((TsFileResource)task.getSelectedTsFileResourceList().get(0)).getTsFile().getName());
        fakedTsFileResource.getModFile().remove();
    }

    @Test
    public void testCompareByTimePartitionWithInnerSpaceCompaction() throws InterruptedException {
        int i;
        ArrayList<TsFileResource> resources1 = new ArrayList<TsFileResource>();
        for (int i2 = 0; i2 < 10; ++i2) {
            resources1.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i2, i2)), 10L));
        }
        FixedPriorityBlockingQueue candidateCompactionTaskQueue = new FixedPriorityBlockingQueue(IoTDBDescriptor.getInstance().getConfig().getCandidateCompactionTaskQueueSize(), (Comparator)new DefaultCompactionTaskComparatorImpl());
        for (i = 0; i < 10; ++i) {
            FakedInnerSpaceCompactionTask task = new FakedInnerSpaceCompactionTask("fakeSg", i, this.tsFileManager, true, resources1, 0L);
            candidateCompactionTaskQueue.put((Object)task);
        }
        for (i = 9; i >= 0; --i) {
            Assert.assertEquals((long)((AbstractCompactionTask)candidateCompactionTaskQueue.take()).getTimePartition(), (long)i);
        }
    }

    @Test
    public void testCompareByTimePartitionWithCrossSpaceCompaction() throws InterruptedException {
        int i;
        int i2;
        ArrayList<FakedTsFileResource> seqResources = new ArrayList<FakedTsFileResource>();
        ArrayList<FakedTsFileResource> unseqResources = new ArrayList<FakedTsFileResource>();
        for (i2 = 0; i2 < 10; ++i2) {
            seqResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i2, i2)), 10L));
        }
        for (i2 = 10; i2 < 20; ++i2) {
            unseqResources.add(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", i2, i2)), 10L));
        }
        FixedPriorityBlockingQueue candidateCompactionTaskQueue = new FixedPriorityBlockingQueue(IoTDBDescriptor.getInstance().getConfig().getCandidateCompactionTaskQueueSize(), (Comparator)new DefaultCompactionTaskComparatorImpl());
        for (i = 0; i < 10; ++i) {
            CrossSpaceCompactionTask task = new CrossSpaceCompactionTask((long)i, this.tsFileManager, seqResources, unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
            candidateCompactionTaskQueue.put((Object)task);
        }
        for (i = 9; i >= 0; --i) {
            Assert.assertEquals((long)((AbstractCompactionTask)candidateCompactionTaskQueue.take()).getTimePartition(), (long)i);
        }
    }

    @Test
    public void testCompareByCompactionTaskType() throws InterruptedException {
        FixedPriorityBlockingQueue candidateCompactionTaskQueue = new FixedPriorityBlockingQueue(IoTDBDescriptor.getInstance().getConfig().getCandidateCompactionTaskQueueSize(), (Comparator)new DefaultCompactionTaskComparatorImpl());
        candidateCompactionTaskQueue.put((Object)new FakedInnerSpaceCompactionTask("fakeSg", 1L, this.tsFileManager, true, Collections.singletonList(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", 1, 1)), 1L)), 0L, CompactionTaskPriorityType.MOD_SETTLE));
        candidateCompactionTaskQueue.put((Object)new FakedInnerSpaceCompactionTask("fakeSg", 1L, this.tsFileManager, true, Collections.singletonList(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", 1, 2)), 1L)), 0L, CompactionTaskPriorityType.NORMAL));
        candidateCompactionTaskQueue.put((Object)new FakedInnerSpaceCompactionTask("fakeSg", 1L, this.tsFileManager, true, Collections.singletonList(new FakedTsFileResource(new File(String.format("%d-%d-0-0.tsfile", 1, 3)), 1L)), 0L, CompactionTaskPriorityType.MOD_SETTLE));
        Assert.assertEquals((Object)((AbstractCompactionTask)candidateCompactionTaskQueue.take()).getCompactionTaskPriorityType(), (Object)CompactionTaskPriorityType.MOD_SETTLE);
        Assert.assertEquals((Object)((AbstractCompactionTask)candidateCompactionTaskQueue.take()).getCompactionTaskPriorityType(), (Object)CompactionTaskPriorityType.MOD_SETTLE);
        Assert.assertEquals((Object)((AbstractCompactionTask)candidateCompactionTaskQueue.take()).getCompactionTaskPriorityType(), (Object)CompactionTaskPriorityType.NORMAL);
    }

    private static class FakedTsFileResource
    extends TsFileResource {
        long tsfileSize = 0L;

        public FakedTsFileResource(File tsfile, long tsfileSize) {
            super(tsfile);
            this.tsfileSize = tsfileSize;
        }

        public long getTsFileSize() {
            return this.tsfileSize;
        }
    }

    private static class FakeCrossSpaceCompactionTask
    extends CrossSpaceCompactionTask {
        public FakeCrossSpaceCompactionTask(String fullStorageGroupName, long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedSequenceFiles, List<TsFileResource> selectedUnsequenceFiles, long serialId) {
            super(timePartition, tsFileManager, selectedSequenceFiles, selectedUnsequenceFiles, (ICrossCompactionPerformer)new ReadPointCompactionPerformer(), 0L, serialId);
        }

        public boolean doCompaction() {
            return true;
        }

        public boolean equalsOtherTask(AbstractCompactionTask other) {
            return false;
        }
    }

    private static class FakedInnerSpaceCompactionTask
    extends InnerSpaceCompactionTask {
        public FakedInnerSpaceCompactionTask(String storageGroupName, long timePartition, TsFileManager tsFileManager, boolean sequence, List<TsFileResource> selectedTsFileResourceList, long serialId) {
            super(timePartition, tsFileManager, selectedTsFileResourceList, sequence, (ICompactionPerformer)new FastCompactionPerformer(false), serialId);
        }

        public FakedInnerSpaceCompactionTask(String storageGroupName, long timePartition, TsFileManager tsFileManager, boolean sequence, List<TsFileResource> selectedTsFileResourceList, long serialId, CompactionTaskPriorityType compactionTaskPriorityType) {
            super(timePartition, tsFileManager, selectedTsFileResourceList, sequence, (ICompactionPerformer)new FastCompactionPerformer(false), serialId, compactionTaskPriorityType);
        }

        protected boolean doCompaction() {
            return true;
        }

        public boolean equalsOtherTask(AbstractCompactionTask other) {
            return false;
        }
    }
}

