/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionClearUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionSchedulerWithFastPerformerTest {
    private static final Logger logger = LoggerFactory.getLogger(CompactionSchedulerWithFastPerformerTest.class);
    static final String COMPACTION_TEST_SG = "root.compactionSchedulerTest_";
    static final long MAX_WAITING_TIME = 60000L;
    static final long SCHEDULE_AGAIN_TIME = 30000L;
    static final String[] fullPaths = new String[]{".device0.sensor0", ".device0.sensor1", ".device0.sensor2", ".device0.sensor3", ".device0.sensor4", ".device0.sensor5", ".device0.sensor6", ".device0.sensor7", ".device0.sensor8", ".device0.sensor9", ".device1.sensor0", ".device1.sensor1", ".device1.sensor2", ".device1.sensor3", ".device1.sensor4"};

    @Before
    public void setUp() throws MetadataException, IOException {
        CompactionClearUtils.clearAllCompactionFiles();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
        File basicOutputDir = new File(TestConstant.BASE_OUTPUT_PATH);
        IoTDBDescriptor.getInstance().getConfig().setCompactionPriority(CompactionPriority.BALANCE);
        if (!basicOutputDir.exists()) {
            Assert.assertTrue((boolean)basicOutputDir.mkdirs());
        }
        IoTDBDescriptor.getInstance().getConfig().setCrossCompactionPerformer(CrossCompactionPerformer.FAST);
        IoTDBDescriptor.getInstance().getConfig().setInnerSeqCompactionPerformer(InnerSeqCompactionPerformer.FAST);
        IoTDBDescriptor.getInstance().getConfig().setInnerUnseqCompactionPerformer(InnerUnseqCompactionPerformer.FAST);
        IoTDBDescriptor.getInstance().getConfig().setMinCrossCompactionUnseqFileLevel(0);
        CompactionTaskManager.getInstance().start();
        while (CompactionTaskManager.getInstance().getExecutingTaskCount() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        CompactionTaskManager.getInstance().stop();
        new CompactionConfigRestorer().restoreCompactionConfig();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        CompactionClearUtils.clearAllCompactionFiles();
        EnvironmentUtils.cleanAllDir();
        CompactionClearUtils.deleteEmptyDir(new File("target"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test1");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(0x80000000L);
        String sgName = "root.compactionSchedulerTest_test1";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    totalWaitingTime += 100L;
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (totalWaitingTime <= 60000L) continue;
                Assert.fail();
                break;
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test2");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        long origin = SystemInfo.getInstance().getMemorySizeForCompaction();
        SystemInfo.getInstance().setMemorySizeForCompaction(0x80000000L * (long)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount());
        try {
            String sgName = "root.compactionSchedulerTest_test2";
            try {
                TsFileResource tsFileResource;
                int i;
                CompactionTaskManager.getInstance().restart();
                TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
                HashSet<String> fullPath = new HashSet<String>();
                for (String device : fullPaths) {
                    fullPath.add(sgName + device);
                }
                for (i = 0; i < 100; ++i) {
                    ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                    ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                    tsFileManager.add(tsFileResource, true);
                }
                for (i = 0; i < 100; ++i) {
                    ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                    ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                    pagePointsNum.add(100L);
                    chunkPagePointsNum.add(pagePointsNum);
                    tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                    CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                    tsFileManager.add(tsFileResource, false);
                }
                CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                long totalWaitingTime = 0L;
                while (tsFileManager.getTsFileList(false).size() > 1) {
                    try {
                        Thread.sleep(100L);
                        CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                        if ((totalWaitingTime += 100L) <= 60000L) continue;
                        Assert.fail();
                        break;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                totalWaitingTime = 0L;
                while (tsFileManager.getTsFileList(false).size() > 0) {
                    try {
                        Thread.sleep(10L);
                        if ((totalWaitingTime += 10L) > 60000L) {
                            Assert.fail();
                            break;
                        }
                        if (totalWaitingTime % 10000L == 0L) {
                            logger.warn("sequence file num is {}, unsequence file num is {}", (Object)tsFileManager.getTsFileList(true).size(), (Object)tsFileManager.getTsFileList(false).size());
                        }
                        if (totalWaitingTime % 30000L != 0L) continue;
                        logger.warn("Has waited for {} s, Schedule again", (Object)(totalWaitingTime / 1000L));
                        CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                tsFileManager.setAllowCompaction(false);
                this.stopCompactionTaskManager();
            }
            finally {
                IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
                IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
                IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
                IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
            }
        }
        finally {
            SystemInfo.getInstance().setMemorySizeForCompaction(origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test3() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test3");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        String sgName = "root.compactionSchedulerTest_test3";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    totalWaitingTime += 100L;
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)1L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test4() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test4");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(0x80000000L);
        String sgName = "root.compactionSchedulerTest_test4";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test5() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test5");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        String sgName = "root.compactionSchedulerTest_test5";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test6() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test6");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        String sgName = "root.compactionSchedulerTest_test6";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 1) {
                Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test7() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test7");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        String sgName = "root.compactionSchedulerTest_test7";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 1) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test8() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test8");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(100);
        String sgName = "root.compactionSchedulerTest_test8";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test9() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test9");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test9";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 50) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 25) {
                Thread.sleep(100L);
                CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                if ((totalWaitingTime += 100L) <= 60000L) continue;
                Assert.fail();
            }
            Assert.assertTrue((tsFileManager.getTsFileList(true).size() <= 25 ? 1 : 0) != 0);
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test10() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test10");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        boolean prevEnableCrossCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(false);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test10";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 50) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 25) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
            IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(prevEnableCrossCompaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test11() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test11");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test11";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 50) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 25) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test12() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test12");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(50);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test12";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 98) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 96) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test14() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test14");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test13";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 99) {
                try {
                    Thread.sleep(100L);
                    Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 98) {
                try {
                    Thread.sleep(100L);
                    Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test15() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test15");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test14";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 99) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(true).size() > 98) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (tsFileManager.getTsFileList(false).size() > 0) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test16() throws IOException, MetadataException, InterruptedException {
        logger.warn("Running test16");
        boolean prevEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(false);
        boolean prevEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(false);
        int prevCompactionConcurrentThread = IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount();
        IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(1);
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        String sgName = "root.compactionSchedulerTest_test16";
        try {
            TsFileResource tsFileResource;
            int i;
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(true, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            for (i = 0; i < 100; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                tsFileResource = CompactionFileGeneratorUtils.generateTsFileResource(false, i + 1, sgName);
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 50, tsFileResource);
                tsFileManager.add(tsFileResource, false);
            }
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            long totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 98) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            totalWaitingTime = 0L;
            while (tsFileManager.getTsFileList(false).size() > 96) {
                try {
                    Thread.sleep(100L);
                    CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                    if ((totalWaitingTime += 100L) <= 60000L) continue;
                    Assert.fail();
                    break;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertEquals((long)100L, (long)tsFileManager.getTsFileList(true).size());
            tsFileManager.setAllowCompaction(false);
            this.stopCompactionTaskManager();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(prevEnableSeqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(prevEnableUnseqSpaceCompaction);
            IoTDBDescriptor.getInstance().getConfig().setCompactionThreadCount(prevCompactionConcurrentThread);
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeFileInLowerLevel() throws Exception {
        logger.warn("Running test16");
        int prevMaxCompactionCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(2);
        long originTargetSize = IoTDBDescriptor.getInstance().getConfig().getTargetCompactionFileSize();
        IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(0x100000L);
        String sgName = "root.compactionSchedulerTest_test17";
        try {
            CompactionTaskManager.getInstance().restart();
            TsFileManager tsFileManager = new TsFileManager(sgName, "0", "target");
            HashSet<String> fullPath = new HashSet<String>();
            for (String device : fullPaths) {
                fullPath.add(sgName + device);
            }
            for (int i = 0; i < 10; ++i) {
                ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
                ArrayList<Long> pagePointsNum = new ArrayList<Long>();
                pagePointsNum.add(100L);
                chunkPagePointsNum.add(pagePointsNum);
                TsFileResource tsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat(File.separator).concat("sequence").concat(File.separator).concat(sgName).concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator).concat(i + 1 + "-" + (i + 1) + "-" + 1 + "-" + 0 + ".tsfile")));
                CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 100 * i + 100, tsFileResource);
                tsFileManager.add(tsFileResource, true);
            }
            ArrayList<List<Long>> chunkPagePointsNum = new ArrayList<List<Long>>();
            ArrayList<Long> pagePointsNum = new ArrayList<Long>();
            pagePointsNum.add(100000L);
            chunkPagePointsNum.add(pagePointsNum);
            TsFileResource tsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat(File.separator).concat("sequence").concat(File.separator).concat(sgName).concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator).concat("11-11-0-0.tsfile")));
            CompactionFileGeneratorUtils.writeTsFile(fullPath, chunkPagePointsNum, 1100L, tsFileResource);
            tsFileManager.add(tsFileResource, true);
            CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
            Thread.sleep(100L);
            long sleepTime = 0L;
            while (tsFileManager.getTsFileList(true).size() >= 2) {
                CompactionScheduler.scheduleCompaction((TsFileManager)tsFileManager, (long)0L);
                tsFileManager.readLock();
                List resources = tsFileManager.getTsFileList(true);
                int previousFileLevel = TsFileNameGenerator.getTsFileName((String)((TsFileResource)resources.get(0)).getTsFile().getName()).getInnerCompactionCnt();
                boolean canMerge = false;
                for (int i = 1; i < resources.size(); ++i) {
                    int currentFileLevel = TsFileNameGenerator.getTsFileName((String)((TsFileResource)resources.get(i)).getTsFile().getName()).getInnerCompactionCnt();
                    if (currentFileLevel == previousFileLevel) {
                        canMerge = true;
                        break;
                    }
                    previousFileLevel = currentFileLevel;
                }
                tsFileManager.readUnlock();
                if (!canMerge) break;
                Thread.sleep(100L);
                if ((sleepTime += 100L) < 20000L) continue;
                Assert.fail();
            }
            this.stopCompactionTaskManager();
            tsFileManager.setAllowCompaction(false);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(prevMaxCompactionCandidateFileNum);
            IoTDBDescriptor.getInstance().getConfig().setTargetCompactionFileSize(originTargetSize);
        }
    }

    public void stopCompactionTaskManager() {
        CompactionTaskManager.getInstance().clearCandidateQueue();
        while (CompactionTaskManager.getInstance().getRunningCompactionTaskList().size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }
}

