/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.util.Arrays;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionTestFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionOverlapCheckTest
extends AbstractCompactionTest {
    long initChunkSizeLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkSizeLowerBoundInCompaction();
    long initChunkPointNumLowerBound = IoTDBDescriptor.getInstance().getConfig().getChunkPointNumLowerBoundInCompaction();
    boolean isEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(10240L);
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(1000L);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        IoTDBDescriptor.getInstance().getConfig().setChunkSizeLowerBoundInCompaction(this.initChunkSizeLowerBound);
        IoTDBDescriptor.getInstance().getConfig().setChunkPointNumLowerBoundInCompaction(this.initChunkPointNumLowerBound);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(this.isEnableUnseqSpaceCompaction);
    }

    @Test
    public void testOverlapFilesInnerSequenceSpaceCompactionWithReadChunkCompactionPerformerWithNonAlignedSeries() throws IOException {
        this.prepareOverlapSequenceFilesWithNonAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesInnerSequenceSpaceCompactionWithReadChunkCompactionPerformerWithAlignedSeries() throws IOException {
        this.prepareOverlapSequenceFilesWithAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesInnerSequenceSpaceCompactionWithFastCompactionPerformerWithNonAlignedSeries() throws IOException {
        this.prepareOverlapSequenceFilesWithNonAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesInnerSequenceSpaceCompactionWithFastCompactionPerformerWithAlignedSeries() throws IOException {
        this.prepareOverlapSequenceFilesWithAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesInnerUnSequenceSpaceCompactionWithFastCompactionPerformerWithNonAlignedSeries() throws IOException {
        this.prepareInsideChunkOverlapUnSequenceFilesWithNonAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesInnerUnSequenceSpaceCompactionWithFastCompactionPerformerWithAlignedSeries() throws IOException {
        this.prepareInsideChunkOverlapUnSequenceFilesWithAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.unseqResources, false, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesCrossSpaceCompactionWithFastCompactionPerformerWithNonAlignedSeries() throws IOException {
        this.prepareOverlapSequenceFilesWithNonAlignedSeries();
        this.prepareInsideChunkOverlapUnSequenceFilesWithNonAlignedSeries();
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertFalse((boolean)task.start());
    }

    @Test
    public void testOverlapFilesCrossSpaceCompactionWithFastCompactionPerformerWithAlignedSeries() throws IOException {
        this.prepareOverlapSequenceFilesWithAlignedSeries();
        this.prepareInsideChunkOverlapUnSequenceFilesWithAlignedSeries();
        CrossSpaceCompactionTask task = new CrossSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, this.unseqResources, (ICrossCompactionPerformer)new FastCompactionPerformer(true), 0L, 0L);
        Assert.assertFalse((boolean)task.start());
    }

    private void prepareOverlapSequenceFilesWithNonAlignedSeries() throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(1L, 9L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
    }

    private void prepareOverlapSequenceFilesWithAlignedSeries() throws IOException {
        TsFileResource seqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource seqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(seqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[]{new TimeRange(1L, 9L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.seqResources.add(seqResource1);
        this.seqResources.add(seqResource2);
        this.tsFileManager.addAll(this.seqResources, true);
    }

    private void prepareInsideChunkOverlapUnSequenceFilesWithNonAlignedSeries() throws IOException {
        TsFileResource unseqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource unseqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleNonAlignedSeriesToCurrentDevice("s1", new TimeRange[]{new TimeRange(35L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.tsFileManager.addAll(this.unseqResources, false);
    }

    private void prepareInsideChunkOverlapUnSequenceFilesWithAlignedSeries() throws IOException {
        TsFileResource unseqResource1 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqResource1);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[][][]{{{new TimeRange(10L, 12L), new TimeRange(3L, 12L)}}}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        TsFileResource unseqResource2 = this.createEmptyFileAndResource(true);
        try (CompactionTestFileWriter writer = new CompactionTestFileWriter(unseqResource2);){
            writer.startChunkGroup("d1");
            writer.generateSimpleAlignedSeriesToCurrentDevice(Arrays.asList("s1", "s2"), new TimeRange[]{new TimeRange(35L, 40L)}, TSEncoding.PLAIN, CompressionType.LZ4);
            writer.endChunkGroup();
            writer.endFile();
        }
        this.unseqResources.add(unseqResource1);
        this.unseqResources.add(unseqResource2);
        this.tsFileManager.addAll(this.unseqResources, false);
    }
}

