/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionDataTypeNotMatchTest
extends AbstractCompactionTest {
    private final String oldThreadName = Thread.currentThread().getName();
    private final IDeviceID device = new PlainDeviceID(COMPACTION_TEST_SG + ".d1");

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
        Thread.currentThread().setName("pool-1-IoTDB-Compaction-Worker-1");
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        Thread.currentThread().setName(this.oldThreadName);
    }

    @Test
    public void testCompactNonAlignedSeriesWithReadChunkCompactionPerformer() throws IOException, WriteProcessException {
        this.generateDataTypeNotMatchFilesWithNonAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)));
        Assert.assertEquals((long)2L, (long)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).getStartTime(this.device));
    }

    @Test
    public void testCompactNonAlignedSeriesWithFastCompactionPerformer() throws IOException, WriteProcessException {
        this.generateDataTypeNotMatchFilesWithNonAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)));
        Assert.assertEquals((long)2L, (long)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).getStartTime(this.device));
    }

    @Test
    public void testCompactNonAlignedSeriesWithReadPointCompactionPerformer() throws IOException, WriteProcessException {
        this.generateDataTypeNotMatchFilesWithNonAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadPointCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)));
        Assert.assertEquals((long)2L, (long)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).getStartTime(this.device));
    }

    @Test
    public void testCompactAlignedSeriesWithReadChunkCompactionPerformer() throws IOException, WriteProcessException {
        this.generateDataTypeNotMatchFilesWithAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadChunkCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)));
        Assert.assertEquals((long)2L, (long)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).getStartTime(this.device));
    }

    @Test
    public void testCompactAlignedSeriesWithFastCompactionPerformer() throws IOException, WriteProcessException {
        this.generateDataTypeNotMatchFilesWithAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new FastCompactionPerformer(false), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)));
        Assert.assertEquals((long)2L, (long)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).getStartTime(this.device));
    }

    @Test
    public void testCompactAlignedSeriesWithReadPointCompactionPerformer() throws IOException, WriteProcessException {
        this.generateDataTypeNotMatchFilesWithAlignedSeries();
        InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.tsFileManager, this.seqResources, true, (ICompactionPerformer)new ReadPointCompactionPerformer(), 0L);
        Assert.assertTrue((boolean)task.start());
        TsFileResourceUtils.validateTsFileDataCorrectness((TsFileResource)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)));
        Assert.assertEquals((long)2L, (long)((TsFileResource)this.tsFileManager.getTsFileList(true).get(0)).getStartTime(this.device));
    }

    private void generateDataTypeNotMatchFilesWithNonAlignedSeries() throws IOException, WriteProcessException {
        MeasurementSchema measurementSchema1 = new MeasurementSchema("s1", TSDataType.BOOLEAN);
        TsFileResource resource1 = this.createEmptyFileAndResource(true);
        resource1.setStatusForTest(TsFileResourceStatus.COMPACTING);
        try (TsFileWriter writer = new TsFileWriter(resource1.getTsFile());){
            writer.registerTimeseries(new Path(this.device), measurementSchema1);
            TSRecord record = new TSRecord(1L, this.device);
            record.addTuple((DataPoint)new BooleanDataPoint("s1", true));
            writer.write(record);
            writer.flushAllChunkGroups();
        }
        resource1.updateStartTime(this.device, 1L);
        resource1.updateEndTime(this.device, 1L);
        resource1.serialize();
        this.seqResources.add(resource1);
        MeasurementSchema measurementSchema2 = new MeasurementSchema("s1", TSDataType.INT32);
        TsFileResource resource2 = this.createEmptyFileAndResource(true);
        resource2.setStatusForTest(TsFileResourceStatus.COMPACTING);
        try (TsFileWriter writer = new TsFileWriter(resource2.getTsFile());){
            writer.registerTimeseries(new Path(this.device), measurementSchema2);
            TSRecord record = new TSRecord(2L, this.device);
            record.addTuple((DataPoint)new IntDataPoint("s1", 10));
            writer.write(record);
            writer.flushAllChunkGroups();
        }
        resource2.updateStartTime(this.device, 2L);
        resource2.updateEndTime(this.device, 2L);
        resource2.serialize();
        this.seqResources.add(resource2);
    }

    private void generateDataTypeNotMatchFilesWithAlignedSeries() throws IOException, WriteProcessException {
        ArrayList<MeasurementSchema> measurementSchemas1 = new ArrayList<MeasurementSchema>();
        measurementSchemas1.add(new MeasurementSchema("s1", TSDataType.INT32));
        measurementSchemas1.add(new MeasurementSchema("s2", TSDataType.INT32));
        TsFileResource resource1 = this.createEmptyFileAndResource(true);
        resource1.setStatusForTest(TsFileResourceStatus.COMPACTING);
        try (TsFileWriter writer = new TsFileWriter(resource1.getTsFile());){
            writer.registerAlignedTimeseries(new Path(this.device), measurementSchemas1);
            TSRecord record = new TSRecord(1L, this.device);
            record.addTuple((DataPoint)new IntDataPoint("s1", 0));
            record.addTuple((DataPoint)new IntDataPoint("s2", 1));
            writer.writeAligned(record);
            writer.flushAllChunkGroups();
        }
        resource1.updateStartTime(this.device, 1L);
        resource1.updateEndTime(this.device, 1L);
        resource1.serialize();
        this.seqResources.add(resource1);
        ArrayList<MeasurementSchema> measurementSchemas2 = new ArrayList<MeasurementSchema>();
        measurementSchemas2.add(new MeasurementSchema("s1", TSDataType.BOOLEAN));
        measurementSchemas2.add(new MeasurementSchema("s2", TSDataType.BOOLEAN));
        TsFileResource resource2 = this.createEmptyFileAndResource(true);
        resource2.setStatusForTest(TsFileResourceStatus.COMPACTING);
        try (TsFileWriter writer = new TsFileWriter(resource2.getTsFile());){
            writer.registerAlignedTimeseries(new Path(this.device), measurementSchemas2);
            TSRecord record = new TSRecord(2L, this.device);
            record.addTuple((DataPoint)new BooleanDataPoint("s1", true));
            record.addTuple((DataPoint)new BooleanDataPoint("s2", true));
            writer.writeAligned(record);
            writer.flushAllChunkGroups();
        }
        resource2.updateStartTime(this.device, 2L);
        resource2.updateEndTime(this.device, 2L);
        resource2.serialize();
        this.seqResources.add(resource2);
    }
}

