/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.IoTProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.SimpleProgressIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileResourceProgressIndexTest {
    private final File file = new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)1L, (long)1L, (int)1, (int)1));
    private final TsFileResource tsFileResource = new TsFileResource(this.file);
    private final Map<IDeviceID, Integer> deviceToIndex = new HashMap<IDeviceID, Integer>();
    private final long[] startTimes = new long[100];
    private final long[] endTimes = new long[100];
    private static final int DEVICE_NUM = 100;
    private final List<ProgressIndex> indexList = new ArrayList<ProgressIndex>();
    private static final int INDEX_NUM = 1000;

    @Before
    public void setUp() {
        IntStream.range(0, 100).forEach(i -> this.deviceToIndex.put((IDeviceID)new PlainDeviceID("root.sg.d" + i), i));
        DeviceTimeIndex deviceTimeIndex = new DeviceTimeIndex(this.deviceToIndex, this.startTimes, this.endTimes);
        IntStream.range(0, 100).forEach(i -> {
            deviceTimeIndex.updateStartTime((IDeviceID)new PlainDeviceID("root.sg.d" + i), (long)i);
            deviceTimeIndex.updateEndTime((IDeviceID)new PlainDeviceID("root.sg.d" + i), (long)(i + 1));
        });
        this.tsFileResource.setTimeIndex((ITimeIndex)deviceTimeIndex);
        this.tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
        IntStream.range(0, 1000).forEach(i -> this.indexList.add(new MockProgressIndex(i)));
    }

    @After
    public void tearDown() throws IOException {
        File resourceFile;
        if (this.file.exists()) {
            FileUtils.delete((File)this.file);
        }
        if ((resourceFile = new File(this.file.getName() + ".resource")).exists()) {
            FileUtils.delete((File)resourceFile);
        }
    }

    @Test
    public void testProgressIndexRecorder() {
        HybridProgressIndex hybridProgressIndex = new HybridProgressIndex((ProgressIndex)new SimpleProgressIndex(3, 4L));
        hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new SimpleProgressIndex(6, 6L));
        hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new RecoverProgressIndex(1, new SimpleProgressIndex(1, 2L)));
        hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new RecoverProgressIndex(1, new SimpleProgressIndex(1, 3L)));
        hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new RecoverProgressIndex(2, new SimpleProgressIndex(4, 3L)));
        hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new RecoverProgressIndex(3, new SimpleProgressIndex(5, 5L)));
        Assert.assertTrue((boolean)hybridProgressIndex.isAfter((ProgressIndex)new SimpleProgressIndex(6, 5L)));
        Assert.assertTrue((boolean)hybridProgressIndex.isAfter((ProgressIndex)new RecoverProgressIndex(3, new SimpleProgressIndex(5, 4L))));
        Assert.assertTrue((boolean)new MockProgressIndex(0).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        this.indexList.forEach(arg_0 -> ((TsFileResource)this.tsFileResource).updateProgressIndex(arg_0));
        Assert.assertFalse((boolean)new MockProgressIndex(-1).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        Assert.assertFalse((boolean)new MockProgressIndex(0).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        Assert.assertFalse((boolean)new MockProgressIndex(1).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        Assert.assertFalse((boolean)new MockProgressIndex(999).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        Assert.assertTrue((boolean)new MockProgressIndex(1000).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        Assert.assertTrue((boolean)new MockProgressIndex(Integer.MAX_VALUE).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
        Assert.assertFalse((boolean)new MockProgressIndex(1, 999).isAfter(this.tsFileResource.getMaxProgressIndexAfterClose()));
    }

    @Test
    public void testProgressIndexRecorderSerialize() {
    }

    @Test
    public void testHybridProgressIndex() {
        IoTProgressIndex ioTProgressIndex = new IoTProgressIndex(Integer.valueOf(1), Long.valueOf(123L));
        RecoverProgressIndex recoverProgressIndex = new RecoverProgressIndex(1, new SimpleProgressIndex(2, 2L));
        HybridProgressIndex hybridProgressIndex = new HybridProgressIndex((ProgressIndex)ioTProgressIndex);
        hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)recoverProgressIndex);
        Assert.assertTrue((boolean)hybridProgressIndex.isAfter((ProgressIndex)new IoTProgressIndex(Integer.valueOf(1), Long.valueOf(100L))));
        Assert.assertTrue((boolean)hybridProgressIndex.isAfter((ProgressIndex)new RecoverProgressIndex(1, new SimpleProgressIndex(1, 2L))));
        Assert.assertFalse((boolean)hybridProgressIndex.isAfter((ProgressIndex)new IoTProgressIndex(Integer.valueOf(1), Long.valueOf(200L))));
        Assert.assertFalse((boolean)hybridProgressIndex.isAfter((ProgressIndex)new IoTProgressIndex(Integer.valueOf(2), Long.valueOf(200L))));
        Assert.assertFalse((boolean)hybridProgressIndex.isAfter((ProgressIndex)new RecoverProgressIndex(1, new SimpleProgressIndex(2, 21L))));
    }

    @Test
    public void testProgressIndexMinimumProgressIndexTopologicalSort() {
        ArrayList progressIndexList = new ArrayList();
        int ioTProgressIndexNum = 100;
        IntStream.range(0, ioTProgressIndexNum).forEach(i -> progressIndexList.add(new IoTProgressIndex(Integer.valueOf(i), Long.valueOf(0L))));
        int minimumProgressIndexNum = 100;
        IntStream.range(0, minimumProgressIndexNum).forEach(i -> progressIndexList.add(MinimumProgressIndex.INSTANCE));
        int hybridProgressIndexNum = 100;
        IntStream.range(0, hybridProgressIndexNum).forEach(i -> progressIndexList.add(new HybridProgressIndex((ProgressIndex)new IoTProgressIndex(Integer.valueOf(i), Long.valueOf(0L)))));
        IntStream.range(0, hybridProgressIndexNum).forEach(i -> progressIndexList.add(new HybridProgressIndex((ProgressIndex)MinimumProgressIndex.INSTANCE)));
        Collections.shuffle(progressIndexList);
        progressIndexList.sort(ProgressIndex::topologicalCompareTo);
        int size = progressIndexList.size();
        for (int i2 = 0; i2 < size - 1; ++i2) {
            int finalI = i2;
            for (int j2 = i2; j2 < size; ++j2) {
                if (!((ProgressIndex)progressIndexList.get(i2)).isAfter((ProgressIndex)progressIndexList.get(j2))) continue;
                System.out.println("progressIndexList.get(i) = " + progressIndexList.get(i2));
                System.out.println("i = " + i2);
                System.out.println("progressIndexList.get(i).getTotalOrderSumTuple() = " + ((ProgressIndex)progressIndexList.get(i2)).getTotalOrderSumTuple());
                System.out.println("progressIndexList.get(j) = " + progressIndexList.get(j2));
                System.out.println("j = " + j2);
                System.out.println("progressIndexList.get(j).getTotalOrderSumTuple() = " + ((ProgressIndex)progressIndexList.get(j2)).getTotalOrderSumTuple());
                System.out.println(System.lineSeparator());
            }
            Assert.assertTrue((boolean)IntStream.range(i2, size).noneMatch(j -> ((ProgressIndex)progressIndexList.get(finalI)).isAfter((ProgressIndex)progressIndexList.get(j))));
        }
    }

    @Test
    public void testProgressIndexTopologicalSort() {
        Random random = new Random();
        ArrayList progressIndexList = new ArrayList();
        int ioTProgressIndexNum = 10000;
        int peerIdRange = 3;
        int searchIndexRange = 100000;
        IntStream.range(0, ioTProgressIndexNum).forEach(i -> progressIndexList.add(new IoTProgressIndex(Integer.valueOf(random.nextInt(peerIdRange)), Long.valueOf(random.nextInt(searchIndexRange)))));
        int simpleProgressIndexNum = 10000;
        int rebootTimesRange = 3;
        int memtableFlushOrderIdRange = 100000;
        IntStream.range(0, simpleProgressIndexNum).forEach(i -> progressIndexList.add(new SimpleProgressIndex(random.nextInt(rebootTimesRange), (long)random.nextInt(memtableFlushOrderIdRange))));
        int recoverProgressIndexNum = 10000;
        int dataNodeIdRange = 3;
        IntStream.range(0, recoverProgressIndexNum).forEach(i -> progressIndexList.add(new RecoverProgressIndex(random.nextInt(dataNodeIdRange), new SimpleProgressIndex(random.nextInt(rebootTimesRange), (long)random.nextInt(memtableFlushOrderIdRange)))));
        int minimumProgressIndexNum = 10000;
        IntStream.range(0, minimumProgressIndexNum).forEach(i -> progressIndexList.add(MinimumProgressIndex.INSTANCE));
        int hybridProgressIndexNum = 10000;
        IntStream.range(0, hybridProgressIndexNum).forEach(i -> {
            HybridProgressIndex hybridProgressIndex = new HybridProgressIndex((ProgressIndex)new IoTProgressIndex(Integer.valueOf(random.nextInt(peerIdRange)), Long.valueOf(random.nextInt(searchIndexRange))));
            if (random.nextInt(2) == 1) {
                hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new SimpleProgressIndex(random.nextInt(rebootTimesRange), (long)random.nextInt(memtableFlushOrderIdRange)));
            }
            if (random.nextInt(2) == 1) {
                hybridProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new RecoverProgressIndex(random.nextInt(dataNodeIdRange), new SimpleProgressIndex(random.nextInt(rebootTimesRange), (long)random.nextInt(memtableFlushOrderIdRange))));
            }
            progressIndexList.add(hybridProgressIndex);
        });
        Collections.shuffle(progressIndexList);
        long startTime = System.currentTimeMillis();
        progressIndexList.sort(ProgressIndex::topologicalCompareTo);
        long costTime = System.currentTimeMillis() - startTime;
        System.out.println("ProgressIndex List Size = " + progressIndexList.size());
        System.out.println("sort time = " + costTime + "ms");
        System.out.println("Sort speed = " + (double)costTime / (double)progressIndexList.size() + "ms/s");
        int size = progressIndexList.size();
        for (int i2 = 0; i2 < size - 1; ++i2) {
            int finalI = i2;
            for (int j2 = i2; j2 < size; ++j2) {
                if (!((ProgressIndex)progressIndexList.get(i2)).isAfter((ProgressIndex)progressIndexList.get(j2))) continue;
                System.out.println("progressIndexList.get(i) = " + progressIndexList.get(i2));
                System.out.println("i = " + i2);
                System.out.println("progressIndexList.get(i).getTotalOrderSumTuple() = " + ((ProgressIndex)progressIndexList.get(i2)).getTotalOrderSumTuple());
                System.out.println("progressIndexList.get(j) = " + progressIndexList.get(j2));
                System.out.println("j = " + j2);
                System.out.println("progressIndexList.get(j).getTotalOrderSumTuple() = " + ((ProgressIndex)progressIndexList.get(j2)).getTotalOrderSumTuple());
                System.out.println(System.lineSeparator());
            }
            Assert.assertTrue((boolean)IntStream.range(i2, size).noneMatch(j -> ((ProgressIndex)progressIndexList.get(finalI)).isAfter((ProgressIndex)progressIndexList.get(j))));
        }
    }

    public static class MockProgressIndex
    extends ProgressIndex {
        private final int type;
        private int val;

        public MockProgressIndex(int val) {
            this(0, val);
        }

        public MockProgressIndex(int type, int val) {
            this.type = type;
            this.val = val;
        }

        public void serialize(ByteBuffer byteBuffer) {
            ReadWriteIOUtils.write((int)this.val, (ByteBuffer)byteBuffer);
        }

        public void serialize(OutputStream stream) throws IOException {
            ReadWriteIOUtils.write((int)this.val, (OutputStream)stream);
        }

        public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
            if (!(progressIndex instanceof MockProgressIndex)) {
                return true;
            }
            MockProgressIndex that = (MockProgressIndex)progressIndex;
            return this.type == that.type && this.val > that.val;
        }

        public boolean equals(ProgressIndex progressIndex) {
            if (!(progressIndex instanceof MockProgressIndex)) {
                return false;
            }
            MockProgressIndex that = (MockProgressIndex)progressIndex;
            return this.type == that.type && this.val == that.val;
        }

        public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
            if (!(progressIndex instanceof MockProgressIndex)) {
                throw new IllegalStateException("Mock update error.");
            }
            MockProgressIndex that = (MockProgressIndex)progressIndex;
            if (that.type == this.type) {
                this.val = Math.max(this.val, that.val);
            }
            return this;
        }

        public ProgressIndexType getType() {
            throw new UnsupportedOperationException("method not implemented.");
        }

        public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
            return new ProgressIndex.TotalOrderSumTuple(new Long[]{this.val});
        }
    }
}

