/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileManagerTest {
    File tempSGDir;
    private TsFileManager tsFileManager;
    private List<TsFileResource> seqResources;
    private List<TsFileResource> unseqResources;

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        TsFileResource resource;
        int i;
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
        this.tsFileManager = new TsFileManager("test", "0", this.tempSGDir.getAbsolutePath());
        this.seqResources = new ArrayList<TsFileResource>();
        for (i = 0; i < 5; ++i) {
            resource = this.generateTsFileResource(i);
            this.seqResources.add(resource);
        }
        this.unseqResources = new ArrayList<TsFileResource>();
        for (i = 6; i < 10; ++i) {
            resource = this.generateTsFileResource(i);
            this.unseqResources.add(resource);
        }
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    private TsFileResource generateTsFileResource(int id) {
        File file = new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)id, (long)id, (int)id, (int)id));
        return new TsFileResource(file);
    }

    @Test
    public void testAddRemoveAndIterator() {
        for (TsFileResource tsFileResource : this.seqResources) {
            this.tsFileManager.add(tsFileResource, true);
        }
        this.tsFileManager.addAll(this.unseqResources, false);
        Assert.assertEquals((long)5L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertEquals((long)4L, (long)this.tsFileManager.getTsFileList(false).size());
        Assert.assertEquals((long)5L, (long)this.tsFileManager.size(true));
        Assert.assertEquals((long)4L, (long)this.tsFileManager.size(false));
        Assert.assertTrue((boolean)this.tsFileManager.contains(this.seqResources.get(0), true));
        Assert.assertFalse((boolean)this.tsFileManager.contains(new TsFileResource(new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("10-10-0-0.tsfile"))), false));
        Assert.assertFalse((boolean)this.tsFileManager.contains(new TsFileResource(new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("10-10-0-0.tsfile"))), false));
        Assert.assertFalse((boolean)this.tsFileManager.isEmpty(true));
        Assert.assertFalse((boolean)this.tsFileManager.isEmpty(false));
        this.tsFileManager.remove((TsFileResource)this.tsFileManager.getTsFileList(true).get(0), true);
        this.tsFileManager.remove((TsFileResource)this.tsFileManager.getTsFileList(false).get(0), false);
        Assert.assertEquals((long)4L, (long)this.tsFileManager.getTsFileList(true).size());
        this.tsFileManager.removeAll(this.tsFileManager.getTsFileList(false), false);
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(false).size());
        long count = 0L;
        Iterator iterator = this.tsFileManager.getIterator(true);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
        this.tsFileManager.removeAll(this.tsFileManager.getTsFileList(true), true);
        Assert.assertEquals((long)0L, (long)this.tsFileManager.getTsFileList(true).size());
        Assert.assertTrue((boolean)this.tsFileManager.isEmpty(true));
        Assert.assertTrue((boolean)this.tsFileManager.isEmpty(false));
        this.tsFileManager.add(new TsFileResource(new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("10-10-10-0.tsfile"))), true);
        this.tsFileManager.add(new TsFileResource(new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("10-10-10-0.tsfile"))), false);
        Assert.assertEquals((long)1L, (long)this.tsFileManager.size(true));
        Assert.assertEquals((long)1L, (long)this.tsFileManager.size(false));
        this.tsFileManager.clear();
        Assert.assertEquals((long)0L, (long)this.tsFileManager.size(true));
        Assert.assertEquals((long)0L, (long)this.tsFileManager.size(false));
    }

    @Test
    public void testIteratorRemove() {
        for (TsFileResource tsFileResource : this.seqResources) {
            this.tsFileManager.add(tsFileResource, true);
        }
        this.tsFileManager.addAll(this.seqResources, false);
        Assert.assertEquals((long)5L, (long)this.tsFileManager.getTsFileList(true).size());
        Iterator tsFileResourceIterator = this.tsFileManager.getIterator(true);
        tsFileResourceIterator.next();
        try {
            tsFileResourceIterator.remove();
        }
        catch (UnsupportedOperationException tsFileResource) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)this.tsFileManager.getTsFileList(true).size());
        TsFileResource tsFileResource1 = new TsFileResource(new File(TestConstant.getTestTsFileDir((String)"root.compactionTest", (long)0L, (long)0L).concat("10-10-1-0.tsfile")));
        TsFileResource tsFileResource2 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("11-11-1-0.tsfile")));
        this.tsFileManager.add(tsFileResource1, true);
        this.tsFileManager.add(tsFileResource2, true);
        TsFileResource tsFileResource3 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("12-12-2-0.tsfile")));
        this.tsFileManager.add(tsFileResource3, true);
        Iterator tsFileResourceIterator2 = this.tsFileManager.getIterator(true);
        int count = 0;
        while (tsFileResourceIterator2.hasNext()) {
            ++count;
            tsFileResourceIterator2.next();
        }
        Assert.assertEquals((long)8L, (long)count);
    }
}

