/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionTest;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LastFlushTimeMapTest {
    private DataRegion dataRegion;
    private String storageGroup = "root.vehicle.d0";
    private String measurementId = "s0";
    private String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.dataRegion = new DataRegionTest.DummyDataRegion(this.systemDir, this.storageGroup);
        StorageEngine.getInstance().setDataRegion(new DataRegionId(0), this.dataRegion);
        CompactionTaskManager.getInstance().start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.dataRegion != null) {
            this.dataRegion.syncDeleteDataFiles();
            StorageEngine.getInstance().deleteDataRegion(new DataRegionId(0));
        }
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
        CompactionTaskManager.getInstance().stop();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testDeviceLastFlushTimeMap() throws IOException, IllegalPathException, WriteProcessException {
        TSRecord record = new TSRecord(10000L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        record = new TSRecord(9999L, "root.vehicle.d1");
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (int j = 1; j <= 10; ++j) {
            record = new TSRecord((long)j, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        Assert.assertEquals((long)10000L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
    }

    @Test
    public void testPartitionLastFlushTimeMap() throws IOException, IllegalPathException, WriteProcessException {
        TSRecord record = new TSRecord(10000L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        record = new TSRecord(9999L, "root.vehicle.d1");
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (int j = 1; j <= 10; ++j) {
            record = new TSRecord((long)j, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertEquals((long)10000L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
        Assert.assertEquals((long)9999L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d1")));
        this.dataRegion.getLastFlushTimeMap().degradeLastFlushTime(0L);
        Assert.assertEquals((long)10000L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
        Assert.assertEquals((long)10000L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d1")));
    }

    @Test
    public void testRecoverLastFlushTimeMap() throws IOException, IllegalPathException, WriteProcessException, DataRegionException {
        TSRecord record = new TSRecord(604800000L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        record = new TSRecord(604799999L, "root.vehicle.d0");
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (int j = 1; j <= 10; ++j) {
            record = new TSRecord((long)j, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertEquals((long)604800000L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(1L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
        Assert.assertEquals((long)604799999L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
        this.dataRegion = new DataRegionTest.DummyDataRegion(this.systemDir, this.storageGroup);
        Assert.assertEquals((long)604800000L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(1L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
        Assert.assertEquals((long)604799999L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)new PlainDeviceID("root.vehicle.d0")));
    }

    @Test
    public void testLastFlushedTimeWhenLargestTimestampInUnSeqSpace() throws IllegalPathException, WriteProcessException {
        String unseqDirPath = TestConstant.BASE_OUTPUT_PATH + "data" + File.separator + "unsequence" + File.separator + "root.vehicle" + File.separator + "0" + File.separator + "0";
        for (int j = 1; j <= 10; ++j) {
            TSRecord record = new TSRecord((long)j, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        PlainDeviceID device = new PlainDeviceID("root.vehicle.d0");
        File unseqResourceFile1 = new File(unseqDirPath + File.separator + "4-4-0-0.tsfile.resource");
        TsFileResource unseqResource1 = new TsFileResource();
        unseqResource1.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        unseqResource1.setFile(unseqResourceFile1);
        unseqResource1.updateStartTime((IDeviceID)device, 1L);
        unseqResource1.updateEndTime((IDeviceID)device, 100L);
        this.dataRegion.updateLastFlushTime(unseqResource1);
        File unseqResourceFile2 = new File(unseqDirPath + File.separator + "5-5-0-0.tsfile.resource");
        TsFileResource unseqResource2 = new TsFileResource();
        unseqResource2.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        unseqResource2.setFile(unseqResourceFile2);
        unseqResource2.updateStartTime((IDeviceID)device, 1L);
        unseqResource2.updateEndTime((IDeviceID)device, 10L);
        this.dataRegion.updateLastFlushTime(unseqResource2);
        File unseqResourceFile3 = new File(unseqDirPath + File.separator + "6-6-0-0.tsfile.resource");
        TsFileResource unseqResource3 = new TsFileResource();
        unseqResource3.setTimeIndex((ITimeIndex)new DeviceTimeIndex());
        unseqResource3.setFile(unseqResourceFile3);
        unseqResource3.updateStartTime((IDeviceID)device, 1L);
        unseqResource3.updateEndTime((IDeviceID)device, 70L);
        this.dataRegion.updateLastFlushTime(unseqResource3);
        Assert.assertEquals((long)100L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)device));
        this.dataRegion.getLastFlushTimeMap().degradeLastFlushTime(0L);
        Assert.assertEquals((long)100L, (long)this.dataRegion.getLastFlushTimeMap().getFlushedTime(0L, (IDeviceID)device));
    }
}

