/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.MemTableManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(DataRegionTest.class);
    private String storageGroup = "root.vehicle.d0";
    private String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");
    private String deviceId = "root.vehicle.d0";
    private String measurementId = "s0";
    private DataRegion dataRegion;
    private QueryContext context = EnvironmentUtils.TEST_QUERY_CONTEXT;
    private double preWriteMemoryVariationReportProportion = config.getWriteMemoryVariationReportProportion();

    @Before
    public void setUp() throws Exception {
        config.setWriteMemoryVariationReportProportion(0.0);
        EnvironmentUtils.envSetUp();
        this.dataRegion = new DummyDataRegion(this.systemDir, this.storageGroup);
        StorageEngine.getInstance().setDataRegion(new DataRegionId(0), this.dataRegion);
        CompactionTaskManager.getInstance().start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.dataRegion != null) {
            this.dataRegion.syncDeleteDataFiles();
            StorageEngine.getInstance().deleteDataRegion(new DataRegionId(0));
        }
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
        CompactionTaskManager.getInstance().stop();
        EnvironmentUtils.cleanEnv();
        config.setWriteMemoryVariationReportProportion(this.preWriteMemoryVariationReportProportion);
    }

    public static InsertRowNode buildInsertRowNodeByTSRecord(TSRecord record) throws IllegalPathException {
        String[] measurements = new String[record.dataPointList.size()];
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[record.dataPointList.size()];
        TSDataType[] dataTypes = new TSDataType[record.dataPointList.size()];
        Object[] values = new Object[record.dataPointList.size()];
        for (int i = 0; i < record.dataPointList.size(); ++i) {
            measurements[i] = ((DataPoint)record.dataPointList.get(i)).getMeasurementId();
            measurementSchemas[i] = new MeasurementSchema(measurements[i], ((DataPoint)record.dataPointList.get(i)).getType(), TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            dataTypes[i] = ((DataPoint)record.dataPointList.get(i)).getType();
            values[i] = ((DataPoint)record.dataPointList.get(i)).getValue();
        }
        QueryId queryId = new QueryId("test_write");
        InsertRowNode insertRowNode = new InsertRowNode(queryId.genPlanNodeId(), new PartialPath(record.deviceId), false, measurements, dataTypes, record.time, values, false);
        insertRowNode.setMeasurementSchemas(measurementSchemas);
        return insertRowNode;
    }

    @Test
    public void testUnseqUnsealedDelete() throws WriteProcessException, IOException, MetadataException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (int j = 1; j <= 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        for (int j = 11; j <= 20; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        MeasurementPath fullPath = new MeasurementPath(this.deviceId, this.measurementId, (IMeasurementSchema)new MeasurementSchema(this.measurementId, TSDataType.INT32, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
        this.dataRegion.deleteByDevice(new PartialPath(this.deviceId, this.measurementId), 0L, 15L, -1L);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.query(Collections.singletonList(fullPath), EnvironmentUtils.TEST_QUERY_CONTEXT, tsfileResourcesForQuery);
        }
        Assert.assertEquals((long)1L, (long)tsfileResourcesForQuery.size());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath);
        long time = 16L;
        for (ReadOnlyMemChunk memChunk : memChunks) {
            IPointReader iterator = memChunk.getPointReader();
            while (iterator.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)time++, (long)timeValuePair.getTimestamp());
            }
        }
    }

    @Test
    public void testSequenceSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException {
        for (int j = 1; j <= 10; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testIoTDBTabletWriteAndSyncClose() throws QueryProcessException, IllegalPathException, WriteProcessException {
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode1);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        for (int r = 50; r < 149; ++r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode2);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)1L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testIoTDBTabletWriteAndDeleteDataRegion() throws QueryProcessException, IllegalPathException, WriteProcessException, TsFileProcessorException {
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode1);
        for (int r = 50; r < 149; ++r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode2);
        Assert.assertTrue((SystemInfo.getInstance().getTotalMemTableSize() > 0L ? 1 : 0) != 0);
        this.dataRegion.syncDeleteDataFiles();
        Assert.assertEquals((long)0L, (long)SystemInfo.getInstance().getTotalMemTableSize());
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
    }

    @Test
    public void testEmptyTabletWriteAndSyncClose() throws QueryProcessException, IllegalPathException, WriteProcessException {
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        BitMap[] bitMaps = new BitMap[]{new BitMap(100), new BitMap(100)};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            bitMaps[0].mark(r);
            bitMaps[1].mark(r);
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, bitMaps, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode1);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        for (int r = 50; r < 149; ++r) {
            times[r - 50] = r;
            bitMaps[0].mark(r - 50);
            bitMaps[1].mark(r - 50);
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, bitMaps, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode2);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testAllMeasurementsFailedTabletWriteAndSyncClose() throws QueryProcessException, IllegalPathException, WriteProcessException {
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        insertTabletNode1.setFailedMeasurementNumber(2);
        this.dataRegion.insertTablet(insertTabletNode1);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        for (int r = 50; r < 149; ++r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        insertTabletNode2.setFailedMeasurementNumber(2);
        this.dataRegion.insertTablet(insertTabletNode2);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testSeqAndUnSeqSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException {
        TSRecord record;
        int j;
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)10L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testAllMeasurementsFailedRecordSeqAndUnSeqSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException {
        InsertRowNode rowNode;
        TSRecord record;
        int j;
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            rowNode = DataRegionTest.buildInsertRowNodeByTSRecord(record);
            rowNode.setFailedMeasurementNumber(1);
            this.dataRegion.insert(rowNode);
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            rowNode = DataRegionTest.buildInsertRowNodeByTSRecord(record);
            rowNode.setFailedMeasurementNumber(1);
            this.dataRegion.insert(rowNode);
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testDisableSeparateDataForInsertRowPlan() throws WriteProcessException, QueryProcessException, IllegalPathException, IOException {
        TSRecord record;
        int j;
        boolean defaultValue = config.isEnableSeparateData();
        config.setEnableSeparateData(false);
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)20L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableSeparateData(defaultValue);
    }

    @Test
    public void testDisableSeparateDataForInsertTablet1() throws QueryProcessException, IllegalPathException, IOException, WriteProcessException {
        boolean defaultEnableDiscard = config.isEnableSeparateData();
        long defaultTimePartition = COMMON_CONFIG.getTimePartitionInterval();
        config.setEnableSeparateData(false);
        COMMON_CONFIG.setTimePartitionInterval(100000L);
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode1);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        for (int r = 149; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode2);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)2L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableSeparateData(defaultEnableDiscard);
        COMMON_CONFIG.setTimePartitionInterval(defaultTimePartition);
    }

    @Test
    public void testDisableSeparateDataForInsertTablet2() throws QueryProcessException, IllegalPathException, IOException, WriteProcessException {
        boolean defaultEnableDiscard = config.isEnableSeparateData();
        long defaultTimePartition = COMMON_CONFIG.getTimePartitionInterval();
        config.setEnableSeparateData(false);
        COMMON_CONFIG.setTimePartitionInterval(1200000L);
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[1200];
        Object[] columns = new Object[]{new int[1200], new long[1200]};
        for (int r = 0; r < 1200; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode1);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        for (int r = 1249; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode2);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)2L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableSeparateData(defaultEnableDiscard);
        COMMON_CONFIG.setTimePartitionInterval(defaultTimePartition);
    }

    @Test
    public void testDisableSeparateDataForInsertTablet3() throws QueryProcessException, IllegalPathException, IOException, WriteProcessException {
        boolean defaultEnableDiscard = config.isEnableSeparateData();
        long defaultTimePartition = COMMON_CONFIG.getTimePartitionInterval();
        config.setEnableSeparateData(false);
        COMMON_CONFIG.setTimePartitionInterval(1000000L);
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[1200];
        Object[] columns = new Object[]{new int[1200], new long[1200]};
        for (int r = 0; r < 1200; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode1 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode1);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        for (int r = 1249; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        InsertTabletNode insertTabletNode2 = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), new PartialPath("root.vehicle.d0"), false, measurements, dataTypes, measurementSchemas, times, null, columns, times.length);
        this.dataRegion.insertTablet(insertTabletNode2);
        this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.dataRegion.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)2L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableSeparateData(defaultEnableDiscard);
        COMMON_CONFIG.setTimePartitionInterval(defaultTimePartition);
    }

    @Test
    public void testInsertUnSequenceRows() throws IllegalPathException, WriteProcessRejectException, QueryProcessException, DataRegionException, TsFileProcessorException {
        int defaultAvgSeriesPointNumberThreshold = config.getAvgSeriesPointNumberThreshold();
        config.setAvgSeriesPointNumberThreshold(2);
        DummyDataRegion dataRegion1 = new DummyDataRegion(this.systemDir, "root.Rows");
        long[] time = new long[]{3L, 4L, 1L, 2L};
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        ArrayList<InsertRowNode> nodes = new ArrayList<InsertRowNode>();
        for (int i = 0; i < 4; ++i) {
            TSRecord record = new TSRecord(time[i], "root.Rows");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(i)));
            nodes.add(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            indexList.add(i);
        }
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""), indexList, nodes);
        dataRegion1.insert(insertRowsNode);
        dataRegion1.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = dataRegion1.query(Collections.singletonList(new PartialPath("root.Rows", this.measurementId)), "root.Rows", this.context, null, null);
        Assert.assertEquals((long)1L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        dataRegion1.syncDeleteDataFiles();
        config.setAvgSeriesPointNumberThreshold(defaultAvgSeriesPointNumberThreshold);
    }

    @Test
    public void testSmallReportProportionInsertRow() throws WriteProcessException, QueryProcessException, IllegalPathException, IOException, DataRegionException, TsFileProcessorException {
        double defaultValue = config.getWriteMemoryVariationReportProportion();
        config.setWriteMemoryVariationReportProportion(0.0);
        DummyDataRegion dataRegion1 = new DummyDataRegion(this.systemDir, "root.ln22");
        for (int j = 21; j <= 30; ++j) {
            TSRecord record = new TSRecord((long)j, "root.ln22");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            dataRegion1.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            dataRegion1.asyncCloseAllWorkingTsFileProcessors();
        }
        dataRegion1.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : dataRegion1.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = dataRegion1.query(Collections.singletonList(new PartialPath("root.ln22", this.measurementId)), "root.ln22", this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        dataRegion1.syncDeleteDataFiles();
        config.setWriteMemoryVariationReportProportion(defaultValue);
    }

    @Test
    public void testMerge() throws WriteProcessException, QueryProcessException, IllegalPathException {
        TSRecord record;
        int j;
        int originCandidateFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerInnerTask();
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(9);
        boolean originEnableSeqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction();
        boolean originEnableUnseqSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction();
        boolean originEnableCrossSpaceCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(true);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(false);
        long finishedCompactionTaskNumWhenTestStart = CompactionTaskManager.getInstance().getFinishedTaskNum();
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
            this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        this.dataRegion.compact();
        long totalWaitingTime = 0L;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((totalWaitingTime += 100L) % 1000L == 0L) {
                logger.warn("has waited for {} seconds", (Object)(totalWaitingTime / 1000L));
            }
            if (totalWaitingTime <= 120000L) continue;
            Assert.fail();
            break;
        } while (CompactionTaskManager.getInstance().getFinishedTaskNum() <= finishedCompactionTaskNumWhenTestStart + 1L);
        QueryDataSource queryDataSource = this.dataRegion.query(Collections.singletonList(new PartialPath(this.deviceId, this.measurementId)), this.deviceId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(originCandidateFileNum);
        IoTDBDescriptor.getInstance().getConfig().setEnableSeqSpaceCompaction(originEnableSeqSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableCrossSpaceCompaction(originEnableCrossSpaceCompaction);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqSpaceCompaction(originEnableUnseqSpaceCompaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testDeleteStorageGroupWhenCompacting() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setFileLimitPerInnerTask(10);
        try {
            for (int j = 0; j < 10; ++j) {
                TSRecord record = new TSRecord((long)j, this.deviceId);
                record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
                this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
                this.dataRegion.asyncCloseAllWorkingTsFileProcessors();
            }
            this.dataRegion.syncCloseAllWorkingTsFileProcessors();
            FastCompactionPerformer performer = new FastCompactionPerformer(false);
            performer.setSourceFiles(this.dataRegion.getSequenceFileList());
            InnerSpaceCompactionTask task = new InnerSpaceCompactionTask(0L, this.dataRegion.getTsFileManager(), this.dataRegion.getSequenceFileList(), true, (ICompactionPerformer)performer, 0L);
            CompactionTaskManager.getInstance().addTaskToWaitingQueue((AbstractCompactionTask)task);
            Thread.sleep(20L);
            List dataRegions = StorageEngine.getInstance().getAllDataRegions();
            ArrayList<DataRegion> regionsToBeDeleted = new ArrayList<DataRegion>();
            for (DataRegion region : dataRegions) {
                if (!region.getDatabaseName().equals(this.storageGroup)) continue;
                regionsToBeDeleted.add(region);
            }
            for (DataRegion region : regionsToBeDeleted) {
                StorageEngine.getInstance().deleteDataRegion(new DataRegionId(Integer.parseInt(region.getDataRegionId())));
            }
            Thread.sleep(500L);
            for (TsFileResource resource : this.dataRegion.getSequenceFileList()) {
                Assert.assertFalse((boolean)resource.getTsFile().exists());
            }
            TsFileResource targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.dataRegion.getSequenceFileList(), (boolean)true);
            Assert.assertFalse((boolean)targetTsFileResource.getTsFile().exists());
            String dataDirectory = targetTsFileResource.getTsFile().getParent();
            File logFile = new File(dataDirectory + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
            Assert.assertFalse((boolean)logFile.exists());
            Assert.assertFalse((boolean)CommonDescriptor.getInstance().getConfig().isReadOnly());
            Assert.assertTrue((boolean)this.dataRegion.getTsFileManager().isAllowCompaction());
        }
        finally {
            new CompactionConfigRestorer().restoreCompactionConfig();
        }
    }

    @Test
    public void testTimedFlushSeqMemTable() throws IllegalPathException, InterruptedException, WriteProcessException, ShutdownException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        boolean prevEnableTimedFlushSeqMemtable = config.isEnableTimedFlushSeqMemtable();
        long preFLushInterval = config.getSeqMemtableFlushInterval();
        config.setEnableTimedFlushSeqMemtable(true);
        config.setSeqMemtableFlushInterval(5L);
        StorageEngine.getInstance().rebootTimedService();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)this.dataRegion.getWorkSequenceTsFileProcessors().size());
        TsFileProcessor tsFileProcessor = (TsFileProcessor)this.dataRegion.getWorkSequenceTsFileProcessors().iterator().next();
        FlushManager flushManager = FlushManager.getInstance();
        tsFileProcessor.getWorkMemTable().getUpdateTime();
        Thread.sleep(500L);
        this.dataRegion.timedFlushSeqMemTable();
        int waitCnt = 0;
        while (tsFileProcessor.getFlushingMemTableSize() != 0 || tsFileProcessor.isManagedByFlushManager() || flushManager.getNumberOfPendingTasks() != 0 || flushManager.getNumberOfPendingSubTasks() != 0 || flushManager.getNumberOfWorkingTasks() != 0 || flushManager.getNumberOfWorkingSubTasks() != 0) {
            Thread.sleep(500L);
            if (++waitCnt % 10 != 0) continue;
            logger.info("already wait {} s", (Object)(waitCnt / 2));
        }
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        config.setEnableTimedFlushSeqMemtable(prevEnableTimedFlushSeqMemtable);
        config.setSeqMemtableFlushInterval(preFLushInterval);
    }

    @Test
    public void testTimedFlushUnseqMemTable() throws IllegalPathException, InterruptedException, WriteProcessException, ShutdownException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        record = new TSRecord(1L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        Assert.assertEquals((long)1L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        boolean prevEnableTimedFlushUnseqMemtable = config.isEnableTimedFlushUnseqMemtable();
        long preFLushInterval = config.getUnseqMemtableFlushInterval();
        config.setEnableTimedFlushUnseqMemtable(true);
        config.setUnseqMemtableFlushInterval(5L);
        StorageEngine.getInstance().rebootTimedService();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)this.dataRegion.getWorkUnsequenceTsFileProcessors().size());
        TsFileProcessor tsFileProcessor = (TsFileProcessor)this.dataRegion.getWorkUnsequenceTsFileProcessors().iterator().next();
        FlushManager flushManager = FlushManager.getInstance();
        tsFileProcessor.getWorkMemTable().getUpdateTime();
        Thread.sleep(500L);
        this.dataRegion.timedFlushUnseqMemTable();
        int waitCnt = 0;
        while (tsFileProcessor.getFlushingMemTableSize() != 0 || tsFileProcessor.isManagedByFlushManager() || flushManager.getNumberOfPendingTasks() != 0 || flushManager.getNumberOfPendingSubTasks() != 0 || flushManager.getNumberOfWorkingTasks() != 0 || flushManager.getNumberOfWorkingSubTasks() != 0) {
            Thread.sleep(500L);
            if (++waitCnt % 10 != 0) continue;
            logger.info("already wait {} s", (Object)(waitCnt / 2));
        }
        Assert.assertEquals((long)0L, (long)MemTableManager.getInstance().getCurrentMemtableNumber());
        config.setEnableTimedFlushUnseqMemtable(prevEnableTimedFlushUnseqMemtable);
        config.setUnseqMemtableFlushInterval(preFLushInterval);
    }

    @Test
    public void testDeleteDataNotInFile() throws IllegalPathException, WriteProcessException, InterruptedException, IOException {
        int i;
        for (i = 0; i < 5; ++i) {
            TSRecord record;
            int count;
            int d;
            if (i % 2 == 0) {
                for (d = 0; d < 2; ++d) {
                    for (count = i * 100; count < i * 100 + 100; ++count) {
                        record = new TSRecord((long)count, "root.vehicle.d" + d);
                        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(count)));
                        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
                    }
                }
            } else {
                for (d = 0; d < 3; ++d) {
                    for (count = i * 100; count < i * 100 + 100; ++count) {
                        record = new TSRecord((long)count, "root.vehicle.d" + d);
                        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(count)));
                        this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
                    }
                }
            }
            this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d2.s0"), 50L, 150L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d2.s0"), 150L, 450L, 0L);
        for (i = 0; i < this.dataRegion.getSequenceFileList().size(); ++i) {
            TsFileResource resource = (TsFileResource)this.dataRegion.getSequenceFileList().get(i);
            if (i == 1) {
                Assert.assertTrue((boolean)resource.getModFile().exists());
                Assert.assertEquals((long)2L, (long)resource.getModFile().getModifications().size());
                continue;
            }
            if (i == 3) {
                Assert.assertTrue((boolean)resource.getModFile().exists());
                Assert.assertEquals((long)1L, (long)resource.getModFile().getModifications().size());
                continue;
            }
            Assert.assertFalse((boolean)resource.getModFile().exists());
        }
        List dataRegions = StorageEngine.getInstance().getAllDataRegions();
        ArrayList<DataRegion> regionsToBeDeleted = new ArrayList<DataRegion>();
        for (DataRegion region : dataRegions) {
            if (!region.getDatabaseName().equals(this.storageGroup)) continue;
            regionsToBeDeleted.add(region);
        }
        for (DataRegion region : regionsToBeDeleted) {
            StorageEngine.getInstance().deleteDataRegion(new DataRegionId(Integer.parseInt(region.getDataRegionId())));
        }
        Thread.sleep(500L);
        for (TsFileResource resource : this.dataRegion.getSequenceFileList()) {
            Assert.assertFalse((boolean)resource.getTsFile().exists());
        }
    }

    @Test
    public void testDeleteDataNotInFlushingMemtable() throws IllegalPathException, WriteProcessException, IOException {
        for (int j = 0; j < 100; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
        tsFileProcessor.getFlushingMemTable().addLast(tsFileProcessor.getWorkMemTable());
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d2.s0"), 50L, 70L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
    }

    @Test
    public void testDeleteDataInSeqFlushingMemtable() throws IllegalPathException, WriteProcessException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
        tsFileProcessor.getFlushingMemTable().addLast(tsFileProcessor.getWorkMemTable());
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 99L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 100L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 150L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 100L, 190L, 0L);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertTrue((boolean)tsFileResource.getModFile().exists());
        Assert.assertEquals((long)3L, (long)tsFileResource.getModFile().getModifications().size());
    }

    @Test
    public void testDeleteDataInUnSeqFlushingMemtable() throws IllegalPathException, WriteProcessException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 99L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 100L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 150L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 100L, 190L, 0L);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        for (int j = 50; j < 100; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 200L, 299L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 80L, 85L, 0L);
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(false).get(0);
        TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
        tsFileProcessor.getFlushingMemTable().addLast(tsFileProcessor.getWorkMemTable());
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 0L, 49L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 100L, 200L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 25L, 50L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 80L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 99L, 150L, 0L);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertTrue((boolean)tsFileResource.getModFile().exists());
        Assert.assertEquals((long)3L, (long)tsFileResource.getModFile().getModifications().size());
    }

    @Test
    public void testDeleteDataInSeqWorkingMemtable() throws IllegalPathException, WriteProcessException, IOException {
        TSRecord record;
        int j;
        for (j = 100; j < 200; ++j) {
            record = new TSRecord((long)j, "root.vehicle.d0");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        for (j = 100; j < 200; ++j) {
            record = new TSRecord((long)j, "root.vehicle.d199");
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 50L, 99L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d200.s0"), 50L, 70L, 0L);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d199.*"), 50L, 500L, 0L);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        Assert.assertFalse((boolean)tsFileResource.getDevices().contains(new PlainDeviceID("root.vehicle.d199")));
    }

    @Test
    public void testFlushingEmptyMemtable() throws IllegalPathException, WriteProcessException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        this.dataRegion.deleteByDevice(new PartialPath("root.vehicle.d0.s0"), 100L, 200L, 0L);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        Assert.assertFalse((boolean)tsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        Assert.assertFalse((boolean)this.dataRegion.getTsFileManager().contains(tsFileResource, true));
        Assert.assertFalse((boolean)this.dataRegion.getWorkSequenceTsFileProcessors().contains(tsFileResource.getProcessor()));
    }

    @Test
    public void testDeleteDataDirectlySeqWriteModsOrDeleteFiles() throws IllegalPathException, WriteProcessException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResource = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 50L, 100L, 0L);
        Assert.assertTrue((boolean)tsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 100L, 120L, 0L);
        Assert.assertTrue((boolean)tsFileResource.getTsFile().exists());
        Assert.assertTrue((boolean)tsFileResource.getModFile().exists());
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 100L, 199L, 0L);
        Assert.assertFalse((boolean)tsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)tsFileResource.getModFile().exists());
    }

    @Test
    public void testDeleteDataDirectlyUnseqWriteModsOrDeleteFiles() throws IllegalPathException, WriteProcessException, IOException {
        for (int j = 100; j < 200; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        TsFileResource tsFileResourceSeq = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(true).get(0);
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        for (int j = 30; j < 100; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.dataRegion.insert(DataRegionTest.buildInsertRowNodeByTSRecord(record));
        }
        for (TsFileProcessor processor : this.dataRegion.getWorkSequenceTsFileProcessors()) {
            processor.syncFlush();
        }
        TsFileResource tsFileResourceUnSeq = (TsFileResource)this.dataRegion.getTsFileManager().getTsFileList(false).get(0);
        Assert.assertTrue((boolean)tsFileResourceSeq.getTsFile().exists());
        Assert.assertTrue((boolean)tsFileResourceUnSeq.getTsFile().exists());
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 40L, 60L, 0L);
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 140L, 160L, 0L);
        Assert.assertTrue((boolean)tsFileResourceSeq.getTsFile().exists());
        Assert.assertTrue((boolean)tsFileResourceUnSeq.getTsFile().exists());
        Assert.assertTrue((boolean)tsFileResourceSeq.getModFile().exists());
        Assert.assertFalse((boolean)tsFileResourceUnSeq.getModFile().exists());
        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 40L, 80L, 0L);
        Assert.assertTrue((boolean)tsFileResourceUnSeq.getTsFile().exists());
        Assert.assertTrue((boolean)tsFileResourceUnSeq.getModFile().exists());
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 30L, 100L, 0L);
        this.dataRegion.deleteDataDirectly(new PartialPath("root.vehicle.d0.**"), 100L, 199L, 0L);
        Assert.assertFalse((boolean)tsFileResourceSeq.getTsFile().exists());
        Assert.assertFalse((boolean)tsFileResourceUnSeq.getTsFile().exists());
        Assert.assertFalse((boolean)tsFileResourceSeq.getModFile().exists());
        Assert.assertFalse((boolean)tsFileResourceUnSeq.getModFile().exists());
    }

    public static class DummyDataRegion
    extends DataRegion {
        public DummyDataRegion(String systemInfoDir, String storageGroupName) throws DataRegionException {
            super(systemInfoDir, "0", (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), storageGroupName);
        }
    }
}

