/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.DoubleStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChunkCacheTest {
    File tempSGDir;
    static final String TEST_SG = "root.sg1";
    int seqFileNum = 2;
    int unseqFileNum = 2;
    int measurementNum = 2;
    int deviceNum = 2;
    long ptNum = 100L;
    long flushInterval = 20L;
    String[] deviceIds;
    MeasurementSchema[] measurementSchemas;
    List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    ChunkCache chunkCache = ChunkCache.getInstance();

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        this.tempSGDir = new File(TestConstant.OUTPUT_DATA_DIR);
        if (!this.tempSGDir.exists()) {
            Assert.assertTrue((boolean)this.tempSGDir.mkdirs());
        }
        this.prepareSeries();
        this.prepareFiles(this.seqFileNum, this.unseqFileNum);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.removeFiles();
        this.seqResources.clear();
        this.unseqResources.clear();
        this.chunkCache.clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
    }

    @Test
    public void testChunkCache() throws IOException {
        TsFileResource tsFileResource = this.seqResources.get(0);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());){
            List paths = reader.getAllPaths();
            ChunkMetadata firstChunkMetadata = (ChunkMetadata)reader.getChunkMetadataList((Path)paths.get(0)).get(0);
            Chunk chunk1 = this.chunkCache.get(new ChunkCache.ChunkCacheKey(tsFileResource.getTsFilePath(), tsFileResource.getTsFileID(), firstChunkMetadata.getOffsetOfChunkHeader(), true), firstChunkMetadata.getDeleteIntervalList(), firstChunkMetadata.getStatistics(), false);
            ChunkMetadata chunkMetadataKey = new ChunkMetadata("sensor0", TSDataType.DOUBLE, 25L, (Statistics)new DoubleStatistics());
            chunkMetadataKey.setVersion(0L);
            Chunk chunk2 = this.chunkCache.get(new ChunkCache.ChunkCacheKey(tsFileResource.getTsFilePath(), tsFileResource.getTsFileID(), chunkMetadataKey.getOffsetOfChunkHeader(), true), chunkMetadataKey.getDeleteIntervalList(), chunkMetadataKey.getStatistics(), false);
            Assert.assertEquals((Object)chunk1.getHeader(), (Object)chunk2.getHeader());
            Assert.assertEquals((Object)chunk1.getData(), (Object)chunk2.getData());
        }
    }

    void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new String[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = "root.sg1.device" + i;
        }
    }

    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.getTestTsFilePath((String)TEST_SG, (long)0L, (long)0L, (long)i));
            if (!file.getParentFile().exists()) {
                Assert.assertTrue((boolean)file.getParentFile().mkdirs());
            }
            tsFileResource = new TsFileResource(file);
            tsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            tsFileResource.updatePlanIndexes((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.getTestTsFilePath((String)TEST_SG, (long)0L, (long)0L, (long)(i + seqFileNum)));
            if (!file.getParentFile().exists()) {
                Assert.assertTrue((boolean)file.getParentFile().mkdirs());
            }
            tsFileResource = new TsFileResource(file);
            tsFileResource.setStatusForTest(TsFileResourceStatus.NORMAL);
            tsFileResource.updatePlanIndexes((long)(i + seqFileNum));
            this.unseqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L);
        }
    }

    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime((IDeviceID)new PlainDeviceID(this.deviceIds[j]), i);
                tsFileResource.updateEndTime((IDeviceID)new PlainDeviceID(this.deviceIds[j]), i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    private void removeFiles() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        for (TsFileResource tsFileResource : this.seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }
}

