/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.buffer;

import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.CacheHitRatioMonitor;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.rescon.memory.MemTableManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.junit.Assert;
import org.junit.Test;

public class CacheHitRatioMonitorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheHitRatioMonitor() {
        double delta = 1.0E-6;
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
        CacheHitRatioMonitor cacheHitRatioMonitor = CacheHitRatioMonitor.getInstance();
        try {
            cacheHitRatioMonitor.start();
            Assert.assertEquals((Object)ServiceType.CACHE_HIT_RATIO_DISPLAY_SERVICE, (Object)cacheHitRatioMonitor.getID());
            Assert.assertTrue((cacheHitRatioMonitor.getChunkHitRatio() >= 0.0 && cacheHitRatioMonitor.getChunkHitRatio() <= 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getChunkEvictionCount() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)ChunkCache.getInstance().getMaxMemory(), (long)cacheHitRatioMonitor.getChunkCacheMaxMemory());
            Assert.assertTrue((cacheHitRatioMonitor.getChunkCacheAverageLoadPenalty() >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getChunkCacheAverageSize() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getTimeSeriesMetadataHitRatio() >= 0.0 && cacheHitRatioMonitor.getTimeSeriesMetadataHitRatio() <= 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getTimeSeriesMetadataCacheEvictionCount() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)TimeSeriesMetadataCache.getInstance().getMaxMemory(), (long)cacheHitRatioMonitor.getTimeSeriesMetadataCacheMaxMemory());
            Assert.assertTrue((cacheHitRatioMonitor.getTimeSeriesCacheAverageLoadPenalty() >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getTimeSeriesMetaDataCacheAverageSize() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getBloomFilterHitRatio() >= 0.0 && cacheHitRatioMonitor.getBloomFilterHitRatio() <= 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getBloomFilterCacheEvictionCount() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)BloomFilterCache.getInstance().getMaxMemory(), (long)cacheHitRatioMonitor.getBloomFilterCacheMaxMemory());
            Assert.assertTrue((cacheHitRatioMonitor.getBloomFilterCacheAverageLoadPenalty() >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cacheHitRatioMonitor.getBloomFilterCacheAverageSize() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)SystemInfo.getInstance().getTotalMemTableSize(), (long)cacheHitRatioMonitor.getTotalMemTableSize());
            Assert.assertEquals((double)SystemInfo.getInstance().getFlushThershold(), (double)cacheHitRatioMonitor.getFlushThershold(), (double)1.0E-6);
            Assert.assertEquals((double)SystemInfo.getInstance().getRejectThershold(), (double)cacheHitRatioMonitor.getRejectThershold(), (double)1.0E-6);
            Assert.assertEquals((long)FlushManager.getInstance().getNumberOfWorkingTasks(), (long)cacheHitRatioMonitor.flushingMemTableNum());
            Assert.assertEquals((long)MemTableManager.getInstance().getCurrentMemtableNumber(), (long)cacheHitRatioMonitor.totalMemTableNum());
        }
        catch (StartupException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            cacheHitRatioMonitor.stop();
        }
    }
}

