/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"com.sun.org.apache.xerces.*", "javax.xml.*", "org.xml.*", "javax.management.*"})
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DataRegion.class})
public class StorageEngineTest {
    private StorageEngine storageEngine;

    @Before
    public void setUp() {
        this.storageEngine = StorageEngine.getInstance();
    }

    @After
    public void after() {
        this.storageEngine = null;
    }

    @Test
    public void testGetAllDataRegionIds() throws Exception {
        DataRegionId id1 = new DataRegionId(1);
        DataRegion rg1 = (DataRegion)PowerMockito.mock(DataRegion.class);
        DataRegion rg2 = (DataRegion)PowerMockito.mock(DataRegion.class);
        DataRegionId id2 = new DataRegionId(2);
        this.storageEngine.setDataRegion(id1, rg1);
        this.storageEngine.setDataRegion(id2, rg2);
        ArrayList actual = Lists.newArrayList((Object[])new DataRegionId[]{id1, id2});
        List expect = this.storageEngine.getAllDataRegionIds();
        Assert.assertEquals((long)expect.size(), (long)actual.size());
        Assert.assertTrue((boolean)actual.containsAll(expect));
        rg1.syncDeleteDataFiles();
        rg2.syncDeleteDataFiles();
    }

    @Test
    public void testGetTimePartitionId() {
        long timePartitionInterval = TimePartitionUtils.getTimePartitionInterval();
        Assert.assertEquals((long)-2L, (long)TimePartitionUtils.getTimePartitionId((long)(-timePartitionInterval - 1L)));
        Assert.assertEquals((long)-1L, (long)TimePartitionUtils.getTimePartitionId((long)(-timePartitionInterval)));
        Assert.assertEquals((long)-1L, (long)TimePartitionUtils.getTimePartitionId((long)-1L));
        Assert.assertEquals((long)0L, (long)TimePartitionUtils.getTimePartitionId((long)0L));
        Assert.assertEquals((long)0L, (long)TimePartitionUtils.getTimePartitionId((long)1L));
        Assert.assertEquals((long)0L, (long)TimePartitionUtils.getTimePartitionId((long)(timePartitionInterval / 2L)));
        Assert.assertEquals((long)1L, (long)TimePartitionUtils.getTimePartitionId((long)(timePartitionInterval * 2L - 1L)));
        Assert.assertEquals((long)2L, (long)TimePartitionUtils.getTimePartitionId((long)(timePartitionInterval * 2L + 1L)));
    }
}

