/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableListTest;
import org.apache.iotdb.db.queryengine.transformation.datastructure.row.SerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializableRowRecordListTest
extends SerializableListTest {
    private static final TSDataType[] DATA_TYPES = new TSDataType[]{TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.BOOLEAN, TSDataType.TEXT};
    private List<RowRecord> originalList;
    private SerializableRowRecordList testList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.originalList = new ArrayList<RowRecord>();
        this.testList = SerializableRowRecordList.newSerializableRowRecordList((String)QUERY_ID, (TSDataType[])DATA_TYPES, (int)8);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void serializeAndDeserializeTest() {
        int i;
        for (i = 0; i < 10000; ++i) {
            this.generateData(i);
        }
        this.serializeAndDeserializeOnce();
        this.serializeAndDeserializeOnce();
        this.originalList.clear();
        this.testList.release();
        this.testList.init();
        for (i = 0; i < 10000; ++i) {
            this.generateData(i);
        }
        this.serializeAndDeserializeOnce();
        this.serializeAndDeserializeOnce();
    }

    protected void generateData(int index) {
        RowRecord rowRecord = new RowRecord((long)index);
        block8: for (TSDataType dataType : DATA_TYPES) {
            switch (dataType) {
                case INT32: {
                    rowRecord.addField((Object)index, dataType);
                    continue block8;
                }
                case INT64: {
                    rowRecord.addField((Object)index, dataType);
                    continue block8;
                }
                case FLOAT: {
                    rowRecord.addField((Object)Float.valueOf(index), dataType);
                    continue block8;
                }
                case DOUBLE: {
                    rowRecord.addField((Object)index, dataType);
                    continue block8;
                }
                case BOOLEAN: {
                    rowRecord.addField((Object)(index % 2 == 0 ? 1 : 0), dataType);
                    continue block8;
                }
                case TEXT: {
                    rowRecord.addField((Object)BytesUtils.valueOf((String)String.valueOf(index)), dataType);
                }
            }
        }
        this.originalList.add(rowRecord);
        this.testList.put(this.convertRowRecordToRowInObjects(rowRecord));
    }

    protected Object[] convertRowRecordToRowInObjects(RowRecord rowRecord) {
        Object[] rowInObjects = new Object[rowRecord.getFields().size() + 1];
        rowInObjects[rowRecord.getFields().size()] = rowRecord.getTimestamp();
        block8: for (int i = 0; i < rowRecord.getFields().size(); ++i) {
            switch (((Field)rowRecord.getFields().get(i)).getDataType()) {
                case INT32: {
                    rowInObjects[i] = ((Field)rowRecord.getFields().get(i)).getIntV();
                    continue block8;
                }
                case INT64: {
                    rowInObjects[i] = ((Field)rowRecord.getFields().get(i)).getLongV();
                    continue block8;
                }
                case FLOAT: {
                    rowInObjects[i] = Float.valueOf(((Field)rowRecord.getFields().get(i)).getFloatV());
                    continue block8;
                }
                case DOUBLE: {
                    rowInObjects[i] = ((Field)rowRecord.getFields().get(i)).getDoubleV();
                    continue block8;
                }
                case BOOLEAN: {
                    rowInObjects[i] = ((Field)rowRecord.getFields().get(i)).getBoolV();
                    continue block8;
                }
                case TEXT: {
                    rowInObjects[i] = ((Field)rowRecord.getFields().get(i)).getBinaryV();
                }
            }
        }
        return rowInObjects;
    }

    protected void serializeAndDeserializeOnce() {
        try {
            this.testList.serialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            this.testList.deserialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)10000L, (long)this.testList.size());
        for (int i = 0; i < this.testList.size(); ++i) {
            Assert.assertEquals((long)this.originalList.get(i).getTimestamp(), (long)this.testList.getTime(i));
            List originalFields = this.originalList.get(i).getFields();
            Object[] testFields = this.testList.getRowRecord(i);
            block13: for (int j = 0; j < DATA_TYPES.length; ++j) {
                switch (DATA_TYPES[j]) {
                    case INT32: {
                        Assert.assertEquals((long)((Field)originalFields.get(j)).getIntV(), (long)((Integer)testFields[j]).intValue());
                        continue block13;
                    }
                    case INT64: {
                        Assert.assertEquals((long)((Field)originalFields.get(j)).getLongV(), (long)((Long)testFields[j]));
                        continue block13;
                    }
                    case FLOAT: {
                        Assert.assertEquals((float)((Field)originalFields.get(j)).getFloatV(), (float)((Float)testFields[j]).floatValue(), (float)0.0f);
                        continue block13;
                    }
                    case DOUBLE: {
                        Assert.assertEquals((double)((Field)originalFields.get(j)).getDoubleV(), (double)((Double)testFields[j]), (double)0.0);
                        continue block13;
                    }
                    case BOOLEAN: {
                        Assert.assertEquals((Object)((Field)originalFields.get(j)).getBoolV(), (Object)testFields[j]);
                        continue block13;
                    }
                    case TEXT: {
                        Assert.assertEquals((Object)((Field)originalFields.get(j)).getBinaryV(), (Object)testFields[j]);
                    }
                }
            }
        }
    }
}

