/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableTVListTest;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableBooleanTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SerializableBooleanTVListTest
extends SerializableTVListTest {
    private List<Boolean> originalList;
    private SerializableBooleanTVList testList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.originalList = new ArrayList<Boolean>();
        this.testList = (SerializableBooleanTVList)SerializableTVList.newSerializableTVList((TSDataType)TSDataType.BOOLEAN, (String)QUERY_ID);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Override
    protected void generateData(int index) {
        boolean value = index % 2 == 0;
        this.originalList.add(value);
        this.testList.putBoolean((long)index, value);
    }

    @Override
    protected void serializeAndDeserializeOnce() {
        try {
            this.testList.serialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            this.testList.deserialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        int count = 0;
        while (this.testList.hasCurrent()) {
            Assert.assertEquals((long)count, (long)this.testList.currentTime());
            Assert.assertEquals((Object)this.originalList.get(count), (Object)this.testList.getBoolean());
            this.testList.next();
            ++count;
        }
        Assert.assertEquals((long)10000L, (long)count);
    }
}

