/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.IdentityColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.ArithmeticNegationColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.InColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.IsNullColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.LogicNotColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.RegularColumnTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnaryColumnTransformerTest {
    private static final Type returnType = TypeFactory.getType((TSDataType)TSDataType.INT32);
    private static final int POSITION_COUNT = 4;
    private static final int[] input = new int[]{1, 2, 3, 4};
    private static IdentityColumnTransformer operand;

    @Before
    public void setUp() {
        TsBlockBuilder builder = new TsBlockBuilder(4, Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder columnBuilder = builder.getColumnBuilder(0);
        for (int i = 0; i < 4; ++i) {
            timeColumnBuilder.writeLong((long)i);
            columnBuilder.writeInt(input[i]);
            builder.declarePosition();
        }
        TsBlock tsBlock = builder.build();
        operand = new IdentityColumnTransformer(returnType, 0);
        operand.addReferenceCount();
        operand.initFromTsBlock(tsBlock);
    }

    @Test
    public void testNegation() {
        ArithmeticNegationColumnTransformer transformer = new ArithmeticNegationColumnTransformer(returnType, (ColumnTransformer)operand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)(-input[i]), (long)res.getInt(i));
        }
    }

    @Test
    public void testIn() {
        HashSet<String> values = new HashSet<String>();
        values.add("2");
        InColumnTransformer transformer = new InColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.BOOLEAN), (ColumnTransformer)operand, false, values);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)values.contains(String.valueOf(input[i])), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testIsNull() {
        IsNullColumnTransformer transformer = new IsNullColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.BOOLEAN), (ColumnTransformer)operand, false);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertFalse((boolean)res.getBoolean(i));
        }
    }

    @Test
    public void testLogicNot() {
        try {
            new LogicNotColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.BOOLEAN), (ColumnTransformer)operand);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRegular() {
        try {
            new RegularColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.BOOLEAN), (ColumnTransformer)operand, Pattern.compile("%d"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

