/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.LogicAndColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.LogicOrColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.IdentityColumnTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogicBinaryColumnTransformerTest {
    private static final Type returnType = TypeFactory.getType((TSDataType)TSDataType.BOOLEAN);
    private static final int POSITION_COUNT = 4;
    private static final boolean[] leftInput = new boolean[]{true, false, true, false};
    private static final boolean[] rightInput = new boolean[]{true, false, true, false};
    private static IdentityColumnTransformer leftOperand;
    private static IdentityColumnTransformer rightOperand;

    @Before
    public void setUp() {
        TsBlockBuilder builder = new TsBlockBuilder(4, Arrays.asList(TSDataType.BOOLEAN, TSDataType.BOOLEAN));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder leftColumnBuilder = builder.getColumnBuilder(0);
        ColumnBuilder rightColumnBuilder = builder.getColumnBuilder(1);
        for (int i = 0; i < 4; ++i) {
            timeColumnBuilder.writeLong((long)i);
            leftColumnBuilder.writeBoolean(leftInput[i]);
            rightColumnBuilder.writeBoolean(rightInput[i]);
            builder.declarePosition();
        }
        TsBlock tsBlock = builder.build();
        leftOperand = new IdentityColumnTransformer(returnType, 0);
        rightOperand = new IdentityColumnTransformer(returnType, 1);
        leftOperand.addReferenceCount();
        rightOperand.addReferenceCount();
        leftOperand.initFromTsBlock(tsBlock);
        rightOperand.initFromTsBlock(tsBlock);
    }

    @Test
    public void testLogicOr() {
        LogicOrColumnTransformer transformer = new LogicOrColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] || rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testLogicAnd() {
        LogicAndColumnTransformer transformer = new LogicAndColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] && rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testInputType() {
        try {
            leftOperand = new IdentityColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.INT32), 0);
            rightOperand = new IdentityColumnTransformer(returnType, 1);
            LogicAndColumnTransformer transformer = new LogicAndColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
            transformer.evaluate();
            Assert.fail((String)"Left and Right input must both be of boolean type.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

