/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.ArithmeticAdditionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.ArithmeticDivisionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.ArithmeticModuloColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.ArithmeticMultiplicationColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.ArithmeticSubtractionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.CompareEqualToColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.CompareGreaterEqualColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.CompareGreaterThanColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.CompareLessEqualColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.CompareNonEqualColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.IdentityColumnTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArithmeticAndCompareBinaryColumnTransformerTest {
    private static final Type returnType = TypeFactory.getType((TSDataType)TSDataType.INT32);
    private static final Type booleanType = TypeFactory.getType((TSDataType)TSDataType.BOOLEAN);
    private static final int POSITION_COUNT = 4;
    private static final int[] leftInput = new int[]{1, 2, 3, 4};
    private static final int[] rightInput = new int[]{1, 2, 3, 4};
    private static IdentityColumnTransformer leftOperand;
    private static IdentityColumnTransformer rightOperand;

    @Before
    public void setUp() {
        TsBlockBuilder builder = new TsBlockBuilder(4, Arrays.asList(TSDataType.INT32, TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder leftColumnBuilder = builder.getColumnBuilder(0);
        ColumnBuilder rightColumnBuilder = builder.getColumnBuilder(1);
        for (int i = 0; i < 4; ++i) {
            timeColumnBuilder.writeLong((long)i);
            leftColumnBuilder.writeInt(leftInput[i]);
            rightColumnBuilder.writeInt(rightInput[i]);
            builder.declarePosition();
        }
        TsBlock tsBlock = builder.build();
        leftOperand = new IdentityColumnTransformer(returnType, 0);
        rightOperand = new IdentityColumnTransformer(returnType, 1);
        leftOperand.addReferenceCount();
        rightOperand.addReferenceCount();
        leftOperand.initFromTsBlock(tsBlock);
        rightOperand.initFromTsBlock(tsBlock);
    }

    @Test
    public void testAddition() {
        ArithmeticAdditionColumnTransformer transformer = new ArithmeticAdditionColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)(leftInput[i] + rightInput[i]), (long)res.getInt(i));
        }
    }

    @Test
    public void testSubtraction() {
        ArithmeticSubtractionColumnTransformer transformer = new ArithmeticSubtractionColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)(leftInput[i] - rightInput[i]), (long)res.getInt(i));
        }
    }

    @Test
    public void testMultiplication() {
        ArithmeticMultiplicationColumnTransformer transformer = new ArithmeticMultiplicationColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)(leftInput[i] * rightInput[i]), (long)res.getInt(i));
        }
    }

    @Test
    public void testDivision() {
        ArithmeticDivisionColumnTransformer transformer = new ArithmeticDivisionColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)(leftInput[i] / rightInput[i]), (long)res.getInt(i));
        }
    }

    @Test
    public void testModulo() {
        ArithmeticModuloColumnTransformer transformer = new ArithmeticModuloColumnTransformer(returnType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((long)(leftInput[i] % rightInput[i]), (long)res.getInt(i));
        }
    }

    @Test
    public void testEqualTo() {
        CompareEqualToColumnTransformer transformer = new CompareEqualToColumnTransformer(booleanType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] == rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testGreaterEqual() {
        CompareGreaterEqualColumnTransformer transformer = new CompareGreaterEqualColumnTransformer(booleanType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] >= rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testGreaterThan() {
        CompareGreaterThanColumnTransformer transformer = new CompareGreaterThanColumnTransformer(booleanType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] > rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testLessEqual() {
        CompareLessEqualColumnTransformer transformer = new CompareLessEqualColumnTransformer(booleanType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] <= rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testLessThan() {
        CompareGreaterThanColumnTransformer transformer = new CompareGreaterThanColumnTransformer(booleanType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] < rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }

    @Test
    public void testNonEqual() {
        CompareNonEqualColumnTransformer transformer = new CompareNonEqualColumnTransformer(booleanType, (ColumnTransformer)leftOperand, (ColumnTransformer)rightOperand);
        transformer.addReferenceCount();
        transformer.evaluate();
        Column res = transformer.getColumn();
        Assert.assertEquals((long)4L, (long)res.getPositionCount());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)(leftInput[i] != rightInput[i] ? 1 : 0), (Object)res.getBoolean(i));
        }
    }
}

