/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.builder;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TransformOperator;
import org.apache.iotdb.db.queryengine.execution.operator.sink.IdentitySinkOperator;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi.UDFQueryRowWindowTransformer;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class EvaluationDAGBuilderTest {
    @Test
    public void testBuildWithNonMappable() {
        String sql = "select s1 + 1, s1 * 2, s1 - 2, s1 / 3, sin(s1), m4(s1,'windowSize'='10') from root.sg.d1;";
        try {
            IoTDBDescriptor.getInstance().getConfig().setDataNodeId(1);
            Operator operator = this.generateOperatorTree(sql);
            Assert.assertNotNull((Object)operator);
            TransformOperator transformOperator = (TransformOperator)((IdentitySinkOperator)operator).getChildren().get(0);
            LayerPointReader[] transformers = transformOperator.getTransformers();
            Assert.assertEquals((long)6L, (long)transformers.length);
            Assert.assertTrue((boolean)(transformers[0] instanceof UDFQueryRowWindowTransformer));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private Operator generateOperatorTree(String sql) {
        try {
            UDFClassLoaderManager.setupAndGetInstance();
            Statement statement = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
            QueryId queryId = new QueryId("test");
            MPPQueryContext context = new MPPQueryContext(sql, queryId, null, new TEndPoint("127.0.0.1", 6667), new TEndPoint("127.0.0.1", 6667));
            Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            Analysis analysis = analyzer.analyze(statement);
            LogicalPlanner logicalPlanner = new LogicalPlanner(context);
            LogicalQueryPlan logicalPlan = logicalPlanner.plan(analysis);
            DistributionPlanner distributionPlanner = new DistributionPlanner(analysis, logicalPlan);
            FragmentInstance instance = (FragmentInstance)distributionPlanner.planFragments().getInstances().get(0);
            LocalExecutionPlanner localExecutionPlanner = LocalExecutionPlanner.getInstance();
            List driverFactories = localExecutionPlanner.plan(instance.getFragment().getPlanNodeTree(), instance.getFragment().getTypeProvider(), this.mockFIContext(queryId), new DataNodeQueryContext(1));
            return ((PipelineDriverFactory)driverFactories.get(0)).getOperation();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
            return null;
        }
    }

    private FragmentInstanceContext mockFIContext(QueryId queryId) {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        FragmentInstanceContext instanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        IDataRegionForQuery dataRegionForQuery = (IDataRegionForQuery)Mockito.mock(DataRegion.class);
        Mockito.when((Object)dataRegionForQuery.getDataTTL()).thenReturn((Object)1000L);
        instanceContext.setDataRegion(dataRegionForQuery);
        return instanceContext;
    }
}

