/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStatementTest {
    private static final Logger logger = LoggerFactory.getLogger(QueryStatementTest.class);
    private static final String ALIGN_BY_DEVICE_ONE_LEVEL_ERROR = "ALIGN BY DEVICE: the suffix paths can only be measurement or one-level wildcard";

    @Test
    public void semanticCheckTest() {
        List<Pair> errorSqlWithMessages = Arrays.asList(new Pair((Object)"SELECT s1 FROM root.sg.d1 GROUP BY ([2017-11-01T00:00:00, 2017-11-07T23:00:00),1d)", (Object)"Common queries and aggregated queries are not allowed to appear at the same time"), new Pair((Object)"SELECT count(s1),s2 FROM root.sg.d1", (Object)"Raw data and aggregation hybrid query is not supported."), new Pair((Object)"SELECT s1 FROM root.sg.d1 WHERE count(s1) > 0", (Object)"aggregate functions are not supported in WHERE clause"), new Pair((Object)"SELECT s1 FROM root.sg.d1 HAVING(s1 > 0)", (Object)"Expression of HAVING clause must to be an Aggregation"), new Pair((Object)"SELECT s1 FROM root.sg.d1 HAVING(count(s1) > 0)", (Object)"Expression of HAVING clause can not be used in NonAggregationQuery"), new Pair((Object)"SELECT count(d1.s1) FROM root.sg.d1 GROUP BY level=1 HAVING (count(s1) > 0)", (Object)"When Having used with GroupByLevel: the suffix paths can only be measurement or one-level wildcard"), new Pair((Object)"SELECT count(s1) FROM root.sg.d1 GROUP BY level=1 HAVING (count(sg.d1.s1) > 0)", (Object)"When Having used with GroupByLevel: the suffix paths can only be measurement or one-level wildcard"), new Pair((Object)"SELECT d1.s1 FROM root.sg.d1 align by device", (Object)ALIGN_BY_DEVICE_ONE_LEVEL_ERROR), new Pair((Object)"SELECT count(s1) FROM root.sg.d1 group by variation(sg.s1) align by device", (Object)ALIGN_BY_DEVICE_ONE_LEVEL_ERROR), new Pair((Object)"SELECT s1 FROM root.sg.d1 order by root.sg.d1.s1 align by device", (Object)ALIGN_BY_DEVICE_ONE_LEVEL_ERROR), new Pair((Object)"SELECT s1 FROM root.sg.d1 where root.sg.d1.s1 > 0 align by device", (Object)ALIGN_BY_DEVICE_ONE_LEVEL_ERROR), new Pair((Object)"SELECT count(s1) FROM root.sg.d1 having(count(root.sg.d1.s1) > 0) align by device", (Object)ALIGN_BY_DEVICE_ONE_LEVEL_ERROR), new Pair((Object)"SELECT s1 FROM root.sg.d1 order by timeseries align by device", (Object)"Sorting by timeseries is only supported in last queries."), new Pair((Object)"SELECT last s1 FROM root.sg.d1 align by device", (Object)"Last query doesn't support align by device."), new Pair((Object)"SELECT last s1+s2 FROM root.sg.d1", (Object)"Last queries can only be applied on raw time series."), new Pair((Object)"SELECT last s1 FROM root.sg.d1 order by device", (Object)"Sorting by device is only supported in ALIGN BY DEVICE queries."), new Pair((Object)"SELECT last s1 FROM root.sg.d1 SLIMIT 1 SOFFSET 2", (Object)"SLIMIT and SOFFSET can not be used in LastQuery."), new Pair((Object)"SELECT s1 INTO root.sg.d2(t1) FROM root.sg.d1 SLIMIT 5", (Object)"select into: slimit clauses are not supported."), new Pair((Object)"SELECT s1 INTO root.sg.d2(t1) FROM root.sg.d1 SOFFSET 6", (Object)"select into: soffset clauses are not supported."), new Pair((Object)"SELECT last s1 INTO root.sg.d2(t1) FROM root.sg.d1", (Object)"select into: last clauses are not supported."), new Pair((Object)"SELECT count(s1) INTO root.sg.d2(t1) FROM root.sg.d1 GROUP BY TAGS(a)", (Object)"select into: GROUP BY TAGS clause are not supported."), new Pair((Object)"SELECT s1 FROM root.sg.d1 order by timeseries", (Object)"Sorting by timeseries is only supported in last queries."), new Pair((Object)"SELECT s1 FROM root.sg.d1 order by device", (Object)"Sorting by device is only supported in ALIGN BY DEVICE queries."));
        for (Pair pair : errorSqlWithMessages) {
            String errorSql = (String)pair.left;
            String errorMsg = (String)pair.right;
            try {
                this.checkErrorQuerySql(errorSql);
            }
            catch (SemanticException e) {
                Assert.assertEquals((Object)errorMsg, (Object)e.getMessage());
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)String.format("Meets exception %s in test sql: `%s`", errorMsg, errorSql));
            }
            Assert.fail((String)String.format("Sql: `%s` must throw exception: %s", errorSql, errorMsg));
        }
    }

    @Test
    public void getPathsTest() {
        String sql = "SELECT count(s1 + s3) FROM root.sg.d1 WHERE s2 > 0 and time < 1000";
        QueryStatement statement = (QueryStatement)StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        List fullPaths = statement.getPaths();
        Assert.assertEquals((long)2L, (long)fullPaths.size());
        Assert.assertEquals((Object)"root.sg.d1.s1", (Object)((PartialPath)fullPaths.get(0)).getFullPath());
        Assert.assertEquals((Object)"root.sg.d1.s3", (Object)((PartialPath)fullPaths.get(1)).getFullPath());
    }

    private void checkErrorQuerySql(String sql) {
        QueryStatement statement = (QueryStatement)StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
        statement.semanticCheck();
    }
}

