/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.statement.sys.pipe;

import java.util.HashMap;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.CreatePipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.DropPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.ShowPipesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.StartPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe.StopPipeStatement;
import org.junit.Assert;
import org.junit.Test;

public class PipeStatementTest {
    @Test
    public void testCreatePipeStatement() {
        HashMap extractorAttributes = new HashMap();
        HashMap processorAttributes = new HashMap();
        HashMap connectorAttributes = new HashMap();
        CreatePipeStatement statement = new CreatePipeStatement(StatementType.CREATE_PIPE);
        statement.setPipeName("test");
        statement.setExtractorAttributes(extractorAttributes);
        statement.setProcessorAttributes(processorAttributes);
        statement.setConnectorAttributes(connectorAttributes);
        Assert.assertEquals((Object)"test", (Object)statement.getPipeName());
        Assert.assertEquals(extractorAttributes, (Object)statement.getExtractorAttributes());
        Assert.assertEquals(processorAttributes, (Object)statement.getProcessorAttributes());
        Assert.assertEquals(connectorAttributes, (Object)statement.getConnectorAttributes());
        Assert.assertEquals((Object)QueryType.WRITE, (Object)statement.getQueryType());
    }

    @Test
    public void testDropPipeStatement() {
        DropPipeStatement statement = new DropPipeStatement(StatementType.DROP_PIPE);
        statement.setPipeName("test");
        Assert.assertEquals((Object)"test", (Object)statement.getPipeName());
        Assert.assertEquals((Object)QueryType.WRITE, (Object)statement.getQueryType());
    }

    @Test
    public void testShowPipesStatement() {
        ShowPipesStatement statement = new ShowPipesStatement();
        statement.setPipeName("test");
        statement.setWhereClause(true);
        Assert.assertEquals((Object)"test", (Object)statement.getPipeName());
        Assert.assertTrue((boolean)statement.getWhereClause());
        Assert.assertEquals((Object)QueryType.READ, (Object)statement.getQueryType());
    }

    @Test
    public void testStartPipeStatement() {
        StartPipeStatement statement = new StartPipeStatement(StatementType.START_PIPE);
        statement.setPipeName("test");
        Assert.assertEquals((Object)"test", (Object)statement.getPipeName());
        Assert.assertEquals((Object)QueryType.WRITE, (Object)statement.getQueryType());
    }

    @Test
    public void testStopPipeStatement() {
        StopPipeStatement statement = new StopPipeStatement(StatementType.STOP_PIPE);
        statement.setPipeName("test");
        Assert.assertEquals((Object)"test", (Object)statement.getPipeName());
        Assert.assertEquals((Object)QueryType.WRITE, (Object)statement.getQueryType());
    }
}

