/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.write;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class InsertRowsOfOneDeviceNodeSerdeTest {
    @Test
    public void TestSerializeAndDeserialize() throws IllegalPathException {
        PartialPath device = new PartialPath("root.sg.d");
        InsertRowsOfOneDeviceNode node = new InsertRowsOfOneDeviceNode(new PlanNodeId("plan node 1"));
        node.setDevicePath(device);
        ArrayList<InsertRowNode> insertRowNodeList = new ArrayList<InsertRowNode>();
        ArrayList<Integer> insertRowNodeIndexList = new ArrayList<Integer>();
        insertRowNodeList.add(new InsertRowNode(new PlanNodeId("plan node 1"), device, false, new String[]{"s1", "s2", "s3"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64}, 1000L, new Object[]{1.0, Float.valueOf(2.0f), 300L}, false));
        insertRowNodeList.add(new InsertRowNode(new PlanNodeId("plan node 1"), device, false, new String[]{"s1", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.BOOLEAN}, 2000L, new Object[]{2.0, false}, false));
        insertRowNodeIndexList.add(0);
        insertRowNodeIndexList.add(1);
        node.setInsertRowNodeList(insertRowNodeList);
        node.setInsertRowNodeIndexList(insertRowNodeIndexList);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        node.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_ROWS_OF_ONE_DEVICE.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)node, (Object)InsertRowsOfOneDeviceNode.deserialize((ByteBuffer)byteBuffer));
    }
}

