/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.write;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALByteBufferForTest;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class InsertRowsNodeSerdeTest {
    @Test
    public void TestSerializeAndDeserialize() throws IllegalPathException {
        InsertRowsNode node = new InsertRowsNode(new PlanNodeId("plan node 1"));
        node.addOneInsertRowNode(new InsertRowNode(new PlanNodeId("plan node 1"), new PartialPath("root.sg.d1"), false, new String[]{"s1", "s2", "s3"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64}, 1000L, new Object[]{1.0, Float.valueOf(2.0f), 300L}, false), 0);
        node.addOneInsertRowNode(new InsertRowNode(new PlanNodeId("plan node 1"), new PartialPath("root.sg.d2"), false, new String[]{"s1", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.BOOLEAN}, 2000L, new Object[]{2.0, false}, false), 1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        node.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_ROWS.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)node, (Object)InsertRowsNode.deserialize((ByteBuffer)byteBuffer));
    }

    @Test
    public void testSerializeAndDeserializeForWAL() throws IllegalPathException, IOException {
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId("plan node 1"));
        insertRowsNode.addOneInsertRowNode(new InsertRowNode(new PlanNodeId(""), new PartialPath("root.sg.d1"), false, new String[]{"s1", "s2", "s3"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64}, new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64)}, 1000L, new Object[]{1.0, Float.valueOf(2.0f), 300L}, false), 0);
        insertRowsNode.addOneInsertRowNode(new InsertRowNode(new PlanNodeId(""), new PartialPath("root.sg.d2"), false, new String[]{"s1", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.BOOLEAN}, new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s4", TSDataType.BOOLEAN)}, 2000L, new Object[]{2.0, false}, false), 1);
        int serializedSize = insertRowsNode.serializedSize();
        byte[] bytes = new byte[serializedSize];
        WALByteBufferForTest walBuffer = new WALByteBufferForTest(ByteBuffer.wrap(bytes));
        insertRowsNode.serializeToWAL((IWALByteBufferView)walBuffer);
        Assert.assertFalse((boolean)walBuffer.getBuffer().hasRemaining());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        Assert.assertEquals((long)PlanNodeType.INSERT_ROWS.getNodeType(), (long)dataInputStream.readShort());
        InsertRowsNode tmpNode = InsertRowsNode.deserializeFromWAL((DataInputStream)dataInputStream);
        tmpNode.setPlanNodeId(insertRowsNode.getPlanNodeId());
        Assert.assertEquals((Object)insertRowsNode, (Object)tmpNode);
    }
}

