/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.write;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALByteBufferForTest;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class InsertRowNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        InsertRowNode insertRowNode = this.getInsertRowNode();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        insertRowNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_ROW.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertRowNode, (Object)InsertRowNode.deserialize((ByteBuffer)byteBuffer));
        insertRowNode = this.getInsertRowNodeWithMeasurementSchemas();
        byteBuffer = ByteBuffer.allocate(10000);
        insertRowNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_ROW.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertRowNode, (Object)InsertRowNode.deserialize((ByteBuffer)byteBuffer));
        insertRowNode = this.getInsertRowNodeWithStringValue();
        byteBuffer = ByteBuffer.allocate(10000);
        insertRowNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_ROW.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertRowNode, (Object)InsertRowNode.deserialize((ByteBuffer)byteBuffer));
    }

    @Test
    public void TestSerializeAndDeserializeForWAL() throws IllegalPathException, IOException {
        InsertRowNode insertRowNode = this.getInsertRowNodeWithMeasurementSchemas();
        int serializedSize = insertRowNode.serializedSize();
        byte[] bytes = new byte[serializedSize];
        WALByteBufferForTest walBuffer = new WALByteBufferForTest(ByteBuffer.wrap(bytes));
        insertRowNode.serializeToWAL((IWALByteBufferView)walBuffer);
        Assert.assertFalse((boolean)walBuffer.getBuffer().hasRemaining());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        Assert.assertEquals((long)PlanNodeType.INSERT_ROW.getNodeType(), (long)dataInputStream.readShort());
        InsertRowNode tmpNode = InsertRowNode.deserializeFromWAL((DataInputStream)dataInputStream);
        tmpNode.setPlanNodeId(insertRowNode.getPlanNodeId());
        tmpNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN)});
        Assert.assertEquals((Object)insertRowNode, (Object)tmpNode);
    }

    private InsertRowNode getInsertRowNode() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false};
        return new InsertRowNode(new PlanNodeId("plannode 1"), new PartialPath("root.isp.d1"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, time, columns, false);
    }

    private InsertRowNode getInsertRowNodeWithMeasurementSchemas() throws IllegalPathException {
        long time = 80L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{5.0, Float.valueOf(6.0f), 1000L, 10, true};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("plannode 2"), new PartialPath("root.isp.d2"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN)});
        return insertRowNode;
    }

    private InsertRowNode getInsertRowNodeWithStringValue() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{"1.0", "2.0", "10000", "100", "false"};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("plannode 1"), new PartialPath("root.isp.d1"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, new TSDataType[5], time, columns, false);
        insertRowNode.setNeedInferType(true);
        return insertRowNode;
    }
}

