/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.write;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;

public class InsertMultiTabletsNodeSerdeTest {
    @Test
    public void testInsertMultiTabletPlan() throws MetadataException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0;
            ((float[])columns[1])[r] = 2.0f;
            ((long[])columns[2])[r] = 10000L;
            ((int[])columns[3])[r] = 100;
            ((boolean[])columns[4])[r] = false;
            ((Binary[])columns[5])[r] = new Binary("hh" + r, TSFileConfig.STRING_CHARSET);
        }
        PlanNodeId planNodeId = new PlanNodeId("plan node 1");
        InsertMultiTabletsNode insertMultiTabletsNode = new InsertMultiTabletsNode(planNodeId);
        for (int i = 0; i < 10; ++i) {
            insertMultiTabletsNode.addInsertTabletNode(new InsertTabletNode(planNodeId, new PartialPath("root.multi.d" + i), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, times, null, columns, times.length), Integer.valueOf(i));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        insertMultiTabletsNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_MULTI_TABLET.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertMultiTabletsNode, (Object)InsertMultiTabletsNode.deserialize((ByteBuffer)byteBuffer));
    }
}

