/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.write;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.junit.Assert;
import org.junit.Test;

public class DeleteDataNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        PlanNodeId planNodeId = new PlanNodeId("DeleteDataNode");
        long startTime = 1L;
        long endTime = 10L;
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        pathList.add(new PartialPath("root.sg.d1.s1"));
        pathList.add(new PartialPath("root.sg.d2.*"));
        DeleteDataNode deleteDataNode = new DeleteDataNode(planNodeId, pathList, startTime, endTime);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deleteDataNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertTrue((boolean)(deserializedNode instanceof DeleteDataNode));
        Assert.assertEquals((Object)planNodeId, (Object)deserializedNode.getPlanNodeId());
        deleteDataNode = (DeleteDataNode)deserializedNode;
        Assert.assertEquals((long)startTime, (long)deleteDataNode.getDeleteStartTime());
        Assert.assertEquals((long)endTime, (long)deleteDataNode.getDeleteEndTime());
        List deserializedPathList = deleteDataNode.getPathList();
        Assert.assertEquals((long)pathList.size(), (long)deserializedPathList.size());
        for (int i = 0; i < pathList.size(); ++i) {
            Assert.assertEquals(pathList.get(i), deserializedPathList.get(i));
        }
    }
}

