/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.source;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.junit.Assert;
import org.junit.Test;

public class SeriesAggregationScanNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws QueryProcessException, IllegalPathException {
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        aggregationDescriptorList.add(new AggregationDescriptor(TAggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")))));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(1L, 100L, new TimeDuration(1, 0L), new TimeDuration(1, 0L), true);
        SeriesAggregationScanNode seriesAggregationScanNode = new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.BOOLEAN), aggregationDescriptorList, Ordering.ASC, (Expression)ExpressionFactory.gt((Expression)ExpressionFactory.time(), (Expression)ExpressionFactory.longValue((long)100L)), groupByTimeParameter, null);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        seriesAggregationScanNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)seriesAggregationScanNode);
    }
}

