/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.InnerTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.LeftOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class TimeJoinNodeSerdeTest {
    private static SeriesScanNode seriesScanNode1;
    private static SeriesScanNode seriesScanNode2;

    @Test
    public void testSerializeAndDeserializeFullOuterTimeJoin() throws IllegalPathException {
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(new PlanNodeId("TestFullOuterTimeJoinNode"), Ordering.ASC);
        fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode1);
        fullOuterTimeJoinNode.addChild((PlanNode)seriesScanNode2);
        this.testSerde((PlanNode)fullOuterTimeJoinNode);
    }

    @Test
    public void testSerializeAndDeserializeInnerTimeJoin1() throws IllegalPathException {
        InnerTimeJoinNode innerTimeJoinNode = new InnerTimeJoinNode(new PlanNodeId("TestInnerTimeJoinNode"), Ordering.ASC, null, null);
        innerTimeJoinNode.addChild((PlanNode)seriesScanNode1);
        innerTimeJoinNode.addChild((PlanNode)seriesScanNode2);
        this.testSerde((PlanNode)innerTimeJoinNode);
    }

    @Test
    public void testSerializeAndDeserializeInnerTimeJoin2() throws IllegalPathException {
        InnerTimeJoinNode innerTimeJoinNode = new InnerTimeJoinNode(new PlanNodeId("TestInnerTimeJoinNode"), Ordering.ASC, Arrays.asList(0L, 1L), Arrays.asList("root.sg.d1.s1", "root.sg.d1.s2"));
        innerTimeJoinNode.addChild((PlanNode)seriesScanNode1);
        innerTimeJoinNode.addChild((PlanNode)seriesScanNode2);
        this.testSerde((PlanNode)innerTimeJoinNode);
    }

    @Test
    public void testSerializeAndDeserializeLeftOuterTimeJoin() throws IllegalPathException {
        LeftOuterTimeJoinNode leftOuterTimeJoinNode = new LeftOuterTimeJoinNode(new PlanNodeId("TestLeftOuterTimeJoinNode"), Ordering.ASC);
        leftOuterTimeJoinNode.addChild((PlanNode)seriesScanNode1);
        leftOuterTimeJoinNode.addChild((PlanNode)seriesScanNode2);
        this.testSerde((PlanNode)leftOuterTimeJoinNode);
    }

    private void testSerde(PlanNode node) throws IllegalPathException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        node.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)node);
    }

    static {
        try {
            seriesScanNode1 = new SeriesScanNode(new PlanNodeId("TestSeriesScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.INT32), Ordering.DESC, null, 100L, 100L, null);
            seriesScanNode2 = new SeriesScanNode(new PlanNodeId("TestSeriesScanNode"), new MeasurementPath("root.sg.d1.s2", TSDataType.INT32), Ordering.DESC, null, 100L, 100L, null);
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

