/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class SortNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        SeriesScanNode seriesScanNode = new SeriesScanNode(new PlanNodeId("TestSeriesScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.INT32), Ordering.DESC, null, 100L, 100L, null);
        SortNode sortNode = new SortNode(new PlanNodeId("TestSortNode"), (PlanNode)seriesScanNode, new OrderByParameter((List)ImmutableList.of((Object)new SortItem("TIME", Ordering.ASC))));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        sortNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)sortNode);
    }
}

