/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleDeviceViewNode;
import org.junit.Assert;
import org.junit.Test;

public class SingleDeviceViewNodeSerdeTest {
    private static final List<String> outputColumnNames = Arrays.asList("Time", "Device", "value");

    @Test
    public void testCacheOutputColumnNames() throws IllegalPathException {
        SingleDeviceViewNode singleDeviceViewNode = new SingleDeviceViewNode(new PlanNodeId("TestSingleDeviceViewNode"), outputColumnNames, "TestDevice", Arrays.asList(1, 2));
        ByteBuffer byteBufferWithoutCache = ByteBuffer.allocate(2048);
        singleDeviceViewNode.serialize(byteBufferWithoutCache);
        byteBufferWithoutCache.flip();
        Assert.assertNull((Object)PlanNodeDeserializeHelper.deserialize(byteBufferWithoutCache).getOutputColumnNames());
        singleDeviceViewNode.setCacheOutputColumnNames(true);
        ByteBuffer byteBufferWithCache = ByteBuffer.allocate(2048);
        singleDeviceViewNode.serialize(byteBufferWithCache);
        byteBufferWithCache.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBufferWithCache), (Object)singleDeviceViewNode);
    }
}

