/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class FilterNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        FilterNode filterNode = new FilterNode(new PlanNodeId("TestFilterNode"), (PlanNode)fullOuterTimeJoinNode, new Expression[]{new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))}, (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "100")), false, Ordering.ASC);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        filterNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)filterNode);
    }
}

