/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.junit.Assert;
import org.junit.Test;

public class ExchangeNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        FullOuterTimeJoinNode fullOuterTimeJoinNode = new FullOuterTimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("TestExchangeNode"));
        IdentitySinkNode sinkNode = new IdentitySinkNode(new PlanNodeId("sink"), Collections.singletonList(fullOuterTimeJoinNode), Collections.singletonList(new DownStreamChannelLocation(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds").toThrift(), new PlanNodeId("test").getId())));
        exchangeNode.addChild((PlanNode)sinkNode);
        exchangeNode.setOutputColumnNames(exchangeNode.getChild().getOutputColumnNames());
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6666), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)exchangeNode);
    }
}

