/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join.FullOuterTimeJoinNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.junit.Assert;
import org.junit.Test;

public class DeviceViewNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        FullOuterTimeJoinNode fullOuterTimeJoinNode1 = new FullOuterTimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        FullOuterTimeJoinNode fullOuterTimeJoinNode2 = new FullOuterTimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        DeviceViewNode deviceViewNode = new DeviceViewNode(new PlanNodeId("TestDeviceMergeNode"), new OrderByParameter(Arrays.asList(new SortItem("DEVICE", Ordering.ASC), new SortItem("TIME", Ordering.DESC))), Arrays.asList("s1", "s2"), new HashMap());
        deviceViewNode.addChildDeviceNode("root.sg.d1", (PlanNode)fullOuterTimeJoinNode1);
        deviceViewNode.addChildDeviceNode("root.sg.d2", (PlanNode)fullOuterTimeJoinNode2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deviceViewNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)deviceViewNode);
    }
}

