/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.process;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.TimeDuration;
import org.junit.Assert;
import org.junit.Test;

public class AggregationNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(1L, 100L, new TimeDuration(0, 1L), new TimeDuration(0, 1L), false);
        SeriesAggregationScanNode seriesAggregationScanNode = new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.BOOLEAN), Collections.singletonList(new AggregationDescriptor(TAggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.INTERMEDIATE, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))), Ordering.ASC, (Expression)ExpressionFactory.in((Expression)ExpressionFactory.timeSeries((String)"root.sg.d1.s1"), (LinkedHashSet)Sets.newLinkedHashSet(Arrays.asList("s1", "s2"))), groupByTimeParameter, null);
        AggregationNode aggregationNode = new AggregationNode(new PlanNodeId("TestAggregateNode"), Collections.singletonList(seriesAggregationScanNode), Collections.singletonList(new AggregationDescriptor(TAggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))), groupByTimeParameter, Ordering.ASC);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        aggregationNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)aggregationNode);
    }

    @Test
    public void getDeduplicatedDescriptorsTest1() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        ArrayList<TAggregationType> aggregationTypeList = new ArrayList<TAggregationType>();
        aggregationTypeList.add(TAggregationType.COUNT);
        aggregationTypeList.add(TAggregationType.AVG);
        aggregationTypeList.add(TAggregationType.SUM);
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(TAggregationType.COUNT);
        aggregationTypeList.add(TAggregationType.SUM);
        aggregationTypeList.add(TAggregationType.AVG);
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(TAggregationType.AVG);
        aggregationTypeList.add(TAggregationType.COUNT);
        aggregationTypeList.add(TAggregationType.SUM);
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)3L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.COUNT, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.SUM, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(2)).getAggregationType());
    }

    @Test
    public void getDeduplicatedDescriptorsTest2() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        ArrayList<TAggregationType> aggregationTypeList = new ArrayList<TAggregationType>();
        aggregationTypeList.add(TAggregationType.FIRST_VALUE);
        aggregationTypeList.add(TAggregationType.MIN_TIME);
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(TAggregationType.MIN_TIME);
        aggregationTypeList.add(TAggregationType.FIRST_VALUE);
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.MIN_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
    }

    @Test
    public void getDeduplicatedDescriptorsTest3() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        ArrayList<TAggregationType> aggregationTypeList = new ArrayList<TAggregationType>();
        aggregationTypeList.add(TAggregationType.LAST_VALUE);
        aggregationTypeList.add(TAggregationType.MAX_TIME);
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(TAggregationType.MAX_TIME);
        aggregationTypeList.add(TAggregationType.LAST_VALUE);
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        descriptorList = new ArrayList();
        for (TAggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.MAX_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
    }

    @Test
    public void getDeduplicatedDescriptorsTest4() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        PartialPath seriesPath2 = new PartialPath(new String[]{"root", "sg", "d1", "s2"});
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        descriptorList.add(new AggregationDescriptor(TAggregationType.AVG.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        descriptorList.add(new AggregationDescriptor(TAggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath2))));
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.COUNT, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
        descriptorList = new ArrayList();
        descriptorList.add(new AggregationDescriptor(TAggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        descriptorList.add(new AggregationDescriptor(TAggregationType.MIN_TIME.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath2))));
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.MIN_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
        descriptorList = new ArrayList();
        descriptorList.add(new AggregationDescriptor(TAggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        descriptorList.add(new AggregationDescriptor(TAggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath2))));
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)TAggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)TAggregationType.MAX_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
    }
}

