/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.pipe;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedInsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class PipeEnrichedInsertNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        InsertRowNode insertRowNode = this.getInsertRowNode();
        PipeEnrichedInsertNode pipeEnrichedInsertNode = new PipeEnrichedInsertNode((InsertNode)insertRowNode);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        pipeEnrichedInsertNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.PIPE_ENRICHED_INSERT_DATA.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((long)PlanNodeType.INSERT_ROW.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertRowNode, (Object)InsertRowNode.deserialize((ByteBuffer)byteBuffer));
    }

    private InsertRowNode getInsertRowNode() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false};
        return new InsertRowNode(new PlanNodeId("plannode 1"), new PartialPath("root.isp.d1"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, time, columns, false);
    }
}

