/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.metadata.write;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ConstructSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeleteTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.PreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackPreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.ConstructLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.DeleteLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.RollbackLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;

public class MetadataWriteNodeSerDeTest {
    @Test
    public void testActivateTemplateNode() throws IllegalPathException {
        PlanNodeId planNodeId = new PlanNodeId("ActivateTemplateNode");
        ActivateTemplateNode activateTemplateNode = new ActivateTemplateNode(planNodeId, new PartialPath("root.sg.d1.s1"), 2, 1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        activateTemplateNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)activateTemplateNode, (Object)deserializedNode);
    }

    @Test
    public void testAlterTimeSeriesNode() throws IllegalPathException {
        PlanNodeId planNodeId = new PlanNodeId("AlterTimeSeriesNode");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        AlterTimeSeriesNode alterTimeSeriesNode = new AlterTimeSeriesNode(planNodeId, new PartialPath("root.sg.d1.s1"), AlterTimeSeriesStatement.AlterType.RENAME, map, "alias", map, map, false);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        alterTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)alterTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testBatchActivateTemplateNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("batchActivateTemplateNode");
        HashMap<PartialPath, Pair> map = new HashMap<PartialPath, Pair>();
        map.put(new PartialPath("root.db.d1.s1"), new Pair((Object)1, (Object)2));
        BatchActivateTemplateNode batchActivateTemplateNode = new BatchActivateTemplateNode(planNodeId, map);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        batchActivateTemplateNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)batchActivateTemplateNode, (Object)deserializedNode);
    }

    @Test
    public void testConstructSchemaBlackListNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("ConstructSchemaBlackListNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        ConstructSchemaBlackListNode constructSchemaBlackListNode = new ConstructSchemaBlackListNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        constructSchemaBlackListNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)constructSchemaBlackListNode, (Object)deserializedNode);
    }

    @Test
    public void testCreateAlignedTimeSeriesNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("CreateAlignedTimeSeriesNode");
        CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode = new CreateAlignedTimeSeriesNode(planNodeId, new PartialPath("root.db.d1"), Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT32, TSDataType.INT64), Arrays.asList(TSEncoding.PLAIN, TSEncoding.RLE), Arrays.asList(CompressionType.GZIP, CompressionType.ZSTD), Arrays.asList("a1", "a2"), Arrays.asList(null, null), Arrays.asList(null, null));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        createAlignedTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)createAlignedTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testCreateMultiTimeSeriesNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("CreateMultiTimeSeriesNode");
        MeasurementGroup measurementGroup = new MeasurementGroup();
        measurementGroup.addMeasurement("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.GZIP);
        HashMap<PartialPath, MeasurementGroup> deviceMap = new HashMap<PartialPath, MeasurementGroup>();
        deviceMap.put(new PartialPath("root.db"), measurementGroup);
        CreateMultiTimeSeriesNode createAlignedTimeSeriesNode = new CreateMultiTimeSeriesNode(planNodeId, deviceMap);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        createAlignedTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)createAlignedTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testCreateTimeSeriesNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("CreateTimeSeriesNode");
        CreateTimeSeriesNode createTimeSeriesNode = new CreateTimeSeriesNode(planNodeId, new PartialPath("root.db.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, "alias");
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        createTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)createTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testDeactivateTemplateNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("DeactivateTemplateNode");
        HashMap<PartialPath, List<Integer>> map = new HashMap<PartialPath, List<Integer>>();
        map.put(new PartialPath("root.db.d1"), Arrays.asList(1, 2));
        DeactivateTemplateNode deactivateTemplateNode = new DeactivateTemplateNode(planNodeId, map);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deactivateTemplateNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)deactivateTemplateNode, (Object)deserializedNode);
    }

    @Test
    public void testDeleteTimeSeriesNode() throws IllegalPathException {
        PlanNodeId planNodeId = new PlanNodeId("DeleteTimeSeriesNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        DeleteTimeSeriesNode deleteTimeSeriesNode = new DeleteTimeSeriesNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deleteTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)deleteTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testInternalBatchActivateTemplateNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("InternalBatchActivateTemplateNode");
        HashMap<PartialPath, Pair> map = new HashMap<PartialPath, Pair>();
        map.put(new PartialPath("root.db.d1.s1"), new Pair((Object)1, (Object)2));
        InternalBatchActivateTemplateNode internalBatchActivateTemplateNode = new InternalBatchActivateTemplateNode(planNodeId, map);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        internalBatchActivateTemplateNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)internalBatchActivateTemplateNode, (Object)deserializedNode);
    }

    @Test
    public void testInternalCreateMultiTimeSeriesNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("InternalCreateMultiTimeSeriesNode");
        MeasurementGroup measurementGroup = new MeasurementGroup();
        measurementGroup.addMeasurement("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.GZIP);
        HashMap<PartialPath, Pair> deviceMap = new HashMap<PartialPath, Pair>();
        deviceMap.put(new PartialPath("root.db"), new Pair((Object)false, (Object)measurementGroup));
        InternalCreateMultiTimeSeriesNode internalCreateMultiTimeSeriesNode = new InternalCreateMultiTimeSeriesNode(planNodeId, deviceMap);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        internalCreateMultiTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)internalCreateMultiTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testInternalCreateTimeSeriesNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("InternalCreateTimeSeriesNode");
        MeasurementGroup measurementGroup = new MeasurementGroup();
        measurementGroup.addMeasurement("s1", TSDataType.INT64, TSEncoding.PLAIN, CompressionType.GZIP);
        InternalCreateTimeSeriesNode internalCreateTimeSeriesNode = new InternalCreateTimeSeriesNode(planNodeId, new PartialPath("root.db.d1"), measurementGroup, false);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        internalCreateTimeSeriesNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)internalCreateTimeSeriesNode, (Object)deserializedNode);
    }

    @Test
    public void testPreDeactivateTemplateNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("PreDeactivateTemplateNode");
        HashMap<PartialPath, List<Integer>> map = new HashMap<PartialPath, List<Integer>>();
        map.put(new PartialPath("root.db.d1"), Arrays.asList(1, 2));
        PreDeactivateTemplateNode preDeactivateTemplateNode = new PreDeactivateTemplateNode(planNodeId, map);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        preDeactivateTemplateNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)preDeactivateTemplateNode, (Object)deserializedNode);
    }

    @Test
    public void testRollbackPreDeactivateTemplateNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("RollbackPreDeactivateTemplateNode");
        HashMap<PartialPath, List<Integer>> map = new HashMap<PartialPath, List<Integer>>();
        map.put(new PartialPath("root.db.d1"), Arrays.asList(1, 2));
        RollbackPreDeactivateTemplateNode rollbackPreDeactivateTemplateNode = new RollbackPreDeactivateTemplateNode(planNodeId, map);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        rollbackPreDeactivateTemplateNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)rollbackPreDeactivateTemplateNode, (Object)deserializedNode);
    }

    @Test
    public void testRollbackSchemaBlackListNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("RollbackSchemaBlackListNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        RollbackSchemaBlackListNode rollbackSchemaBlackListNode = new RollbackSchemaBlackListNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        rollbackSchemaBlackListNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)rollbackSchemaBlackListNode, (Object)deserializedNode);
    }

    @Test
    public void testAlterLogicalViewNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("AlterLogicalViewNode");
        HashMap<PartialPath, TimeSeriesViewOperand> viewPathToSourceMap = new HashMap<PartialPath, TimeSeriesViewOperand>();
        viewPathToSourceMap.put(new PartialPath("root.sg1.d1"), new TimeSeriesViewOperand("root.sg1.d1"));
        AlterLogicalViewNode alterLogicalViewNode = new AlterLogicalViewNode(planNodeId, viewPathToSourceMap);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        alterLogicalViewNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)alterLogicalViewNode, (Object)deserializedNode);
    }

    @Test
    public void testConstructLogicalViewBlackListNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("ConstructLogicalViewBlackListNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        ConstructLogicalViewBlackListNode constructLogicalViewBlackListNode = new ConstructLogicalViewBlackListNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        constructLogicalViewBlackListNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)constructLogicalViewBlackListNode, (Object)deserializedNode);
    }

    @Test
    public void testCreateLogicalViewNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("CreateLogicalViewNode");
        HashMap<PartialPath, TimeSeriesViewOperand> viewPathToSourceMap = new HashMap<PartialPath, TimeSeriesViewOperand>();
        viewPathToSourceMap.put(new PartialPath("root.sg1.d1"), new TimeSeriesViewOperand("root.sg1.d1"));
        CreateLogicalViewNode createLogicalViewNode = new CreateLogicalViewNode(planNodeId, viewPathToSourceMap);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        createLogicalViewNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)createLogicalViewNode, (Object)deserializedNode);
    }

    @Test
    public void testDeleteLogicalViewNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("DeleteLogicalViewNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        DeleteLogicalViewNode deleteLogicalViewNode = new DeleteLogicalViewNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        deleteLogicalViewNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)deleteLogicalViewNode, (Object)deserializedNode);
    }

    @Test
    public void testRollbackLogicalViewBlackListNode() throws Exception {
        PlanNodeId planNodeId = new PlanNodeId("RollbackLogicalViewBlackListNode");
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.d1.s1"));
        patternTree.appendPathPattern(new PartialPath("root.sg.d2.*"));
        patternTree.constructTree();
        RollbackLogicalViewBlackListNode rollbackLogicalViewBlackListNode = new RollbackLogicalViewBlackListNode(planNodeId, patternTree);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        rollbackLogicalViewBlackListNode.serialize(byteBuffer);
        byteBuffer.flip();
        PlanNode deserializedNode = PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)rollbackLogicalViewBlackListNode, (Object)deserializedNode);
    }
}

