/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.metadata.read;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.junit.Assert;
import org.junit.Test;

public class SchemaFetchMergeNodeTest {
    @Test
    public void testSerialization() throws IllegalPathException {
        SchemaFetchMergeNode schemaFetchMergeNode = new SchemaFetchMergeNode(new PlanNodeId("0"), Arrays.asList("root.db1", "root.db2"));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.**.*"));
        SchemaFetchScanNode schemaFetchScanNode = new SchemaFetchScanNode(new PlanNodeId("0"), new PartialPath("root.sg"), patternTree, Collections.emptyMap(), true, true);
        schemaFetchMergeNode.addChild((PlanNode)schemaFetchScanNode);
        ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
        schemaFetchMergeNode.serialize(byteBuffer);
        byteBuffer.flip();
        SchemaFetchMergeNode recoveredNode = (SchemaFetchMergeNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)schemaFetchMergeNode, (Object)recoveredNode);
    }
}

