/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.metadata.read;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.DevicesCountNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.LevelTimeSeriesCountNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.TimeSeriesCountNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.junit.Assert;
import org.junit.Test;

public class SchemaCountNodeSerdeTest {
    @Test
    public void testDevicesCountSerializeAndDeserialize() throws IllegalPathException {
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(new PlanNodeId("countMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        DevicesCountNode devicesCountNode = new DevicesCountNode(new PlanNodeId("devicesCount"), new PartialPath("root.sg.device0"), true, SchemaConstant.ALL_MATCH_SCOPE);
        IdentitySinkNode sinkNode = new IdentitySinkNode(new PlanNodeId("sink"), Collections.singletonList(devicesCountNode), Collections.singletonList(new DownStreamChannelLocation(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds").toThrift(), new PlanNodeId("test").getId())));
        countMergeNode.addChild((PlanNode)sinkNode);
        exchangeNode.addChild((PlanNode)sinkNode);
        exchangeNode.setOutputColumnNames(exchangeNode.getChild().getOutputColumnNames());
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        ExchangeNode exchangeNode1 = (ExchangeNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)exchangeNode, (Object)exchangeNode1);
    }

    @Test
    public void testLevelTimeSeriesCountSerializeAndDeserialize() throws IllegalPathException {
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(new PlanNodeId("countMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        LevelTimeSeriesCountNode levelTimeSeriesCountNode = new LevelTimeSeriesCountNode(new PlanNodeId("timeseriesCount"), new PartialPath("root.sg.device0"), true, 10, null, Collections.emptyMap(), SchemaConstant.ALL_MATCH_SCOPE);
        IdentitySinkNode sinkNode = new IdentitySinkNode(new PlanNodeId("sink"), Collections.singletonList(levelTimeSeriesCountNode), Collections.singletonList(new DownStreamChannelLocation(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds").toThrift(), new PlanNodeId("test").getId())));
        countMergeNode.addChild((PlanNode)exchangeNode);
        exchangeNode.addChild((PlanNode)sinkNode);
        exchangeNode.setOutputColumnNames(exchangeNode.getChild().getOutputColumnNames());
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        ExchangeNode exchangeNode1 = (ExchangeNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)exchangeNode, (Object)exchangeNode1);
    }

    @Test
    public void testTimeSeriesCountSerializeAndDeserialize() throws IllegalPathException {
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(new PlanNodeId("countMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        TimeSeriesCountNode timeseriesCount = new TimeSeriesCountNode(new PlanNodeId("timeseriesCount"), new PartialPath("root.sg.device0"), true, null, Collections.emptyMap(), SchemaConstant.ALL_MATCH_SCOPE);
        IdentitySinkNode sinkNode = new IdentitySinkNode(new PlanNodeId("sink"), Collections.singletonList(timeseriesCount), Collections.singletonList(new DownStreamChannelLocation(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds").toThrift(), new PlanNodeId("test").getId())));
        countMergeNode.addChild((PlanNode)exchangeNode);
        exchangeNode.addChild((PlanNode)sinkNode);
        exchangeNode.setOutputColumnNames(exchangeNode.getChild().getOutputColumnNames());
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        ExchangeNode exchangeNode1 = (ExchangeNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)exchangeNode, (Object)exchangeNode1);
    }
}

