/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.metadata.read;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelLocation;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.DevicesSchemaScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.junit.Assert;
import org.junit.Test;

public class DeviceSchemaScanNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        OffsetNode offsetNode = new OffsetNode(new PlanNodeId("offset"), 10L);
        LimitNode limitNode = new LimitNode(new PlanNodeId("limit"), 10L);
        SchemaQueryMergeNode schemaMergeNode = new SchemaQueryMergeNode(new PlanNodeId("schemaMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        DevicesSchemaScanNode devicesSchemaScanNode = new DevicesSchemaScanNode(new PlanNodeId("deviceSchemaScan"), new PartialPath("root.sg.device0"), 10L, 10L, false, false, null, SchemaConstant.ALL_MATCH_SCOPE);
        IdentitySinkNode sinkNode = new IdentitySinkNode(new PlanNodeId("sink"), Collections.singletonList(devicesSchemaScanNode), Collections.singletonList(new DownStreamChannelLocation(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds").toThrift(), new PlanNodeId("test").getId())));
        devicesSchemaScanNode.addChild((PlanNode)sinkNode);
        exchangeNode.addChild((PlanNode)schemaMergeNode);
        exchangeNode.setOutputColumnNames(exchangeNode.getChild().getOutputColumnNames());
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        offsetNode.addChild((PlanNode)exchangeNode);
        limitNode.addChild((PlanNode)offsetNode);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        limitNode.serialize(byteBuffer);
        byteBuffer.flip();
        LimitNode limitNode1 = (LimitNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)limitNode, (Object)limitNode1);
    }
}

