/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node.load;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.junit.Assert;
import org.junit.Test;

public class LoadTsFileNodeTest {
    @Test
    public void testLoadSingleTsFileNode() {
        TsFileResource resource = new TsFileResource(new File("1"));
        LoadSingleTsFileNode node = new LoadSingleTsFileNode(new PlanNodeId(""), resource, true, 0L);
        Assert.assertTrue((boolean)node.isDeleteAfterLoad());
        Assert.assertEquals((Object)resource, (Object)node.getTsFileResource());
        Assert.assertNull((Object)node.getLocalRegionReplicaSet());
        Assert.assertNull((Object)node.getRegionReplicaSet());
        Assert.assertEquals(Collections.emptyList(), (Object)node.getChildren());
        Assert.assertEquals(Collections.emptyList(), (Object)node.getOutputColumnNames());
        try {
            node.clone();
            Assert.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            node.splitByPartition(new Analysis());
            Assert.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)node.allowedChildCount());
        Assert.assertEquals((Object)"LoadSingleTsFileNode{tsFile=1, needDecodeTsFile=false}", (Object)node.toString());
        node.clean();
    }

    @Test
    public void testLoadTsFilePieceNode() {
        LoadTsFilePieceNode node = new LoadTsFilePieceNode(new PlanNodeId(""), new File("1"));
        Assert.assertEquals((long)0L, (long)node.getDataSize());
        Assert.assertEquals(new ArrayList(), (Object)node.getAllTsFileData());
        Assert.assertEquals((Object)node.getTsFile(), (Object)new File("1"));
        Assert.assertNull((Object)node.getRegionReplicaSet());
        Assert.assertEquals(Collections.emptyList(), (Object)node.getChildren());
        try {
            node.clone();
            Assert.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            node.splitByPartition(new Analysis());
            Assert.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)node.allowedChildCount());
        Assert.assertEquals((Object)"LoadTsFilePieceNode{tsFile=1, dataSize=0}", (Object)node.toString());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        node.serialize(buffer);
        LoadTsFilePieceNode node1 = (LoadTsFilePieceNode)LoadTsFilePieceNode.deserialize((ByteBuffer)buffer);
        Assert.assertEquals((Object)node.getTsFile(), (Object)node1.getTsFile());
    }
}

