/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanGraphPrinter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TopKNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.junit.Assert;
import org.junit.Test;

public class PlanGraphPrinterTest {
    @Test
    public void topKNodeTest() throws IllegalPathException {
        OrderByParameter orderByParameter = new OrderByParameter(Arrays.asList(new SortItem("Device", Ordering.ASC), new SortItem("Time", Ordering.DESC)));
        TopKNode topKNode = new TopKNode(new PlanNodeId("1"), 2, orderByParameter, Arrays.asList("Device", "Time", "s1"));
        DeviceViewNode deviceViewNode = new DeviceViewNode(new PlanNodeId("2"), new OrderByParameter(), Collections.emptyList(), Collections.emptyMap());
        SeriesScanNode scanNode = new SeriesScanNode(new PlanNodeId("3"), new MeasurementPath("s1"));
        deviceViewNode.addChildDeviceNode("d1", (PlanNode)scanNode);
        topKNode.addChild((PlanNode)deviceViewNode);
        List result = PlanGraphPrinter.getGraph((PlanNode)topKNode);
        Assert.assertEquals((long)18L, (long)result.size());
        Assert.assertEquals((Object)"\u2502TopK-1                                 \u2502", result.get(1));
        Assert.assertEquals((Object)"            \u2502DeviceView-2  \u2502             ", result.get(8));
        Assert.assertEquals((Object)"        \u2502SeriesScan-3           \u2502        ", result.get(14));
    }
}

