/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.logical;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.impl.PathContainsFilter;
import org.apache.iotdb.commons.schema.filter.impl.TagFilter;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.logical.LogicalPlannerTestUtil;
import org.apache.iotdb.db.queryengine.plan.planner.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.DevicesSchemaScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.NodeManagementMemoryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.NodePathsConvertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.NodePathsCountNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.NodePathsSchemaScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryOrderByHeatNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.TimeSeriesSchemaScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class SchemaQueryLogicalPlannerTest {
    @Test
    public void testCreateTimeseriesPlan() {
        String sql = "CREATE TIMESERIES root.ln.wf01.wt01.status(\u72b6\u6001) BOOLEAN ENCODING=PLAIN COMPRESSOR=SNAPPY TAGS('tag1'='v1', 'tag2'='v2') ATTRIBUTES('attr1'='v1', 'attr2'='v2')";
        try {
            CreateTimeSeriesNode createTimeSeriesNode = (CreateTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)createTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)createTimeSeriesNode.getPath());
            Assert.assertEquals((Object)"\u72b6\u6001", (Object)createTimeSeriesNode.getAlias());
            Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)createTimeSeriesNode.getDataType());
            Assert.assertEquals((Object)TSEncoding.PLAIN, (Object)createTimeSeriesNode.getEncoding());
            Assert.assertEquals((Object)CompressionType.SNAPPY, (Object)createTimeSeriesNode.getCompressor());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag1", "v1");
                    this.put("tag2", "v2");
                }
            }, (Object)createTimeSeriesNode.getTags());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("attr1", "v1");
                    this.put("attr2", "v2");
                }
            }, (Object)createTimeSeriesNode.getAttributes());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreateAlignedTimeseriesPlan() {
        String sql = "CREATE ALIGNED TIMESERIES root.ln.wf01.GPS(latitude(meter1) FLOAT encoding=PLAIN compressor=SNAPPY tags('tag1'='t1') attributes('attr1'='a1'), longitude FLOAT encoding=PLAIN compressor=SNAPPY)";
        try {
            CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode = (CreateAlignedTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)createAlignedTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.GPS"), (Object)createAlignedTimeSeriesNode.getDevicePath());
            Assert.assertEquals((Object)new ArrayList<String>(){
                {
                    this.add("meter1");
                    this.add(null);
                }
            }, (Object)createAlignedTimeSeriesNode.getAliasList());
            Assert.assertEquals((Object)new ArrayList<TSDataType>(){
                {
                    this.add(TSDataType.FLOAT);
                    this.add(TSDataType.FLOAT);
                }
            }, (Object)createAlignedTimeSeriesNode.getDataTypes());
            Assert.assertEquals((Object)new ArrayList<TSEncoding>(){
                {
                    this.add(TSEncoding.PLAIN);
                    this.add(TSEncoding.PLAIN);
                }
            }, (Object)createAlignedTimeSeriesNode.getEncodings());
            Assert.assertEquals((Object)new ArrayList<CompressionType>(){
                {
                    this.add(CompressionType.SNAPPY);
                    this.add(CompressionType.SNAPPY);
                }
            }, (Object)createAlignedTimeSeriesNode.getCompressors());
            Assert.assertEquals((Object)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("attr1", "a1");
                        }
                    });
                    this.add(null);
                }
            }, (Object)createAlignedTimeSeriesNode.getAttributesList());
            Assert.assertEquals((Object)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("tag1", "t1");
                        }
                    });
                    this.add(null);
                }
            }, (Object)createAlignedTimeSeriesNode.getTagsList());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
            createAlignedTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode1 = (CreateAlignedTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)createAlignedTimeSeriesNode, (Object)createAlignedTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreateMultiTimeSeriesPlan() {
        try {
            TSCreateMultiTimeseriesReq req = new TSCreateMultiTimeseriesReq();
            req.setPaths((List)new ArrayList<String>(){
                {
                    this.add("root.sg1.d2.s1");
                    this.add("root.sg1.d2.s2");
                }
            });
            req.setMeasurementAliasList((List)new ArrayList<String>(){
                {
                    this.add("meter1");
                    this.add(null);
                }
            });
            req.setDataTypes((List)new ArrayList<Integer>(){
                {
                    this.add(TSDataType.FLOAT.ordinal());
                    this.add(TSDataType.FLOAT.ordinal());
                }
            });
            req.setEncodings((List)new ArrayList<Integer>(){
                {
                    this.add(TSEncoding.PLAIN.ordinal());
                    this.add(TSEncoding.PLAIN.ordinal());
                }
            });
            req.setCompressors((List)new ArrayList<Integer>(){
                {
                    this.add(CompressionType.SNAPPY.ordinal());
                    this.add(CompressionType.SNAPPY.ordinal());
                }
            });
            req.setAttributesList((List)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("attr1", "a1");
                        }
                    });
                    this.add(null);
                }
            });
            req.setTagsList((List)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("tag1", "t1");
                        }
                    });
                    this.add(null);
                }
            });
            CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement = StatementGenerator.createStatement((TSCreateMultiTimeseriesReq)req);
            CreateMultiTimeSeriesNode createMultiTimeSeriesNode = (CreateMultiTimeSeriesNode)LogicalPlannerTestUtil.analyzeStatementToPlanNode((Statement)createMultiTimeSeriesStatement);
            ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
            createMultiTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            CreateMultiTimeSeriesNode createMultiTimeSeriesNode1 = (CreateMultiTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)createMultiTimeSeriesNode, (Object)createMultiTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testAlterTimeseriesPlan() {
        AlterTimeSeriesNode alterTimeSeriesNode1;
        ByteBuffer byteBuffer;
        AlterTimeSeriesNode alterTimeSeriesNode;
        String sql = "ALTER timeseries root.turbine.d1.s1 RENAME 'tag1' TO 'newTag1'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.RENAME, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag1", "newTag1");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)alterTimeSeriesNode, (Object)alterTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 SET 'newTag1'='newV1', 'attr1'='newV1'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.SET, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("newTag1", "newV1");
                    this.put("attr1", "newV1");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)alterTimeSeriesNode, (Object)alterTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 DROP 'tag1', 'tag2'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.DROP, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag1", null);
                    this.put("tag2", null);
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)alterTimeSeriesNode, (Object)alterTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 ADD TAGS 'tag3'='v3', 'tag4'='v4'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.ADD_TAGS, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag3", "v3");
                    this.put("tag4", "v4");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)alterTimeSeriesNode, (Object)alterTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 ADD ATTRIBUTES 'attr3'='v3', 'attr4'='v4'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.ADD_ATTRIBUTES, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("attr3", "v3");
                    this.put("attr4", "v4");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)alterTimeSeriesNode, (Object)alterTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 UPSERT ALIAS='newAlias' TAGS('tag2'='newV2', 'tag3'='v3') ATTRIBUTES('attr3'='v3', 'attr4'='v4')";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.UPSERT, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag2", "newV2");
                    this.put("tag3", "v3");
                }
            }, (Object)alterTimeSeriesNode.getTagsMap());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("attr3", "v3");
                    this.put("attr4", "v4");
                }
            }, (Object)alterTimeSeriesNode.getAttributesMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)alterTimeSeriesNode, (Object)alterTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowTimeSeries() {
        String sql = "SHOW LATEST TIMESERIES root.ln.wf01.wt01.status WHERE TAGS(tagK) = 'tagV' limit 20 offset 10";
        try {
            LimitNode limitNode = (LimitNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            OffsetNode offsetNode = (OffsetNode)limitNode.getChild();
            SchemaQueryOrderByHeatNode schemaQueryOrderByHeatNode = (SchemaQueryOrderByHeatNode)offsetNode.getChild();
            SchemaQueryMergeNode metaMergeNode = (SchemaQueryMergeNode)schemaQueryOrderByHeatNode.getChildren().get(0);
            metaMergeNode.getChildren().forEach(n -> System.out.println(n.toString()));
            TimeSeriesSchemaScanNode showTimeSeriesNode = (TimeSeriesSchemaScanNode)metaMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)showTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)showTimeSeriesNode.getPath());
            Assert.assertEquals((Object)"root.ln.wf01.wt01", (Object)showTimeSeriesNode.getPath().getDevice());
            Assert.assertTrue((boolean)showTimeSeriesNode.isOrderByHeat());
            Assert.assertEquals((Object)SchemaFilterType.TAGS_FILTER, (Object)showTimeSeriesNode.getSchemaFilter().getSchemaFilterType());
            Assert.assertFalse((boolean)((TagFilter)showTimeSeriesNode.getSchemaFilter()).isContains());
            Assert.assertEquals((Object)"tagK", (Object)((TagFilter)showTimeSeriesNode.getSchemaFilter()).getKey());
            Assert.assertEquals((Object)"tagV", (Object)((TagFilter)showTimeSeriesNode.getSchemaFilter()).getValue());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode.getLimit());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode.getOffset());
            Assert.assertFalse((boolean)showTimeSeriesNode.isHasLimit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            showTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            TimeSeriesSchemaScanNode showTimeSeriesNode2 = (TimeSeriesSchemaScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
            Assert.assertNotNull((Object)showTimeSeriesNode2);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)showTimeSeriesNode2.getPath());
            Assert.assertEquals((Object)"root.ln.wf01.wt01", (Object)showTimeSeriesNode2.getPath().getDevice());
            Assert.assertTrue((boolean)showTimeSeriesNode2.isOrderByHeat());
            Assert.assertEquals((Object)SchemaFilterType.TAGS_FILTER, (Object)showTimeSeriesNode2.getSchemaFilter().getSchemaFilterType());
            Assert.assertFalse((boolean)((TagFilter)showTimeSeriesNode2.getSchemaFilter()).isContains());
            Assert.assertEquals((Object)"tagK", (Object)((TagFilter)showTimeSeriesNode2.getSchemaFilter()).getKey());
            Assert.assertEquals((Object)"tagV", (Object)((TagFilter)showTimeSeriesNode2.getSchemaFilter()).getValue());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode2.getLimit());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode2.getOffset());
            Assert.assertFalse((boolean)showTimeSeriesNode2.isHasLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowTimeSeriesWherePathContains() {
        String sql = "SHOW LATEST TIMESERIES root.ln.wf01.wt01.status WHERE timeseries contains 'us' limit 20 offset 10";
        try {
            LimitNode limitNode = (LimitNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            OffsetNode offsetNode = (OffsetNode)limitNode.getChild();
            SchemaQueryOrderByHeatNode schemaQueryOrderByHeatNode = (SchemaQueryOrderByHeatNode)offsetNode.getChild();
            SchemaQueryMergeNode metaMergeNode = (SchemaQueryMergeNode)schemaQueryOrderByHeatNode.getChildren().get(0);
            metaMergeNode.getChildren().forEach(n -> System.out.println(n.toString()));
            TimeSeriesSchemaScanNode showTimeSeriesNode = (TimeSeriesSchemaScanNode)metaMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)showTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)showTimeSeriesNode.getPath());
            Assert.assertEquals((Object)"root.ln.wf01.wt01", (Object)showTimeSeriesNode.getPath().getDevice());
            Assert.assertTrue((boolean)showTimeSeriesNode.isOrderByHeat());
            Assert.assertEquals((Object)SchemaFilterType.PATH_CONTAINS, (Object)showTimeSeriesNode.getSchemaFilter().getSchemaFilterType());
            Assert.assertEquals((Object)"us", (Object)((PathContainsFilter)showTimeSeriesNode.getSchemaFilter()).getContainString());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode.getLimit());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode.getOffset());
            Assert.assertFalse((boolean)showTimeSeriesNode.isHasLimit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            showTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            TimeSeriesSchemaScanNode showTimeSeriesNode2 = (TimeSeriesSchemaScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
            Assert.assertNotNull((Object)showTimeSeriesNode2);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)showTimeSeriesNode2.getPath());
            Assert.assertEquals((Object)"root.ln.wf01.wt01", (Object)showTimeSeriesNode2.getPath().getDevice());
            Assert.assertTrue((boolean)showTimeSeriesNode2.isOrderByHeat());
            Assert.assertEquals((Object)SchemaFilterType.PATH_CONTAINS, (Object)showTimeSeriesNode2.getSchemaFilter().getSchemaFilterType());
            Assert.assertEquals((Object)"us", (Object)((PathContainsFilter)showTimeSeriesNode2.getSchemaFilter()).getContainString());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode2.getLimit());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode2.getOffset());
            Assert.assertFalse((boolean)showTimeSeriesNode2.isHasLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowDevices() {
        String sql = "SHOW DEVICES root.ln.wf01.wt01 WITH DATABASE limit 20 offset 10";
        try {
            LimitNode limitNode = (LimitNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            OffsetNode offsetNode = (OffsetNode)limitNode.getChild();
            SchemaQueryMergeNode metaMergeNode = (SchemaQueryMergeNode)offsetNode.getChild();
            DevicesSchemaScanNode showDevicesNode = (DevicesSchemaScanNode)metaMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)showDevicesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01"), (Object)showDevicesNode.getPath());
            Assert.assertTrue((boolean)showDevicesNode.isHasSgCol());
            Assert.assertEquals((long)30L, (long)showDevicesNode.getLimit());
            Assert.assertEquals((long)0L, (long)showDevicesNode.getOffset());
            Assert.assertTrue((boolean)showDevicesNode.isHasLimit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            showDevicesNode.serialize(byteBuffer);
            byteBuffer.flip();
            DevicesSchemaScanNode showDevicesNode2 = (DevicesSchemaScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
            Assert.assertNotNull((Object)showDevicesNode2);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01"), (Object)showDevicesNode2.getPath());
            Assert.assertEquals((long)30L, (long)showDevicesNode2.getLimit());
            Assert.assertEquals((long)0L, (long)showDevicesNode2.getOffset());
            Assert.assertTrue((boolean)showDevicesNode2.isHasLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowDevicesWherePathContains() {
        String sql = "SHOW DEVICES root.ln.wf01.wt01 WHERE device contains 'wt' limit 20 offset 10";
        try {
            LimitNode limitNode = (LimitNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            OffsetNode offsetNode = (OffsetNode)limitNode.getChild();
            SchemaQueryMergeNode metaMergeNode = (SchemaQueryMergeNode)offsetNode.getChild();
            DevicesSchemaScanNode showDevicesNode = (DevicesSchemaScanNode)metaMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)showDevicesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01"), (Object)showDevicesNode.getPath());
            Assert.assertFalse((boolean)showDevicesNode.isHasSgCol());
            Assert.assertEquals((Object)SchemaFilterType.PATH_CONTAINS, (Object)showDevicesNode.getSchemaFilter().getSchemaFilterType());
            Assert.assertEquals((Object)"wt", (Object)((PathContainsFilter)showDevicesNode.getSchemaFilter()).getContainString());
            Assert.assertEquals((long)30L, (long)showDevicesNode.getLimit());
            Assert.assertEquals((long)0L, (long)showDevicesNode.getOffset());
            Assert.assertTrue((boolean)showDevicesNode.isHasLimit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            showDevicesNode.serialize(byteBuffer);
            byteBuffer.flip();
            DevicesSchemaScanNode showDevicesNode2 = (DevicesSchemaScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
            Assert.assertNotNull((Object)showDevicesNode2);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01"), (Object)showDevicesNode2.getPath());
            Assert.assertFalse((boolean)showDevicesNode2.isHasSgCol());
            Assert.assertEquals((Object)SchemaFilterType.PATH_CONTAINS, (Object)showDevicesNode2.getSchemaFilter().getSchemaFilterType());
            Assert.assertEquals((Object)"wt", (Object)((PathContainsFilter)showDevicesNode2.getSchemaFilter()).getContainString());
            Assert.assertEquals((long)30L, (long)showDevicesNode2.getLimit());
            Assert.assertEquals((long)0L, (long)showDevicesNode2.getOffset());
            Assert.assertTrue((boolean)showDevicesNode2.isHasLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCountNodes() {
        String sql = "COUNT NODES root.ln LEVEL=1";
        try {
            NodePathsCountNode nodePathsCountNode = (NodePathsCountNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            NodeManagementMemoryMergeNode nodeManagementMemoryMergeNode = (NodeManagementMemoryMergeNode)nodePathsCountNode.getChildren().get(0);
            SchemaQueryMergeNode schemaQueryMergeNode = (SchemaQueryMergeNode)nodeManagementMemoryMergeNode.getChildren().get(0);
            NodePathsSchemaScanNode nodePathsSchemaScanNode = (NodePathsSchemaScanNode)schemaQueryMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)nodePathsSchemaScanNode);
            Assert.assertEquals((Object)new PartialPath("root.ln"), (Object)nodePathsSchemaScanNode.getPrefixPath());
            Assert.assertEquals((long)1L, (long)nodePathsSchemaScanNode.getLevel());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowChildPaths() {
        String sql = "SHOW CHILD PATHS root.ln";
        try {
            NodeManagementMemoryMergeNode memorySourceNode = (NodeManagementMemoryMergeNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            SchemaQueryMergeNode schemaQueryMergeNode = (SchemaQueryMergeNode)memorySourceNode.getChildren().get(0);
            NodePathsSchemaScanNode nodePathsSchemaScanNode = (NodePathsSchemaScanNode)schemaQueryMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)nodePathsSchemaScanNode);
            Assert.assertEquals((Object)new PartialPath("root.ln"), (Object)nodePathsSchemaScanNode.getPrefixPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowChildNodes() {
        String sql = "SHOW CHILD NODES root.ln";
        try {
            NodePathsConvertNode nodePathsConvertNode = (NodePathsConvertNode)LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            NodeManagementMemoryMergeNode memorySourceNode = (NodeManagementMemoryMergeNode)nodePathsConvertNode.getChildren().get(0);
            SchemaQueryMergeNode schemaQueryMergeNode = (SchemaQueryMergeNode)memorySourceNode.getChildren().get(0);
            NodePathsSchemaScanNode nodePathsSchemaScanNode = (NodePathsSchemaScanNode)schemaQueryMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)nodePathsConvertNode);
            Assert.assertEquals((Object)new PartialPath("root.ln"), (Object)nodePathsSchemaScanNode.getPrefixPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGroupByTag() {
        String sql = "select max_value(s1) from root.** group by tags(key1)";
        try {
            PlanNode pn = LogicalPlannerTestUtil.parseSQLToPlanNode(sql);
            GroupByTagNode root = (GroupByTagNode)pn;
            Assert.assertEquals(Collections.singletonList("key1"), (Object)root.getTagKeys());
            Map tagValuesToAggregationDescriptors = root.getTagValuesToAggregationDescriptors();
            Assert.assertEquals((long)1L, (long)tagValuesToAggregationDescriptors.size());
            Assert.assertEquals(Collections.singleton(Collections.singletonList("value1")), tagValuesToAggregationDescriptors.keySet());
            List descriptors = (List)tagValuesToAggregationDescriptors.get(Collections.singletonList("value1"));
            Assert.assertEquals((long)1L, (long)descriptors.size());
            CrossSeriesAggregationDescriptor descriptor = (CrossSeriesAggregationDescriptor)descriptors.get(0);
            Assert.assertEquals((Object)"s1", (Object)((Expression)descriptor.getOutputExpressions().get(0)).toString());
            Assert.assertEquals((Object)TAggregationType.MAX_VALUE, (Object)descriptor.getAggregationType());
            Assert.assertEquals((Object)AggregationStep.FINAL, (Object)descriptor.getStep());
            Assert.assertEquals((long)3L, (long)descriptor.getInputExpressions().size());
            for (Expression expression : descriptor.getInputExpressions()) {
                Assert.assertTrue((boolean)(expression instanceof TimeSeriesOperand));
                Assert.assertEquals((Object)"s1", (Object)((TimeSeriesOperand)expression).getPath().getMeasurement());
            }
            Assert.assertEquals(Arrays.asList("key1", "max_value(s1)"), (Object)root.getOutputColumnNames());
            Assert.assertNull((Object)root.getGroupByTimeParameter());
            Assert.assertEquals((Object)Ordering.ASC, (Object)root.getScanOrder());
            Assert.assertEquals((long)3L, (long)root.getChildren().size());
            for (PlanNode child : root.getChildren()) {
                Assert.assertTrue((child instanceof AlignedSeriesAggregationScanNode || child instanceof SeriesAggregationScanNode ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

