/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.Util;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryCollectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.junit.Assert;
import org.junit.Test;

public class LastQueryTest {
    @Test
    public void testLastQuery1Series1Region() throws IllegalPathException {
        String d2s1Path = "root.sg.d22.s1";
        MPPQueryContext context = new MPPQueryContext("", new QueryId("test_last_1_series_1_region"), null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(Util.constructAnalysis(), this.constructLastQuery(Collections.singletonList(d2s1Path), context));
        DistributedQueryPlan distributedQueryPlan = planner.planFragments();
        Assert.assertEquals((long)1L, (long)distributedQueryPlan.getInstances().size());
        Assert.assertTrue((boolean)(((FragmentInstance)distributedQueryPlan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0) instanceof LastQueryNode));
    }

    @Test
    public void testLastQuery1Series2Region() throws IllegalPathException {
        String d1s1Path = "root.sg.d1.s1";
        MPPQueryContext context = new MPPQueryContext("", new QueryId("test_last_1_series_2_region"), null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(Util.constructAnalysis(), this.constructLastQuery(Collections.singletonList(d1s1Path), context));
        DistributedQueryPlan distributedQueryPlan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)distributedQueryPlan.getInstances().size());
        PlanNode rootNode = (PlanNode)((FragmentInstance)distributedQueryPlan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(rootNode instanceof LastQueryMergeNode));
        rootNode.getChildren().forEach(child -> Assert.assertTrue((child instanceof LastQueryNode || child instanceof ExchangeNode ? 1 : 0) != 0));
    }

    @Test
    public void testLastQuery2Series3Region() throws IllegalPathException {
        String d1s1Path = "root.sg.d1.s1";
        String d2s1Path = "root.sg.d22.s1";
        MPPQueryContext context = new MPPQueryContext("", new QueryId("test_last_1_series_2_region"), null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(Util.constructAnalysis(), this.constructLastQuery(Arrays.asList(d1s1Path, d2s1Path), context));
        DistributedQueryPlan distributedQueryPlan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)distributedQueryPlan.getInstances().size());
        PlanNode rootNode = (PlanNode)((FragmentInstance)distributedQueryPlan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(rootNode instanceof LastQueryMergeNode));
        rootNode.getChildren().forEach(child -> Assert.assertTrue((child instanceof LastQueryNode || child instanceof ExchangeNode ? 1 : 0) != 0));
    }

    @Test
    public void testLastQuery2Series2Region() throws IllegalPathException {
        String d3s1Path = "root.sg.d333.s1";
        String d4s1Path = "root.sg.d4444.s1";
        MPPQueryContext context = new MPPQueryContext("", new QueryId("test_last_1_series_2_region"), null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(Util.constructAnalysis(), this.constructLastQuery(Arrays.asList(d3s1Path, d4s1Path), context));
        DistributedQueryPlan distributedQueryPlan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)distributedQueryPlan.getInstances().size());
        PlanNode rootNode = (PlanNode)((FragmentInstance)distributedQueryPlan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(rootNode instanceof LastQueryMergeNode));
        rootNode.getChildren().forEach(child -> Assert.assertTrue((child instanceof LastQueryNode || child instanceof ExchangeNode ? 1 : 0) != 0));
    }

    @Test
    public void testLastQuery2Series2DiffRegion() throws IllegalPathException {
        String d3s1Path = "root.sg.d22.s1";
        String d4s1Path = "root.sg.d55555.s1";
        MPPQueryContext context = new MPPQueryContext("", new QueryId("test_last_2_series_2_diff_region"), null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(Util.constructAnalysis(), this.constructLastQuery(Arrays.asList(d3s1Path, d4s1Path), context));
        DistributedQueryPlan distributedQueryPlan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)distributedQueryPlan.getInstances().size());
        PlanNode rootNode = (PlanNode)((FragmentInstance)distributedQueryPlan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0);
        Assert.assertTrue((boolean)(rootNode instanceof LastQueryCollectNode));
        rootNode.getChildren().forEach(child -> Assert.assertTrue((child instanceof LastQueryNode || child instanceof ExchangeNode ? 1 : 0) != 0));
    }

    private LogicalQueryPlan constructLastQuery(List<String> paths, MPPQueryContext context) throws IllegalPathException {
        ArrayList<Object> sourceNodeList = new ArrayList<Object>();
        for (String path : paths) {
            MeasurementPath selectPath = new MeasurementPath(path);
            if (selectPath.isUnderAlignedEntity()) {
                sourceNodeList.add(new AlignedLastQueryScanNode(context.getQueryId().genPlanNodeId(), new AlignedPath(selectPath), null));
                continue;
            }
            sourceNodeList.add(new LastQueryScanNode(context.getQueryId().genPlanNodeId(), selectPath, null));
        }
        LastQueryNode root = new LastQueryNode(context.getQueryId().genPlanNodeId(), sourceNodeList, null, false);
        return new LogicalQueryPlan(context, (PlanNode)root);
    }
}

